import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.glib.*;
import org.gnu.gtk.event.*;
import java.io.IOException;


/**
 * Begin the generation. Show progress. end the generation.
 */
public class ProgressPage extends WizardPage{

	Bridge bridge;
	
	/**
	 * 
	 */
	public ProgressPage(WizardForm wizard, WizardPage parent, Bridge bridge){
		super(wizard, parent, DomesdayGUI.messages.getString("ProgressTitle") );
		this.bridge = bridge;
	}


	Frame searchFrame;
	Frame genFrame;
	Label curFile;
	Label filesDone;
	ProgressBar scanProgress;
	Label searchDone;
	ProgressBar genProgress;
	
	/**
	 */
	protected void preShow(){
		System.out.println("progress page preshow.");

		/** Stores the content of the page, to be displayed on the output. */
		VBox mainVBox = new VBox(false, 5);

		Label head =  new Label( DomesdayGUI.messages.getString("ProgressHead") );
		head.setLineWrap(true);
		mainVBox.add(head);

		///////////////////////////////////////////////////
		// Search frame
		searchFrame = new Frame( DomesdayGUI.messages.getString("ProgressSearch") );
		mainVBox.add(searchFrame);
		VBox searchBox = new VBox(false, 5);
		searchFrame.add(searchBox);

		Label searchHead = new Label( DomesdayGUI.messages.getString("ProgressSearchHead") );
		searchHead.setLineWrap(true);
		searchBox.packStart(searchHead);

		curFile = new Label( DomesdayGUI.messages.getString("ProgressCurFile"));
		curFile.setLineWrap(true);
		searchBox.packStart(curFile);
		
		filesDone = new Label( DomesdayGUI.messages.getString("ProgressFilesDone"));
		filesDone.setLineWrap(true);
		searchBox.packStart(filesDone);

		scanProgress = new ProgressBar();
		searchBox.add(scanProgress);

		searchDone = new Label( DomesdayGUI.messages.getString("ProgressSearchDone") );
		searchDone.hide();
		searchBox.add(searchDone);		

		//////////////////////////////////////////////////
		// Generate index frame
		genFrame = new Frame( DomesdayGUI.messages.getString("ProgressGen") );
		genFrame.setSensitive(false);
		mainVBox.add(genFrame);

		VBox genBox = new VBox(false, 5);
		genFrame.add(genBox);

		Label genHead = new Label( DomesdayGUI.messages.getString("ProgressGenHead"));
		genHead.setLineWrap(true);
		genBox.packStart(genHead);
		
		genProgress = new ProgressBar();
		genBox.packStart(genProgress);

		//////////////////////////////////////////////////
		// Stop button

		Button stop = new Button( DomesdayGUI.messages.getString("ProgressStop") );
		stop.addListener( new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK)){
					System.out.println("\n!!!!!!!!!!!!!!!!Stop Not Yet Implemented!!!!!!!!!!!!!!!!!!!!\n\b");
					wizard.getTree().setSensitive(true);
					wizard.goNext();					
				}
			}
		});
		wizard.addHint(stop, new Hint( DomesdayGUI.messages.getString("ProgressStopHint") ) );
		HButtonBox bbox = new HButtonBox();
		bbox.add(stop);
		mainVBox.packStart(bbox);
		
		setButtonVisibility(false, false);
		setContent(mainVBox);
	}

	/**
	 * Start the generation process
	 */
	protected void onShow(){
		bridge.setProgress(this);
		wizard.getTree().setSensitive(false);
		bridge.start();
	}

	protected void postShow(){
		wizard.getTree().setSensitive(true);
	}

	public synchronized void complete(){
		((DomesdayGUI) wizard).generated();
		wizard.goNext();
	}

	public synchronized void startScan(){
		searchFrame.setSensitive(true);
		genFrame.setSensitive(false);
	}
	public synchronized void scanProgress(String current, int fileCount){
		curFile.setText(DomesdayGUI.messages.getString("ProgressCurFile") + current);
		filesDone.setText(DomesdayGUI.messages.getString("ProgressFilesDone") + fileCount);
		scanProgress.pulse();
	}

	public synchronized void startOutputGen(){
		searchDone.show();
		curFile.hide();
		filesDone.hide();
		scanProgress.hide();
		searchFrame.setSensitive(false);
		genFrame.setSensitive(true);
	}

}
