import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * Page for the hierarchy elements of the site map.
 */
public class SMHierarchyPage extends WizardPage{

	/**
	 * Constructs a new hierarchy page
	 */
	public SMHierarchyPage(WizardForm wizard, WizardPage parent){
		super(wizard, parent, DomesdayGUI.messages.getString("SMHierarchyTitle"));
	}

	/** enter dir text entry widget */
	private TextView enterView;
	/** enter dir Text entry buffer */
	private TextBuffer enterBuffer;

	/** exit dir text entry widget */
	private TextView exitView;
	/** exit dir Text entry buffer */
	private TextBuffer exitBuffer;
	
	/**
	 * Generate the widgets and set the defaults
	 */
	protected void preShow(){
		System.out.println("SMHierarchy preShow()");
		VBox mainVBox = new VBox(false, 5);

		Label intro = new Label( DomesdayGUI.messages.getString("SMHierarchyHead"));
		intro.setLineWrap(true);
		mainVBox.packStart(intro,false, false, 5);

		Label enter = new Label( DomesdayGUI.messages.getString("SMHierarchyEnter"));
		mainVBox.packStart(enter, false, false, 0);
	
		enterBuffer = new TextBuffer();
		enterView = new TextView(enterBuffer);
		enterView.setCursorVisible(true);
		try{
			System.out.println("Setting "+ DomesdayGUI.project.getStringSetting("SM_ENTER_FOLDER"));
			enterBuffer.setText(DomesdayGUI.project.getStringSetting("SM_ENTER_FOLDER"));
		}catch(Exception e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		
		ScrolledWindow win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(enterView);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);

		Label exit = new Label( DomesdayGUI.messages.getString("SMHierarchyExit"));
		mainVBox.packStart(exit, false, false, 0);

		exitBuffer = new TextBuffer();
		exitView = new TextView(exitBuffer);
		exitView.setCursorVisible(true);
		try{
			System.out.println("Setting "+ DomesdayGUI.project.getStringSetting("SM_LEAVE_FOLDER"));
			exitBuffer.setText(DomesdayGUI.project.getStringSetting("SM_LEAVE_FOLDER"));
		}catch(Exception e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
		

		win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(exitView);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);

		mainVBox.showAll();
		content =  mainVBox;
	}

	/**
	 * Save the settings
	 */
	protected void postShow(){
		try{
			DomesdayGUI.project.storeSettingByVar("SM_ENTER_FOLDER", enterBuffer.getText( enterBuffer.getStartIter(), enterBuffer.getEndIter(), false) );
			DomesdayGUI.project.storeSettingByVar("SM_LEAVE_FOLDER", exitBuffer.getText( exitBuffer.getStartIter(), exitBuffer.getEndIter(), false) );
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
	}
}
