import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.gtk.event.*;


/**
 * A page containging some header text and a textbox linked to a single setting
 * in the project object.
 */
public class SimpleTextPage extends WizardPage{

	/** Resource id for header data */
	private String headID = null;
	/** page title */
	private String title = null;
	/** Project setting name for the data in the textbox. */
	private String settingID = null;
	
	/**
	 * Constructs a new simple text page
	 * @param wizard The main form
	 * @param parent Parent screen
	 * @param title Page Title (for the tree)
	 * @param headID Resource ID for header text
	 * @param setting Name of the setting in the project file continaing the
	 * text.
	 */
	public SimpleTextPage(WizardForm wizard, WizardPage parent, String title, String headID, String setting){
		super(wizard, parent, title);
		this.title = title;
		this.headID = headID;
		this.settingID = setting;
	}

	/** text entry widget */
	private TextView txtView;
	/** Text entry buffer */
	private TextBuffer txtBuffer;
	
	/**
	 * Generate the widgets and set the defaults
	 */
	protected void preShow(){
			System.out.println("simple text preshow()");
		VBox mainVBox = new VBox(false, 5);

			System.out.println("simple text preshow()");
		Label intro = new Label( DomesdayGUI.messages.getString(headID));
		intro.setLineWrap(true);
		mainVBox.packStart(intro,false, false, 5);
			System.out.println("simple text preshow()");

		txtBuffer = new TextBuffer();
		txtView = new TextView(txtBuffer);
		txtView.setCursorVisible(true);
				
		try{
			txtBuffer.setText(DomesdayGUI.project.getStringSetting(settingID));
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
			System.out.println("simple text preshow(done setting)");

		ScrolledWindow win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(txtView);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);

		mainVBox.showAll();
		content =  mainVBox;
			System.out.println("preshow()");
	}

	/**
	 * Save the settings
	 */
	protected void postShow(){
		try{
			DomesdayGUI.project.storeSettingByVar(settingID, txtBuffer.getText( txtBuffer.getStartIter(), txtBuffer.getEndIter(), false) );
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}
	}
}
