#ifndef INCLUDED_QEOPENFILEDIALOG_H
#define INCLUDED_QEOPENFILEDIALOG_H

#include <string>

#include <qdialog.h>
#include <qcheckbox.h>
#include <qlayout.h>

#include <eca-audio-format.h>

#include "qeaudioformatinput.h"
#include "qefilenameinput.h"
#include "qeacceptinput.h"

class QVGroupBox;

/**
 * Dialog for selecting audio file, format and various 
 * related options.
 */
class QEOpenFileDialog : public QDialog {
  Q_OBJECT
 public:

  QEOpenFileDialog (QWidget *parent=0, const char *name=0);

private slots:

  void format_test(void);
  void update_refresh_toggle(bool v);
  void update_wcache_toggle(bool v);

 public:

  std::string result_filename(void) const { return(fname->result_filename()); }
  const std::string& current_dir(void) const { return(fname->current_dir()); }

  ECA_AUDIO_FORMAT result_audio_format(void) const;

  bool result_wave_cache_toggle(void) const { return(wcache_toggle->isChecked()); }
  bool result_cache_refresh_toggle(void) const { return(refresh_toggle->isChecked()); }
  bool result_direct_mode_toggle(void) const { return(direct_toggle->isChecked()); }

 private:

  QBoxLayout* init_toggles(void);
  QCheckBox* wcache_toggle;
  QCheckBox* refresh_toggle;
  QCheckBox* direct_toggle;

  QEFilenameInput* fname; 
  QEAudioFormatInput* aformat;
  QEAcceptInput* okcancel;
};

#endif
