/*
 *  ---------
 * |.**> <**.|  CardContact
 * |*       *|  Software & System Consulting
 * |*       *|  Minden, Germany
 * |**> <**|  Copyright (c) 1999. All rights reserved
 *  --------- 
 *
 * See file LICENSE for details on licensing
 *
 * Abstract :       Defines tools/types for ECO5000 reader
 *
 * Author :         Frank Thater (FTH)
 *
 * Last modified:   10/08/1999
 *
 *****************************************************************************/
 
#ifndef _ECOTOOLS_H_
#define _ECOTOOLS_H_

#include "eco5000.h"

int ecoCommand (struct eco5000_t *ctx,
                unsigned char com,
                int outbytelen,
                unsigned char *outbytes,
                int expinbytes,
                unsigned char *inbytes);


int ecoChangeBaudrate(struct eco5000_t *ctx, int baudrate);
int getFirmware (struct eco5000_t *ctx);

int DecodeAPDU(unsigned int len, unsigned char *cmd,
               unsigned int *lc, unsigned char **data, unsigned int *le);
void invert(unsigned char *buff, int len);
int iccRead(HANDLE fh, int inverse, unsigned char *buff, int len);
int iccWrite(HANDLE fh, int inverse, unsigned char *buff, int len);
#endif








