/* $Id: GlobDef.c,v 1.4 1997/07/31 14:24:43 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "GlobDef.h"
#include "Bool.h"
#include "LIGA.h"
#include "LIGAMacros.h"
#include "liga_func.h"
#include "ligaconsts.h"
#include "pdl_gen.h"
#include "msgtxt.h"
#include "Syntax.h"

/* to be removed with outdated LIGAPragma: */
#define PRAGMAFCT       "LIGAPragma"

int IFid;
int DEPid;
int ORDid;
int PRAGMAid;

/*	keys for predefined chain symbols
*/
DefTableKey ROOTCLASSKey;
DefTableKey GramKey;
DefTableKey THISKey;
DefTableKey HEADKey;
DefTableKey TAILKey;
DefTableKey VOIDKey;
DefTableKey SYNTKey;
DefTableKey INHKey;

POSITION nullpos;

int IsPreDefSym (k)
	DefTableKey	k;
{
return ((k == THISKey) || (k == HEADKey) || (k == TAILKey) ||
	(k == VOIDKey) || (k == SYNTKey) || (k == INHKey));
}/* IsPreDefSym */

DefTableKey Declare (scope, id, kind, attrscope, pos)
	Environment	scope;
	int		id;
	int		kind;
	Environment	attrscope;
	POSITION *	pos;
/*
On Exit:
	scope has an entry for id, its key is the result
	of the call.
	If the entry is new, its kind is set, otherwise
	it is checked and possibly set to MultDef.
	For SymDef and RuleDef the attribute scope 
	other properties are initialized.
*/
{	DefTableKey		k;
	int		haskind;
	int		did;
	Environment	sc;

if (scope == NoEnv)
	message (DEADLY,MSGTXT("No scope for definition",
                               (help)system), 0, pos);

k = DefineIdn (scope, id);

haskind = (int)GetDefKind (k, unDef);
if (haskind == kind) return (k);
if (haskind == unDef) {
	ResetDefKind (k, kind);
	did = GenDid ();
	ResetDid (k, did);
	ResetCoord (k, pos);
	ResetIdent (k, id);
} else	ResetDefKind (k, MultDef);
switch (kind) {
case SymDef:
	if (NoEnv == GetAttrScope (k, NoEnv)) {
		sc = NewScope (attrscope);
		ResetAttrScope (k, sc);
	}
	ResetLowAttrib (k, nullSEQAttrrule ());
	ResetUpAttrib (k, nullSEQAttrrule ());
	break;
case RuleDef:
	ResetAttrib (k, nullSEQAttrrule ());
	break;
case TypeDef:
	;
default:;
}
return (k);
}/* Declare */


Environment EnvPreDefs (attrscope)
	Environment	attrscope;
/*
On Exit:
	The entries for the predefined types are made.
	The identifiers IFid, DEPid are coded.
*/
{	Environment	e;
	DefTableKey	k;
	int	id;
	int	idtoken = 4; /* token class is not relevant here */

e = NewEnv ();

nullpos.line = 0;
nullpos.col = 0;

mkidn(IFFCT, strlen (IFFCT), &idtoken, &IFid);
mkidn(DEPFCT, strlen (DEPFCT), &idtoken, &DEPid);
mkidn(ORDERFCT, strlen (ORDERFCT), &idtoken, &ORDid);
mkidn(PRAGMAFCT, strlen (PRAGMAFCT), &idtoken, &PRAGMAid);

mkidn(TNNODE, strlen (TNNODE), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDNODE);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNCOORD, strlen (TNCOORD), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDCOORD);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNSYMB, strlen(TNSYMB), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDSYMB);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNBOOL, strlen(TNBOOL), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDBOOL);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNINT, strlen(TNINT), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDINT);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNVOLI, strlen(TNVOLI), &idtoken, &id);
k = DefineIdn (e, id);
ResetDid (k, DIDVOLI);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn(TNVOID, strlen(TNVOID), &idtoken, &id);
k = DefineIdn (e, id);
VOIDKey  = k;
ResetDid (k, DIDVOID);
ResetDefKind (k, TypeDef);
ResetIdent (k, id);

mkidn("THIS", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetDefinedSym (k, true);
THISKey = k;

mkidn("HEAD", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetDefinedSym (k, true);
HEADKey  = k;

mkidn("TAIL", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetDefinedSym (k, true);
TAILKey = k;

mkidn("SYNT", 4, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetAttrClass (k, ATCLSYNT);
ResetDefinedSym (k, true);
SYNTKey = k;

mkidn("INH", 3, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetAttrClass (k, ATCLINH);
ResetDefinedSym (k, true);
INHKey = k;

mkidn("ROOTCLASS", 9, &idtoken, &id);
k = Declare (e, id, SymDef, attrscope, &nullpos);
ResetDefinedSym (k, true);
ResetTreeOrClass (k, IsClassSym);
ROOTCLASSKey = k;

k = NewKey ();
GramKey = k;

return (e);
}/*EnvPreDefs*/
