#include "pdl_gen.h"

#ifdef MONITOR
#include "pdl_dapto.h"
#endif

#define PRESENT find(key, _property, (Entry *)&_Item, 0)
#define VALUE (_Item->PropVal)

#define TYPE ComponentKind

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct ComponentKindElt))

typedef struct ComponentKindElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *ComponentKindProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetComponentKind (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetComponentKind (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  ComponentKindProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetComponentKind (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetComponentKind (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  ComponentKindProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetComponentKind (int _property, DefTableKey key, TYPE _val)
#else
void
ResetComponentKind (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  ComponentKindProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE int

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct intElt))

typedef struct intElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *intProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
Getint (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
Getint (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  intProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Setint (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
Setint (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Resetint (int _property, DefTableKey key, TYPE _val)
#else
void
Resetint (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  intProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
Orint (int _property, DefTableKey key, TYPE val)
#else
void
Orint (_property, key, val)
int _property;
DefTableKey key;
TYPE val;
#endif
{  intProperty _Item;
{
        if (key == NoKey) return;
        if (ACCESS)     { VALUE = VALUE || val; }
        else            { VALUE = val; }
}
}

#undef ACCESS
#undef TYPE
#define TYPE NodeType

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct NodeTypeElt))

typedef struct NodeTypeElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *NodeTypeProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetNodeType (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetNodeType (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  NodeTypeProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetNodeType (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetNodeType (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  NodeTypeProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetNodeType (int _property, DefTableKey key, TYPE _val)
#else
void
ResetNodeType (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  NodeTypeProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE CharPtr

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct CharPtrElt))

typedef struct CharPtrElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *CharPtrProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetCharPtr (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetCharPtr (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  CharPtrProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetCharPtr (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetCharPtr (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  CharPtrProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetCharPtr (int _property, DefTableKey key, TYPE _val)
#else
void
ResetCharPtr (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  CharPtrProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE
#define TYPE KeyArray

#define ACCESS find(key, _property, (Entry *)&_Item, sizeof(struct KeyArrayElt))

typedef struct KeyArrayElt {
	Entry next;
	int selector;
	TYPE PropVal;
} *KeyArrayProperty;

#if defined(__STDC__) || defined(__cplusplus)
TYPE
GetKeyArray (int _property, DefTableKey key, TYPE deflt)
#else
TYPE
GetKeyArray (_property, key, deflt)
int _property;
DefTableKey key;
TYPE deflt;
#endif
{  KeyArrayProperty _Item;
{ if (key == NoKey) return deflt;
  if (PRESENT) return VALUE;
  else return deflt;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
SetKeyArray (int _property, DefTableKey key, TYPE _add, TYPE _replace)
#else
void
SetKeyArray (_property, key, _add, _replace)
int _property;
DefTableKey key;
TYPE _add;
TYPE _replace;
#endif
{  KeyArrayProperty _Item;
{ if (key == NoKey) return;
  if (ACCESS) VALUE = _replace;
  else VALUE = _add;
}
}

#if defined(__STDC__) || defined(__cplusplus)
void
ResetKeyArray (int _property, DefTableKey key, TYPE _val)
#else
void
ResetKeyArray (_property, key, _val)
int _property;
DefTableKey key;
TYPE _val;
#endif
{  KeyArrayProperty _Item;
{ if (key == NoKey) return;
  ACCESS; VALUE = _val;
}
}

#undef ACCESS
#undef TYPE

static struct PropElt PDLe0 = {(Entry)0, 0};

DefTableKey
#if defined(__STDC__) || defined(__cplusplus)
CloneKey (DefTableKey key)
#else
CloneKey (key)
    DefTableKey key;
#endif
{
  DefTableKey k;
  Entry e;

  if (key == NoKey) return NoKey;
  k = NewKey ();
  for (e = key->List; (e != (Entry) NULL) && (e->selector != 0);
       e = e->next) {
    switch (e->selector) {
      case 1:
         ResetKind (k, ((ComponentKindProperty)e)->PropVal);
         break;
      case 2:
         ResetOptional (k, ((intProperty)e)->PropVal);
         break;
      case 3:
         ResetIndex (k, ((intProperty)e)->PropVal);
         break;
      case 4:
         ResetType (k, ((NodeTypeProperty)e)->PropVal);
         break;
      case 5:
         ResetString (k, ((CharPtrProperty)e)->PropVal);
         break;
      case 6:
         ResetFunctionSym (k, ((intProperty)e)->PropVal);
         break;
      case 7:
         ResetArguments (k, ((KeyArrayProperty)e)->PropVal);
         break;
      case 8:
         ResetInconsistentUse (k, ((intProperty)e)->PropVal);
         break;
      case 9:
         ResetInserted (k, ((intProperty)e)->PropVal);
         break;
      case 10:
         ResetPrototypeComputed (k, ((intProperty)e)->PropVal);
         break;
      case 11:
         ResetClpValue (k, ((intProperty)e)->PropVal);
         break;
      }
  }
  return k;
}

#ifdef MONITOR
static char *pdl_names[] = {
    (char *)NULL,
    "Kind",
    "Optional",
    "Index",
    "Type",
    "String",
    "FunctionSym",
    "Arguments",
    "InconsistentUse",
    "Inserted",
    "PrototypeComputed",
    "ClpValue",
};
static char *pdl_types[] = {
    (char *)NULL,
    "ComponentKind",
    "int",
    "int",
    "NodeType",
    "CharPtr",
    "int",
    "KeyArray",
    "int",
    "int",
    "int",
    "int",
};

void
#if defined(__STDC__) || defined(__cplusplus)
pdl_mon_properties(DefTableKey k)
#else
pdl_mon_properties(k) DefTableKey k;
#endif
{
    Entry e;
    if (k == NoKey) return;
    for (e = k->List; (e != (Entry) NULL) && (e->selector != 0);
         e = e->next) {
        DAPTO_RESULT_STR (pdl_names[e->selector]);
        DAPTO_RESULT_STR (pdl_types[e->selector]);
        switch (e->selector) {
            case 1:
#ifdef DAPTO_RESULTComponentKind
                DAPTO_RESULTComponentKind (((ComponentKindProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((ComponentKindProperty)e)->PropVal);
#endif
                break;
            case 2:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 3:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 4:
#ifdef DAPTO_RESULTNodeType
                DAPTO_RESULTNodeType (((NodeTypeProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((NodeTypeProperty)e)->PropVal);
#endif
                break;
            case 5:
#ifdef DAPTO_RESULTCharPtr
                DAPTO_RESULTCharPtr (((CharPtrProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((CharPtrProperty)e)->PropVal);
#endif
                break;
            case 6:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 7:
#ifdef DAPTO_RESULTKeyArray
                DAPTO_RESULTKeyArray (((KeyArrayProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((KeyArrayProperty)e)->PropVal);
#endif
                break;
            case 8:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 9:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 10:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            case 11:
#ifdef DAPTO_RESULTint
                DAPTO_RESULTint (((intProperty)e)->PropVal);
#else
                DAPTO_RESULT_OTHER (((intProperty)e)->PropVal);
#endif
                break;
            default: DAPTO_RESULT_STR ("unknown property");
        }
    }
}
#endif
