
/* implementation of tree construction functions */

#include "node.h"

#include "nodecode.h"

#include "attrpredef.h"

#include "visitmap.h"

#include "treeact.h"

#ifdef MONITOR
#include "attr_mon_dapto.h"
#endif

#include <stdlib.h>

#define _USE_OBSTACK 1

/* use of obstack: */

#if _USE_OBSTACK

#include "obstack.h"
static struct obstack TreeSpace;
static void *_TreeBase;

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	return obstack_alloc(&TreeSpace, size);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	return (char *)(obstack_alloc(&TreeSpace, size));
}
#endif

void InitTree()
{
	obstack_init(&TreeSpace);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

void FreeTree()
{
	obstack_free(&TreeSpace, _TreeBase);
	_TreeBase=obstack_alloc(&TreeSpace,0);
}

#else

#include <stdio.h>

#ifdef __cplusplus
void* NODEPTR_struct::operator new(size_t size)
{
	void *retval = malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#else
#if defined(__STDC__) || defined(__cplusplus)
char* TreeNodeAlloc(int size)
#else
char* TreeNodeAlloc(size) int size;
#endif
{
	char *retval = (char *) malloc(size);
	if (retval) return retval;
	fprintf(stderr, "*** DEADLY: No more memory.\n");
	exit(1);
}
#endif

void InitTree() { }

void FreeTree() { }

#endif

#ifdef MONITOR
#define _SETCOORD(node) \
        node->_coord = _coordref ? *_coordref : NoCoord;
#define _COPYCOORD(node) \
        node->_coord = _currn->_desc1->_coord;
#else
#define _SETCOORD(node)
#define _COPYCOORD(node)
#endif
#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkTreeNum (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkTreeNum (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBTreeNum)) return (_currn);
return(NULLNODEPTR);
}/* MkTreeNum */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkType (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkType (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBType)) return (_currn);
return(NULLNODEPTR);
}/* MkType */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkTreeType (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkTreeType (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBTreeType)) return (_currn);
if (IsSymb (_currn, SYMBType)) return (Mkrule_012(_coordref, _currn));
return(NULLNODEPTR);
}/* MkTreeType */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkTargtype (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkTargtype (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBTargtype)) return (_currn);
return(NULLNODEPTR);
}/* MkTargtype */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkInsertions (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkInsertions (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBInsertions)) return (_currn);
return(NULLNODEPTR);
}/* MkInsertions */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkRule (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkRule (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBRule)) return (_currn);
return(NULLNODEPTR);
}/* MkRule */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkNodeName (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkNodeName (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBNodeName)) return (_currn);
return(NULLNODEPTR);
}/* MkNodeName */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkItem (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkItem (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBItem)) return (_currn);
if (IsSymb (_currn, SYMBFctCall)) return (Mkrule_009(_coordref, _currn));
if (IsSymb (_currn, SYMBPrintString)) return (Mkrule_008(_coordref, _currn));
if (IsSymb (_currn, SYMBSubTree)) return (Mkrule_007(_coordref, _currn));
if (IsSymb (_currn, SYMBOptItem)) return (Mkrule_005(_coordref, _currn));
return(NULLNODEPTR);
}/* MkItem */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkPTG (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkPTG (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBPTG)) return (_currn);
if (IsSymb (_currn, SYMBRules)) return (Mkrule_000(_coordref, _currn));
return(NULLNODEPTR);
}/* MkPTG */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkRules (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkRules (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBRules)) return (_currn);
return(NULLNODEPTR);
}/* MkRules */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkOptItem (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkOptItem (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBOptItem)) return (_currn);
return(NULLNODEPTR);
}/* MkOptItem */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSubTree (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSubTree (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSubTree)) return (_currn);
return(NULLNODEPTR);
}/* MkSubTree */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkPrintString (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkPrintString (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBPrintString)) return (_currn);
return(NULLNODEPTR);
}/* MkPrintString */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkFctCall (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkFctCall (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBFctCall)) return (_currn);
return(NULLNODEPTR);
}/* MkFctCall */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkFctName (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkFctName (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBFctName)) return (_currn);
return(NULLNODEPTR);
}/* MkFctName */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkSubTrees (POSITION *_coordref, NODEPTR _currn)
#else
NODEPTR MkSubTrees (_coordref, _currn)
	POSITION *_coordref; NODEPTR _currn;
#endif
{
if (_currn == NULLNODEPTR) return NULLNODEPTR;
if (IsSymb (_currn, SYMBSubTrees)) return (_currn);
return(NULLNODEPTR);
}/* MkSubTrees */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpDefaultTree (POSITION *_coordref)
#else
NODEPTR MkpDefaultTree (_coordref)
	POSITION *_coordref;
#endif
{	_TPPpDefaultTree _currn;
#ifdef __cplusplus
_currn = new _TPpDefaultTree;
#else
_currn = (_TPPpDefaultTree) TreeNodeAlloc (sizeof (struct _TPpDefaultTree));
#endif
_currn->_prod = RULEpDefaultTree;
_SETCOORD(_currn)
_TERMACT_pDefaultTree;
return ( (NODEPTR) _currn);
}/* MkpDefaultTree */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR MkpNumberedTree (POSITION *_coordref, int _TERM1)
#else
NODEPTR MkpNumberedTree (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPpNumberedTree _currn;
#ifdef __cplusplus
_currn = new _TPpNumberedTree;
#else
_currn = (_TPPpNumberedTree) TreeNodeAlloc (sizeof (struct _TPpNumberedTree));
#endif
_currn->_prod = RULEpNumberedTree;
_SETCOORD(_currn)
_TERMACT_pNumberedTree;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "NumberedPattern", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* MkpNumberedTree */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mktargtype (POSITION *_coordref, DefTableKey _TERM1)
#else
NODEPTR Mktargtype (_coordref, _TERM1)
	POSITION *_coordref;
	DefTableKey _TERM1;
#endif
{	_TPPtargtype _currn;
#ifdef __cplusplus
_currn = new _TPtargtype;
#else
_currn = (_TPPtargtype) TreeNodeAlloc (sizeof (struct _TPtargtype));
#endif
_currn->_prod = RULEtargtype;
_SETCOORD(_currn)
_TERMACT_targtype;
#ifdef MONITOR
_dapto_term_DefTableKey(((NODEPTR)_currn), "Targtypecode", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mktargtype */

#if defined(__STDC__) || defined(__cplusplus)
static NODEPTR _Elemtargtypes (POSITION *_coordref, NODEPTR t)
#else
static NODEPTR _Elemtargtypes (_coordref, t)
	POSITION *_coordref; NODEPTR t;
#endif
/* makes t to be a list element and makes a single circular list */
{	NODEPTR elem;
if ((elem = MkTargtype (_coordref, t)) != NULLNODEPTR) {
	_TPPLST_Targtypetargtypes _new;
#ifdef __cplusplus
	_new = new _TPLST_Targtypetargtypes;
#else
	_new = (_TPPLST_Targtypetargtypes) TreeNodeAlloc (sizeof (struct _TPLST_Targtypetargtypes));
#endif
	_new->_prod = RULELST_Targtypetargtypes;
	_new->_desc1 = (_TSPTargtype)elem;
	_new->_desc2 = (_TSPLST_Insertions)_new;
	{_TPPLST_Targtypetargtypes _currn = _new;
	 _SETCOORD(_currn)
	 _TERMACT_LST_Targtypetargtypes;
	}
	return (NODEPTR)_new;
}
message (DEADLY, "a targtypes list element node can not be generated ",
	0, _coordref);
return t; /* never reached */
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mk2targtypes (POSITION *_coordref, NODEPTR l, NODEPTR r)
#else
NODEPTR Mk2targtypes (_coordref, l, r) POSITION *_coordref; NODEPTR l, r;
#endif
/* make a list of l and r, which may be null, elements, or lists */
{	NODEPTR last;
if (l == NULLNODEPTR) return r;
if (r == NULLNODEPTR) return l;
/* ensure l and r to be lists: */
if (LHSMAP[l->_prod] != SYMBLST_Insertions)
	l =_Elemtargtypes (_coordref, l);
if (LHSMAP[r->_prod] != SYMBLST_Insertions)
	r = _Elemtargtypes (_coordref, r);
/* concatenate two lists: */
last = ((NODEPTR)((_TPPLST_0targtypes)r)->_desc2);
((_TPPLST_0targtypes)r)->_desc2 = ((_TPPLST_0targtypes)l)->_desc2;
((_TPPLST_0targtypes)l)->_desc2 = last;
return l;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mktargtypes (POSITION *_coordref, NODEPTR t)
#else
NODEPTR Mktargtypes (_coordref, t) POSITION *_coordref; NODEPTR t;
#endif
{	NODEPTR _currn; _TPPtargtypes root;
	_TPPLST_0targtypes list, remain, p;
/* argument t may be empty, a list element, or a list: */
if (t == NULLNODEPTR)
	remain = (_TPPLST_0targtypes)NULLNODEPTR;
else {	if (LHSMAP[t->_prod] != SYMBLST_Insertions)
		t = _Elemtargtypes (_coordref, t);
	remain = (_TPPLST_0targtypes)(((_TPPLST_0targtypes) t)->_desc2);
	((_TPPLST_0targtypes) t)->_desc2 = NULLNODEPTR;
}
/* remain is a possibly empty list in reverse order */
/* finalize the list by an empty context: */
#ifdef __cplusplus
list = new _TPLST_0targtypes;
#else
list = (_TPPLST_0targtypes) TreeNodeAlloc (sizeof (struct _TPLST_0targtypes));
#endif
list->_prod = RULELST_0targtypes;
list->_desc1 = NULLNODEPTR;
list->_desc2 = NULLNODEPTR;
_SETCOORD(list)
_currn = (NODEPTR)list;
/* reverse the list and visit its nodes: */
while (remain) {
	p = (_TPPLST_0targtypes)(remain->_desc2);
	remain->_desc2 = (NODEPTR)list;
	list = remain;
	remain = p;
	_currn = (NODEPTR)list;
	/*if (_currn->_prod == RULELST_Targtypetargtypes)
	{_TPPLST_Targtypetargtypes _currn = _currn;
	 _TERMACT_LST_Targtypetargtypes;
	} this code has been moved to _Elemtargtypes*/
}
/* make root node and visit it: */
#ifdef __cplusplus
root = new _TPtargtypes;
#else
root = (_TPPtargtypes) TreeNodeAlloc (sizeof (struct _TPtargtypes));
#endif
root->_prod = RULEtargtypes;
root->_desc1 = (_TSPLST_Insertions)list;
{ _TPPtargtypes _currn = root;
  _SETCOORD(_currn)
  _TERMACT_targtypes;
}
_currn = (NODEPTR)root;
return (NODEPTR)_currn;
}

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_000 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_000 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_000 _currn;
#ifdef __cplusplus
_currn = new _TPrule_000;
#else
_currn = (_TPPrule_000) TreeNodeAlloc (sizeof (struct _TPrule_000));
#endif
_currn->_prod = RULErule_000;
_currn->_desc1 = (_TSPRules) MkRules (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_000: root of subtree no. 1 can not be made a Rules node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_000;
return ( (NODEPTR) _currn);
}/* Mkrule_000 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_001 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_001 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_001 _currn;
#ifdef __cplusplus
_currn = new _TPrule_001;
#else
_currn = (_TPPrule_001) TreeNodeAlloc (sizeof (struct _TPrule_001));
#endif
_currn->_prod = RULErule_001;
_currn->_desc1 = (_TSPRules) MkRules (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 1 can not be made a Rules node ", 0, _coordref);
_currn->_desc2 = (_TSPRule) MkRule (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_001: root of subtree no. 2 can not be made a Rule node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_001;
return ( (NODEPTR) _currn);
}/* Mkrule_001 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_002 (POSITION *_coordref)
#else
NODEPTR Mkrule_002 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_002 _currn;
#ifdef __cplusplus
_currn = new _TPrule_002;
#else
_currn = (_TPPrule_002) TreeNodeAlloc (sizeof (struct _TPrule_002));
#endif
_currn->_prod = RULErule_002;
_SETCOORD(_currn)
_TERMACT_rule_002;
return ( (NODEPTR) _currn);
}/* Mkrule_002 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_003 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_003 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_003 _currn;
#ifdef __cplusplus
_currn = new _TPrule_003;
#else
_currn = (_TPPrule_003) TreeNodeAlloc (sizeof (struct _TPrule_003));
#endif
_currn->_prod = RULErule_003;
_currn->_desc1 = (_TSPItem) MkItem (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_003: root of subtree no. 1 can not be made a Item node ", 0, _coordref);
_currn->_desc2 = (_TSPItem) MkItem (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_003: root of subtree no. 2 can not be made a Item node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_003;
return ( (NODEPTR) _currn);
}/* Mkrule_003 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_004 (POSITION *_coordref)
#else
NODEPTR Mkrule_004 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_004 _currn;
#ifdef __cplusplus
_currn = new _TPrule_004;
#else
_currn = (_TPPrule_004) TreeNodeAlloc (sizeof (struct _TPrule_004));
#endif
_currn->_prod = RULErule_004;
_SETCOORD(_currn)
_TERMACT_rule_004;
return ( (NODEPTR) _currn);
}/* Mkrule_004 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_005 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_005 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_005 _currn;
#ifdef __cplusplus
_currn = new _TPrule_005;
#else
_currn = (_TPPrule_005) TreeNodeAlloc (sizeof (struct _TPrule_005));
#endif
_currn->_prod = RULErule_005;
_currn->_desc1 = (_TSPOptItem) MkOptItem (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_005: root of subtree no. 1 can not be made a OptItem node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_005;
return ( (NODEPTR) _currn);
}/* Mkrule_005 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_006 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_006 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_006 _currn;
#ifdef __cplusplus
_currn = new _TPrule_006;
#else
_currn = (_TPPrule_006) TreeNodeAlloc (sizeof (struct _TPrule_006));
#endif
_currn->_prod = RULErule_006;
_currn->_desc1 = (_TSPItem) MkItem (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_006: root of subtree no. 1 can not be made a Item node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_006;
return ( (NODEPTR) _currn);
}/* Mkrule_006 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_007 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_007 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_007 _currn;
#ifdef __cplusplus
_currn = new _TPrule_007;
#else
_currn = (_TPPrule_007) TreeNodeAlloc (sizeof (struct _TPrule_007));
#endif
_currn->_prod = RULErule_007;
_currn->_desc1 = (_TSPSubTree) MkSubTree (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_007: root of subtree no. 1 can not be made a SubTree node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_007;
return ( (NODEPTR) _currn);
}/* Mkrule_007 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_008 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_008 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_008 _currn;
#ifdef __cplusplus
_currn = new _TPrule_008;
#else
_currn = (_TPPrule_008) TreeNodeAlloc (sizeof (struct _TPrule_008));
#endif
_currn->_prod = RULErule_008;
_currn->_desc1 = (_TSPPrintString) MkPrintString (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_008: root of subtree no. 1 can not be made a PrintString node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_008;
return ( (NODEPTR) _currn);
}/* Mkrule_008 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_009 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_009 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_009 _currn;
#ifdef __cplusplus
_currn = new _TPrule_009;
#else
_currn = (_TPPrule_009) TreeNodeAlloc (sizeof (struct _TPrule_009));
#endif
_currn->_prod = RULErule_009;
_currn->_desc1 = (_TSPFctCall) MkFctCall (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_009: root of subtree no. 1 can not be made a FctCall node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_009;
return ( (NODEPTR) _currn);
}/* Mkrule_009 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_010 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_010 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_010 _currn;
#ifdef __cplusplus
_currn = new _TPrule_010;
#else
_currn = (_TPPrule_010) TreeNodeAlloc (sizeof (struct _TPrule_010));
#endif
_currn->_prod = RULErule_010;
_SETCOORD(_currn)
_TERMACT_rule_010;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Ident", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_010 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_011 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_011 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_011 _currn;
#ifdef __cplusplus
_currn = new _TPrule_011;
#else
_currn = (_TPPrule_011) TreeNodeAlloc (sizeof (struct _TPrule_011));
#endif
_currn->_prod = RULErule_011;
_currn->_desc1 = (_TSPTreeNum) MkTreeNum (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_011: root of subtree no. 1 can not be made a TreeNum node ", 0, _coordref);
_currn->_desc2 = (_TSPTreeType) MkTreeType (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_011: root of subtree no. 2 can not be made a TreeType node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_011;
return ( (NODEPTR) _currn);
}/* Mkrule_011 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_012 (POSITION *_coordref, NODEPTR _desc1)
#else
NODEPTR Mkrule_012 (_coordref,_desc1)
	POSITION *_coordref;
	NODEPTR _desc1;
#endif
{	_TPPrule_012 _currn;
#ifdef __cplusplus
_currn = new _TPrule_012;
#else
_currn = (_TPPrule_012) TreeNodeAlloc (sizeof (struct _TPrule_012));
#endif
_currn->_prod = RULErule_012;
_currn->_desc1 = (_TSPType) MkType (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_012: root of subtree no. 1 can not be made a Type node ", 0, _coordref);
_COPYCOORD(_currn)
_TERMACT_rule_012;
return ( (NODEPTR) _currn);
}/* Mkrule_012 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_013 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_013 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_013 _currn;
#ifdef __cplusplus
_currn = new _TPrule_013;
#else
_currn = (_TPPrule_013) TreeNodeAlloc (sizeof (struct _TPrule_013));
#endif
_currn->_prod = RULErule_013;
_currn->_desc1 = (_TSPFctName) MkFctName (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 1 can not be made a FctName node ", 0, _coordref);
_currn->_desc2 = (_TSPSubTrees) MkSubTrees (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_013: root of subtree no. 2 can not be made a SubTrees node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_013;
return ( (NODEPTR) _currn);
}/* Mkrule_013 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_014 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2)
#else
NODEPTR Mkrule_014 (_coordref,_desc1,_desc2)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
#endif
{	_TPPrule_014 _currn;
#ifdef __cplusplus
_currn = new _TPrule_014;
#else
_currn = (_TPPrule_014) TreeNodeAlloc (sizeof (struct _TPrule_014));
#endif
_currn->_prod = RULErule_014;
_currn->_desc1 = (_TSPSubTrees) MkSubTrees (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_014: root of subtree no. 1 can not be made a SubTrees node ", 0, _coordref);
_currn->_desc2 = (_TSPSubTree) MkSubTree (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_014: root of subtree no. 2 can not be made a SubTree node ", 0, _coordref);
_SETCOORD(_currn)
_TERMACT_rule_014;
return ( (NODEPTR) _currn);
}/* Mkrule_014 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_015 (POSITION *_coordref)
#else
NODEPTR Mkrule_015 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_015 _currn;
#ifdef __cplusplus
_currn = new _TPrule_015;
#else
_currn = (_TPPrule_015) TreeNodeAlloc (sizeof (struct _TPrule_015));
#endif
_currn->_prod = RULErule_015;
_SETCOORD(_currn)
_TERMACT_rule_015;
return ( (NODEPTR) _currn);
}/* Mkrule_015 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_016 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_016 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_016 _currn;
#ifdef __cplusplus
_currn = new _TPrule_016;
#else
_currn = (_TPPrule_016) TreeNodeAlloc (sizeof (struct _TPrule_016));
#endif
_currn->_prod = RULErule_016;
_SETCOORD(_currn)
_TERMACT_rule_016;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "Ident", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_016 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_017 (POSITION *_coordref, int _TERM1)
#else
NODEPTR Mkrule_017 (_coordref, _TERM1)
	POSITION *_coordref;
	int _TERM1;
#endif
{	_TPPrule_017 _currn;
#ifdef __cplusplus
_currn = new _TPrule_017;
#else
_currn = (_TPPrule_017) TreeNodeAlloc (sizeof (struct _TPrule_017));
#endif
_currn->_prod = RULErule_017;
_SETCOORD(_currn)
_TERMACT_rule_017;
#ifdef MONITOR
_dapto_term_int(((NODEPTR)_currn), "String", _TERM1);
#endif

return ( (NODEPTR) _currn);
}/* Mkrule_017 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_1 (POSITION *_coordref)
#else
NODEPTR Mkrule_1 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_1 _currn;
#ifdef __cplusplus
_currn = new _TPrule_1;
#else
_currn = (_TPPrule_1) TreeNodeAlloc (sizeof (struct _TPrule_1));
#endif
_currn->_prod = RULErule_1;
_SETCOORD(_currn)
_TERMACT_rule_1;
return ( (NODEPTR) _currn);
}/* Mkrule_1 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_2 (POSITION *_coordref)
#else
NODEPTR Mkrule_2 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_2 _currn;
#ifdef __cplusplus
_currn = new _TPrule_2;
#else
_currn = (_TPPrule_2) TreeNodeAlloc (sizeof (struct _TPrule_2));
#endif
_currn->_prod = RULErule_2;
_SETCOORD(_currn)
_TERMACT_rule_2;
return ( (NODEPTR) _currn);
}/* Mkrule_2 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_3 (POSITION *_coordref)
#else
NODEPTR Mkrule_3 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_3 _currn;
#ifdef __cplusplus
_currn = new _TPrule_3;
#else
_currn = (_TPPrule_3) TreeNodeAlloc (sizeof (struct _TPrule_3));
#endif
_currn->_prod = RULErule_3;
_SETCOORD(_currn)
_TERMACT_rule_3;
return ( (NODEPTR) _currn);
}/* Mkrule_3 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_4 (POSITION *_coordref)
#else
NODEPTR Mkrule_4 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_4 _currn;
#ifdef __cplusplus
_currn = new _TPrule_4;
#else
_currn = (_TPPrule_4) TreeNodeAlloc (sizeof (struct _TPrule_4));
#endif
_currn->_prod = RULErule_4;
_SETCOORD(_currn)
_TERMACT_rule_4;
return ( (NODEPTR) _currn);
}/* Mkrule_4 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_5 (POSITION *_coordref)
#else
NODEPTR Mkrule_5 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_5 _currn;
#ifdef __cplusplus
_currn = new _TPrule_5;
#else
_currn = (_TPPrule_5) TreeNodeAlloc (sizeof (struct _TPrule_5));
#endif
_currn->_prod = RULErule_5;
_SETCOORD(_currn)
_TERMACT_rule_5;
return ( (NODEPTR) _currn);
}/* Mkrule_5 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_6 (POSITION *_coordref)
#else
NODEPTR Mkrule_6 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_6 _currn;
#ifdef __cplusplus
_currn = new _TPrule_6;
#else
_currn = (_TPPrule_6) TreeNodeAlloc (sizeof (struct _TPrule_6));
#endif
_currn->_prod = RULErule_6;
_SETCOORD(_currn)
_TERMACT_rule_6;
return ( (NODEPTR) _currn);
}/* Mkrule_6 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_7 (POSITION *_coordref)
#else
NODEPTR Mkrule_7 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_7 _currn;
#ifdef __cplusplus
_currn = new _TPrule_7;
#else
_currn = (_TPPrule_7) TreeNodeAlloc (sizeof (struct _TPrule_7));
#endif
_currn->_prod = RULErule_7;
_SETCOORD(_currn)
_TERMACT_rule_7;
return ( (NODEPTR) _currn);
}/* Mkrule_7 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_8 (POSITION *_coordref)
#else
NODEPTR Mkrule_8 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_8 _currn;
#ifdef __cplusplus
_currn = new _TPrule_8;
#else
_currn = (_TPPrule_8) TreeNodeAlloc (sizeof (struct _TPrule_8));
#endif
_currn->_prod = RULErule_8;
_SETCOORD(_currn)
_TERMACT_rule_8;
return ( (NODEPTR) _currn);
}/* Mkrule_8 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_9 (POSITION *_coordref)
#else
NODEPTR Mkrule_9 (_coordref)
	POSITION *_coordref;
#endif
{	_TPPrule_9 _currn;
#ifdef __cplusplus
_currn = new _TPrule_9;
#else
_currn = (_TPPrule_9) TreeNodeAlloc (sizeof (struct _TPrule_9));
#endif
_currn->_prod = RULErule_9;
_SETCOORD(_currn)
_TERMACT_rule_9;
return ( (NODEPTR) _currn);
}/* Mkrule_9 */

#if defined(__STDC__) || defined(__cplusplus)
NODEPTR Mkrule_10 (POSITION *_coordref, NODEPTR _desc1, NODEPTR _desc2, NODEPTR _desc3)
#else
NODEPTR Mkrule_10 (_coordref,_desc1,_desc2,_desc3)
	POSITION *_coordref;
	NODEPTR _desc1;
	NODEPTR _desc2;
	NODEPTR _desc3;
#endif
{	_TPPrule_10 _currn;
#ifdef __cplusplus
_currn = new _TPrule_10;
#else
_currn = (_TPPrule_10) TreeNodeAlloc (sizeof (struct _TPrule_10));
#endif
_currn->_prod = RULErule_10;
_currn->_desc1 = (_TSPNodeName) MkNodeName (_coordref, _desc1);	
if (((NODEPTR)_currn->_desc1) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_10: root of subtree no. 1 can not be made a NodeName node ", 0, _coordref);
_currn->_desc2 = (_TSPItem) MkItem (_coordref, _desc2);	
if (((NODEPTR)_currn->_desc2) == NULLNODEPTR)	
	message (DEADLY, "RULE rule_10: root of subtree no. 2 can not be made a Item node ", 0, _coordref);
if (_desc3 == NULLNODEPTR)
	_currn->_desc3 = (_TSPInsertions) NULLNODEPTR;
else	_currn->_desc3 = (_TSPInsertions) MkInsertions (_coordref, _desc3);
_SETCOORD(_currn)
_TERMACT_rule_10;
return ( (NODEPTR) _currn);
}/* Mkrule_10 */
