/*
 *  The MOOtcan MOO-client
 *  Copyright (C) 1999-2001 Sindre Srensen and Jan Rune Holmevik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

import java.awt.*;
import java.util.*;
import java.awt.event.*;

/**
 * Class ControlPanel. Constructor sets up three radio buttons,
 * adds event listener, and adds buttons to checkbox group.
 * Class completely rewritten to use Java 1.1 event model. 
 *
 * @author Jan Rune Holmevik
*/

public class ControlPanel extends Panel implements ItemListener {

	CheckboxGroup cbg;
	private Checkbox normal;
	private Checkbox say;
	private Checkbox emote;
	CommandTextField ctf;
	
	private final String NORMAL_MODE = "";
	private final String SAY_MODE = "Say ";
	private final String EMOTE_MODE = "Emote ";
 	

	

	ControlPanel(CommandTextField ctf) {

		this.setLayout(new GridLayout(3, 1));
		cbg = new CheckboxGroup();
	
	    normal = new Checkbox("Normal", cbg, true);
	    normal.addItemListener(this);
        add(normal);
        
	    say = new Checkbox("Say", cbg, false);
        say.addItemListener(this);
        add(say);
        
	    emote = new Checkbox("Emote", cbg, false);
        emote.addItemListener(this);
        add(emote);
        
		this.ctf = ctf;
		
    }		
 
	/*
	 * Determine current mode.
	 */

 	public String getMode(String mode) {
 	
 		   
 	   if (cbg.getSelectedCheckbox() == normal) {
 	   		mode = NORMAL_MODE;
	   }
	   else if (cbg.getSelectedCheckbox() == say) {
 	   		mode = SAY_MODE;
 	   }
	   else if (cbg.getSelectedCheckbox() == emote) {
 	   		mode = EMOTE_MODE;
  
       }
       
       return mode;
 	}
 	

	/*
	 * Control Panel Event Handling. Java 1.1
	 */

    public void itemStateChanged(ItemEvent e) {

    	if (e.getItemSelectable() == normal) {
     	    ctf.setText(NORMAL_MODE);
        }
   		else if (e.getItemSelectable() == say) {
   	        ctf.setText(SAY_MODE);

        }
   		else if (e.getItemSelectable() == emote) {
   	        ctf.setText(EMOTE_MODE);

        }
        
        ctf.setCaretPosition(ctf.getText().length());
        ctf.requestFocus();

    }
}