#!/usr/bin/perl -w
#
################################################################
# vaseFiles -	manages user files:                            #
#		    upload files                               #
#		    view list of files                         #
#                   view individual files                      #
#		    check quota                                #
#		    delete old / unwanted files.               #
#                   rename files                               #
################################################################
# Author: 	    Emma Jane Hogbin                           #
# Copyright: 	    Jason Nolan, University of Toronto         #
# Version: 	    1.0                                        #
# Last Modified:    April 5, 2001                          #
################################################################
# Doc:                                                         
# ----                                                         
# There are ONLY five things that need to be defined by you in 
# this script. Please scroll down approx one page to find them.
#
# Make sure this script is inside your cgi-bin directory.
# You can put it in a subdirectory if you want within the cgi-bin
# directory. If you put this script in a sub-directory, be sure
# to set the correct permissions.
#
# Setting permissions:
# From a command line on the server (e.g. telnet or ssh)
# Make sure you're in the cgi-bin directory. Type: 
#
#				ls -l
#
# This will show you a list of all the files and all the
# directories. If your script is in a sub-directory, make sure 
# the directory has the following letters on the far left:
#
#				drwxrwxr-x
# 
# If it doesn't, type: 
#
#				chmod 775 directoryname
# 
# where "directoryname" is the name of the directory. Now find
# your copy of the script. Again, type:
#
#				ls -l
#
# This will show you a list of all the files and all the 
# directories. Look for your copy of this script. Make sure the 
# script has this to the left of it:
#
#				-rwxrwxr-x
#
# If it doesn't, type:
#
#				chmod 775 scriptname
# 
#
#
################################################################

# There are FIVE things that need to be defined by the user

# ONE: Where your HTML files live on your web server.
# This path will have a couple of different folders in it
# e.g. /home/httpd/htdocs
# DO include a slash at the start of this path.
# DO NOT include a slash at the end of this path.
$doc_root = "/my/web/server/puts/html/here";


# TWO: Name of the directory that everyone's junk goes into.
# We recommend you use the file name "media". You MUST create
# this directory on your webserver. This folder MUST be inside
# $doc_root (which you just set) AND be inside another folder
# $mooname (you set this name on the actual MOO).
# e.g. /home/httpd/html/yourmooname/media
# The name of the folder should NOT contain any slashes.
# Once you've created this folder, make sure it has the correct
# permissions!! (see above for a general helper on how to set
# permissions)
# $mooname permissions: chmod 775
# $all_files permissions: chmod 775
# Type: ls -l to make sure the folders are set correctly. They
# should look like this: -rwxr-xr-x
# You must also change the OWNER and GROUP for $all_files.
# You might need to get help from your system administrator
# for this. Both OWNER and GROUP need to be set to nobody
# (this may be www on your system).
# To change the owner, type: chown nobody directoryname
# To change the group, type: chgrp nobody directoryname
$all_files = "filefolder";






# THREE: Name of the cascading style sheet.
# This file comes with the VASE package. It allows you to 
# change all of the pages that are outputted by this
# perl script.
# For more information about how to modify CSS files, see
# http://www.w3.org/Style/CSS/
# This file needs to go in the first folder that 
# you made in Step TWO. i.e. 
# /home/httpd/htdocs/achieve/vase.css
# $css_file permissions: chmod 644
$css_file = "vase.css";





# FOUR: This script's url (i.e. when a web browser 
# calls up the cgi-bin).
# Finding this directory: (1) find the directory you used in 
# ONE (the first thing you set for this script). (2) Go one 
# directory up (e.g. /home/httpd). (3) Look for a directory
# named cgi-bin (or something like that).
# Make sure you have the correct permissions set for this 
# file! See above for more help!
$this_file = "thescript.cgi";






# FIVE: Where your SENDMAIL program is.
# If you're not sure, type: whereis sendmail on a command line prompt 
# for your server.
$mailprog = "/your/sendmail/program";




# FIVE -- part B
# If you want wiz to receive mail, set doMail=1 (this is
# the default). If you don't want wiz to receive mail, 
# set doMail=0.
# Make sure you've set the wiz's email on the MOO object.
$doMail = 1;








# YOU ARE NOW DONE DEFINING .... CONTINUE AT YOUR OWN PERIL!
###############################################################

###############################################################

###############################################################

###############################################################
# WE'RE NOT KIDDING.. THE REST GETS CRAZY!


# Make sure the script has actually been set up. These are all
# the default values you need to check for:
# $doc_root = "/my/web/server/puts/html/here";
# $all_files = "filefolder";
# $this_file = "thescript.cgi";
# $mailprog = "/your/sendmail/program";

if ($doc_root eq "/my/web/server/puts/html/here") {
	&error("This script hasn't been properly installed. Please
	make sure you set the <tt>doc_root</tt> variable.");
}

if ($all_files eq "filefolder") {
	&error("This script hasn't been properly installed. Please
	make sure you set the <tt>all_files</tt> variable and set the correct 
		permissions for this directory.");
}

if ($this_file eq "thescript.cgi") {
	&error("This script hasn't been properly installed. Please
	make sure you set the <tt>this_file</tt> variable.");
}

if ($mailprog eq "/your/sendmail/program") {
	&error("This script hasn't been properly installed. Please
	make sure you set the <tt>mailprog</tt> variable.");
}


use CGI;
$q = new CGI;

# Make double sure you're allowed to upload files using CGI.
$CGI::DISABLE_UPLOADS = 0;

&parse_form;
&hidden;

# After you've grabbed some info from the form, define some constants.
use constant BUFFER_SIZE => 1024;

# And make sure the corresponding directories have actually
# been setup.
if (! -d "$doc_root/$mooname/$all_files") {
		&error("This program hasn't been properly installed yet. The following directories need to be set up on your web server: 
		<ul><li><b>$doc_root/$mooname</b> must be created with <tt>chmod 775</tt>. Do not change the owner or the group for this folder.</li>
		<li><b>$doc_root/$mooname/$all_files</b> must be created with <tt>chmod 775</tt>, <tt>chown nobody</tt> (this may be <tt>www</tt> on your server), and <tt>chgrp nobody</tt> (this may also be <tt>www</tt> on your server).</li></ul>");
}





# Here are a number of things that need to be setup at some point.
$dirname = "$doc_root/$mooname/$all_files/$user";
$url = "http://$virtual_host/$mooname/$all_files/$user/$filename";
$url_path = "http://$virtual_host/$mooname/$all_files/$user";
$buffer = "";
$script_path = "http://$virtual_host/$this_file";
$css = "http://$virtual_host/$mooname/$css_file";

# There's no reason to change the name of the upload page on the
# MOO, but if it is changed, this line will need to be changed too.
$upload_util = "$virtual_host:$port/$obj_num/upload.html"; 

# Make sure this script is actually being called from the MOO.
&validate_referrer;

# Grab any stats about the user that you'll need later on.
# e.g. have they uploaded any files yet? how much of their quota
# are they using? etc.
&find_user_dir;

# Upload the user's files.
if ($do_me eq "upload") { &file_upload; }


# If the user wants to look at all their files, print them an HTML page.
if ($do_me eq "view") { &html_view; }


# If the user wants to delete files...
if ($do_me eq "delete") {

	# Make sure a user number is passed.
	if (! $user) { &error("<p class=\"error\">You are not authorized to delete files here!</p>"); }

	# Check to see if they want a specific item deleted.
	if ($del_file[0] ne "") { &file_delete; } 
	
	# Or print them an HTML page so they can pick file(s) to delete.
		else 
		{ &html_delete; }
} # End of Delete


# Display the user's quota.
if ($do_me eq "quota") { &html_quota; }


# Display the user's files so they can choose what gets renamed.
if ($do_me eq "rename") { &html_rename; }


# Do the actual renaming of the files.
if ($do_me eq "do_rename") { &file_rename; }

exit;


################################################################
# # # # # # # # # # # # # SUBROUTINES # # # # # # # # # # # # ##
# # # # # # # # # #  LISTED ALPHABETICALLY  # # # # # # # # # ##
################################################################


# --------------------------------------------------------------
# SUBROUTINE: DELETE_MESSAGE
# --------------------------------------------------------------

# This subroutine is also used by rename.

sub delete_message {

# Get the passed variables out. 
# Format: action_message($mod_type, @message, @message2);

  my $mod_type = shift(@_);
  my @message = shift(@_);
  my @message2 = shift(@_);

# Build the URL for the new file.

# Print the HTML page.
print "Content-type: text/html\n\n";
print <<"END_OF_MESSAGE";

<html>
<head>
<title>File Successfully $mod_type</title>
<style type="text/css" media="screen">\@import "$css";</style>
</head>

<body>
<h1>Files $mod_type</h1>

<div id="details">
	<h2>VASE</h2>
	<p>Username: $username</p>
	<p>User Number: $user</p>
</div>

<p>You have successfully $mod_type the following files:</p>

<ul>
END_OF_MESSAGE
	foreach $item (@message) {
		print "<li>$item</li>\n";
	}
	print "</ul>\n";


# If the rename didn't work because the filename was already
# being used, name the files that weren't renamed.

  if ($message2[0] ne "") {
    print "<p>The following items were NOT renamed because there 
          is already a file with that name:</p>";
   
    print "<ul>";

    foreach $item2 (@message2) {
		print "<li> $item2 </li>\n";
    }
   
    print "</ul>";

    print "<p>If you want to replace a
           file you must delete the original first using the Delete Files
           button below.</p>";
}


&footer;

exit;

} # end of delete_message subroutine



# --------------------------------------------------------------
# SUBROUTINE: DIR_CONTENTS
# --------------------------------------------------------------

sub dir_contents {

	$file_size = 0;
	
# Open the directory.
	opendir (CONTENTS, $dirname) || &error("<p class=\"error\">Couldn't open $dirname to make a list of
what's inside.</p>");

# Get the names of the files.
	@cont_name = readdir (CONTENTS);

# Take out the . and .. that start each directory.
	shift @cont_name;
	shift @cont_name;
	
# Get the sizes of the files.
	for $i(0..$#cont_name) {
		@statistics_01 = stat "$dirname/$cont_name[$i]";
		$file_size = $statistics_01[7];
		push @total_size, $file_size;
	}
	
	closedir (CONTENTS);

# Get the file extensions.
	@cont_ext = @cont_name;  		# Make a copy of the array

# Delete everything before the last . in the filename.
	foreach $cont_ext (@cont_ext) {
		$cont_ext =~ s/.*\.//g;			
	}
	
} # end of dir_contents





# --------------------------------------------------------------
# SUBROUTINE: DIR_SIZE
# --------------------------------------------------------------

sub dir_size {

	$dir_size = 0;

	if (-d $dirname) {

	# Loop through all the files and sum the sizes of the files. 
	# Does NOT check subdirectories.

	# Make sure you skip the error message if you're on the first file upload.
	# Assume that $dirlimit > $filelimit and that the script will bork if the 
	# file is too big, allowing us to skip &dir_size if the directory doesn't 
	# exist yet.
	
		opendir (DIR, $dirname) || &error("<p class=\"error\">Couldn't open $dirname to see how much
space you're using.</p>");

# Get the names of all the files.
			@total_dir = readdir (DIR);

# Take out the . and .. that start each directory.
	shift @total_dir;
	shift @total_dir;

# For each of those files, total up the size of the whole directory.
#	foreach $total_dir(@total_dir) {

			for $i(0..$#total_dir) {
				@statistics_02 = stat "$dirname/$total_dir[$i]";
				$file_size = $statistics_02[7];
				$dir_size += $file_size;
			}
	
		closedir (DIR);
	
	# Tell the max_dir subroutine the total size of the directory.
	# dir_size subroutine is called by max_dir.
		return $dir_size;

	} # End of -d $dirname

} # end of dir_size





# --------------------------------------------------------------
# SUBROUTINE: ERROR
# --------------------------------------------------------------

sub error {

# Get the error message out. Format: error("");
# Use shift to pluck out the only passed variable.

my $cgi_error = shift(@_);


print "Content-type: text/html\n\n";
  print <<"END_OF_ERROR";

<html>
<head>
<title>VASE File Upload Error</title>
<style type="text/css" media="screen">\@import "$css";</style>
</head>

<body>
<h1>File Upload Error</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

<p>You have experienced the following problem:</p>

$cgi_error

END_OF_ERROR
&footer;


# Send the error to the wiz.
if (($doMail eq "1") && ($wizmail ne "")) {

	open (MAIL, "| $mailprog -t") || die("Couldn't open mail program $mailprog");
	print MAIL "To: $wizmail\n";
	print MAIL "From: $mooname\n";
	print MAIL "Subject: $mooname Error\n\n";
	print MAIL "$username (#$user) generated the following error:\n\n";
	print MAIL "$cgi_error\n\n";
	print MAIL "If you don't want to get these notices, please set your VASE script to \$doMail=0\n\n";
	print MAIL ".";
	close(MAIL);
}


exit;
} # end of error subroutine



# --------------------------------------------------------------
# SUBROUTINE: FILE_DELETE
# --------------------------------------------------------------

sub file_delete {

# This loop goes through each item in the list of files 
# to delete and deletes them.

	foreach $file_to_del (@del_file) {
		unlink($file_to_del) || &error("<p class=\"error\">Could not delete file $file_to_del.</p>");	
	}
	
	&delete_message("deleted", "@del_file");

} # End of file_delete subroutine.





# --------------------------------------------------------------
# SUBROUTINE: FILE_RENAME
# --------------------------------------------------------------

sub file_rename {

# This loop goes through each item in the list of files 
# to rename and renames them.

	for $i(0..$#newname) {       	
	    if ( (! -f "$newname[$i]") && ("$newname[$i]" ne "$rename_file[$i]") ) {

		# Get everything from the old file.
		open (OLD, "<$dirname/$rename_file[$i]") 
		    || &error("<p class=\"error\">Couldn't open $dirname/$rename_file[$i] for rename.</p>");
		@old_contents = <OLD>;
		close (OLD);

		# Print it into the new file.
		open (NEW, ">$dirname/$newname[$i]")
		    || &error("<p class=\"error\">Couldn't create new file named $newname[$i] for rename.</p>");
		
		foreach $line (@old_contents) {
		    print NEW $line;
		}
		close (NEW);
		
		# Make sure the file has the right permissions.
		chmod (0664, "$dirname/$newname[$i]") || 
		    &error("<p class=\"error\">Couldn't chmod $newname[$i] for the rename function. This file won't be web-usable until the permissions are changed to 664.</p>");
	    
		# Delete the file with the old name.
		unlink ("$dirname/$rename_file[$i]") 
		    || &error("<p class=\"error\">The old file, $rename[$i] wasn't deleted.</p>");
		
	    } else { # Tell the user their file wasn't renamed.
		push (@rename_nochange, $rename_file[$i]);
	    }
	}


# Prepare the message to be passed for the viewer.
# If all files were changed, don't pass @rename_nochage.	
	if ($rename_nochange[0] ne "") {
	    &delete_message("renamed", "@rename_file", "@rename_nochange");
	    } else {
		&delete_message("renamed", "@rename_file");
	    }

} # End of file_rename subroutine.



# --------------------------------------------------------------
# SUBROUTINE: FILE_UPLOAD
# --------------------------------------------------------------

sub file_upload {

	if ($filename eq "") {
		&error("<p class=\"error\">Please specify a new name for your file!</p>");
	}

	&max_dir;
	&max_file;
	

# If the file is already in use, rename the incoming file.
	if (-f "$dirname/$filename") {

# This creates a file with an invalid extension.
# Users will have to rename the new file once it has been uploaded.

  $modify_filename = $filename . ".new";

# Open a new file to write the buffer into.
	    open (FILE, ">$dirname/$modify_filename") 
		|| &error("<p class=\"error\">Could not create a new file for $modify_filename 
                   (modified file name). $filename already exists.</p>");

# Write the contents of the buffer to the file in the user's directory.
	while ( read($file, $buffer, BUFFER_SIZE) ) {
		print (FILE $buffer) 
		    || &error("<p class=\"error\">Could not print the new file into $modify_filename.</p>");
		} # end of print to existing file
	
# Close the file once it has been written to
	close (FILE);

# Display the happy message subroutine for file replaced.
	&upload_message("Created", 
			"<p>Congratulations, your file has been uploaded.</p>
                        <p>PLEASE NOTE: A file with the same name already existed.</p>
                        <p>The file you just uploaded has been given a new name:</p>
                        <p>$modify_filename</p>
                        <p>This new file cannot be displayed (or listened to
                        if it's an audio file) in your browser until you
                        have renamed it with the correct extension. Please use
                        the <strong>Rename Files</strong> button at the bottom to change the name
                        of your new file.</p>
                        ");
 		
	} # end of existing file upload


	else


	{ # start of new file upload

# First check to see if the directory exists. If it doesn't exist, make it so.
	if (! -d "$dirname") {
		mkdir ($dirname, 0775) || &error("<p class=\"error\">The script failed to create
$dirname.</p>");
	}

# If the directory does exist, make sure it has the correct permissions.
	if (-d "$dirname") {
	chmod (0775, $dirname) 
	    || &error("<p class=\"error\">The script failed to change the permissions for $dirname.
                     You won't be able to upload files until $dirname is set to
                     chmod <strong>775</strong>. Please copy that number down and tell a wiz!</p>");
	}	

# Now the directory is in place, create a new file.
   open(FILE, ">$dirname/$filename") 
       || &error("<p class=\"error\">The script failed to create a new file for $filename.</p>");

# Read all the contents of what was uploaded and put it into the buffer
# then print the buffer into the new file that was opened.
   while ( read($file, $buffer, BUFFER_SIZE) ) {
         print (FILE $buffer) 
	     || &error("<p class=\"error\">The script failed to print the buffer into 
                      the new file ($filename).</p>");
   }

# Close the file
   close (FILE);

# Give the file the correct permissions
   chmod(0664, "$dirname/$filename") || &error("<p class=\"error\">The script failed to give the correct
permissions to $filename. You will not be able to view it on the web until the file
permissions have been fixed set to <strong>664</strong>. Please copy that number down and tell it 
to a wiz!</p>");

# Display the success message.
	&upload_message("Created", "<p>You have successfully created $filename.</p>
                       <p>Please use this url to link to your file:</p>
                       <p><a href=\"javascript:view(\'$url\')\">$url</a></p>
                       <p>Click on the url to view (or hear) your file.</p>
                       <p>NOTE: This will create a new browser window. Click in the
                       top left hand corner of the new window to close it.</p>
                       <p>Or use the <b>Close</b> option under the <strong>File</strong> menu.</p>");
}	
	
} # end of file_upload





# --------------------------------------------------------------
# SUBROUTINE: FIND_USER_DIR
# --------------------------------------------------------------

sub find_user_dir {

# Format $dirlimit nicely.
$nice_dirlimit = $dirlimit / 1000;
$nice_dirlimit =~ s/\..*//g;

# Get the current directory size.
&dir_size;

# If the directory exists, do the following:
if ( (-d "$dirname") && ($dir_size <= 0) && ($do_me ne "upload") ) {
	 &error("<p class=\"error\">There are no files in your directory right now! Your available quota
is $nice_dirlimit kb. <br>Try clicking on the <b>Upload Files</b> button to upload a file.</p>");
     }


# If the directory doesn't exist yet...
if ( (! -d "$dirname") && ($do_me ne "upload") ) {
    &error("<p class=\"error\">You haven't uploaded any files yet! Your available quota is $nice_dirlimit kb.</p> 
	<p class=\"error\">Try clicking on the <strong>Upload Files</strong> button to upload a file.</p>");
      }


} # end of find_user_dir





# --------------------------------------------------------------
# SUBROUTINE: FOOTER
# --------------------------------------------------------------

sub footer {
# Copyright notice and navigation options.
print <<"END_OF_FOOTER";

<div id="bottom_nav">
<table cellpadding="1" cellspacing="1" border="0"><tr>
<td><FORM METHOD="POST" ACTION="$script_path">
$hidden_fields
<INPUT TYPE="HIDDEN" NAME="do_me" VALUE="view">
<INPUT TYPE="SUBMIT" VALUE="List My Files">
</FORM></td>

<td><FORM METHOD="post" ACTION="$script_path">
$hidden_fields
<INPUT TYPE="HIDDEN" NAME="do_me" VALUE="quota">
<INPUT TYPE="SUBMIT" VALUE="Check My Quota">
</FORM></td>
</tr></table>

<table cellpadding="1" cellspacing="1" border="0"><tr>
<td><FORM METHOD="post" ACTION="$script_path">
$hidden_fields
<INPUT TYPE="HIDDEN" NAME="do_me" VALUE="delete">
<INPUT TYPE="SUBMIT" VALUE="Delete Files">
</FORM></td>

<td><FORM METHOD="post" ACTION="$script_path">
$hidden_fields
<INPUT TYPE="HIDDEN" NAME="do_me" VALUE="rename">
<INPUT TYPE="SUBMIT" VALUE="Rename Files">
</FORM></td>

<td>
<FORM NAME="UPLOAD">
<INPUT TYPE="BUTTON" VALUE="Upload Files" onClick="javascript:document.location='http://$upload_util';">
</FORM></td>
</tr></table>
</div>

<HR>

<h6>This utility is a component of VASE, Copyright 2001 Jason Nolan (jason.nolan\@utoronto.ca).</h6>
<h6>Code thanks to Emma, Traveller, Michel and Jason.</h6>

</body>
</html>



END_OF_FOOTER
} # end of footer




# --------------------------------------------------------------
# SUBROUTINE: HIDDEN
# --------------------------------------------------------------

sub hidden {

$hidden_fields = "
	<input type=\"hidden\" name=\"mooname\" value=\"$mooname\">	
	<input type=\"hidden\" name=\"user\" value=\"$user\">	
	<input type=\"hidden\" name=\"username\" value=\"$username\">	
	<input type=\"hidden\" name=\"filelimit\" value=\"$filelimit\">
	<input type=\"hidden\" name=\"dirlimit\" value=\"$dirlimit\">
	<input type=\"hidden\" name=\"port\" value=\"$port\">
	<input type=\"hidden\" name=\"obj_num\" value=\"$obj_num\">	
	<input type=\"hidden\" name=\"virtual_host\" value=\"$virtual_host\">
	<input type=\"hidden\" name=\"wizmail\" value=\"$wizmail\">	
";

} # end of hidden




# --------------------------------------------------------------
# SUBROUTINE: HTML_DELETE
# --------------------------------------------------------------

sub html_delete {

&dir_contents;

print "Content-type: text/html\n\n";

	print <<"END_OF_HEADER";

<html>
<head>
<title>File Listing for $username</title>
<style type="text/css" media="screen">\@import "$css";</style>

<script language="javascript">
    function view(url) {
        viewfile = window.open(url, 'viewfile', 'width=300,height=300,left=100,top=100,scrollbars=1,menubar=1,toolbar=0,status=0');
	window.viewfile.focus();
    }
</script>

</head>

<body>

<h1>Delete Files for $username</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

<p>Here is a list of all your files. Click on the url to view (or hear) your files.</p>

<p>The file will pop-up in a new window. Close this window to get back to this page.</p>

<p>To delete a file, click on the checkbox beside the file name and then click on delete
button at the bottom.</p>

<p><strong>Warning:</strong> Deleting files is FINAL and cannot be undone. 
	Please make sure you're clicking on the right box!</p>

<table border="1">
<form action="$script_path" method="POST">
<tr>
	<th>File Name</th>
	<th>Size</th>
	<th>Type</th>
	<th>Delete</th>
</tr>
END_OF_HEADER

	for $i(0..$#cont_name) {
		print "<tr>\n";
		print "<td><a href=\"javascript:view(\'$url_path/$cont_name[$i]\')\">$cont_name[$i]</a></td>\n";
		$file_listing_size = $total_size[$i] / 1000;
		print "<td>\n";
		printf ("%.0f", $file_listing_size);
		print " kb</td>\n";
		print "<td>$cont_ext[$i]</td>\n";	
		print "<td><input type=\"checkbox\" name=\"del_file\" value=\"$dirname/$cont_name[$i]\"></td>\n";
		print "</tr>\n";
	}
	
	print <<"END_OF_PAGE";
<tr>
	<td colspan="4" align="center">
	$hidden_fields	
	<input type="hidden" name="do_me" value="delete">
	<input type="submit" value="Delete Selected Files">
	<input type="reset" value="Reset Values">	
	</td>
</tr>
</table>

</form>
END_OF_PAGE

# Include copyright notice and navigation options.
&footer;

} # end of html_delete




# --------------------------------------------------------------
# SUBROUTINE: HTML_QUOTA
# --------------------------------------------------------------

sub html_quota {

&dir_contents;
&dir_size;

# For display purposes, show user-friendly number formats.
$dirlimit = $dirlimit / 1000;
$dir_size = $dir_size / 1000;
	
# Now get the amount of space left for that user.
	$space_left = $dirlimit - $dir_size;


print "Content-type: text/html\n\n";

	print <<"END_OF_HEADER";

<html>
	<head>
		<title>Quota for $username</title>
<style type="text/css" media="screen">\@import "$css";</style>
</head>

<body>
<h1>Quota for $username</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

<p>Here is a summary of the space available to you, how much you are using, and how much
you have left.</p>

<table border="1">
END_OF_HEADER

# Total space allowed, total space using, total space remaining.

	print "<tr><th>Total space allowed</th>\n";
	print "<td align=\"right\">$dirlimit kb</td></tr>\n";

	print "<tr><th>Total space using</th>\n";
	print "<td align=\"right\">\n";
	printf ("%.0f", $dir_size);
	print " kb</td></tr>\n";

	print "<tr><th>Total space remaining</th>\n";
	print "<td align=\"right\">\n";
	printf ("%.0f", $space_left);
	print " kb</td></tr>\n";

	print "</table>\n";
	
# Include the copyright notice and navigation.
&footer;

} # end of html_quota




# --------------------------------------------------------------
# SUBROUTINE: HTML_RENAME
# --------------------------------------------------------------

sub html_rename {

&dir_contents;

print "Content-type: text/html\n\n";

	print <<"END_OF_HEADER";

<html>
	<head>
		<title>Rename Files for $username</title>
<style type="text/css" media="screen">\@import "$css";</style>
<script language="javascript">
    function view(url) {
        viewfile = window.open(url, 'viewfile', 'width=300,height=300,left=100,top=100,scrollbars=1,menubar=1,toolbar=0,status=0');
	window.viewfile.focus();
    }
</script>
</head>

<body>
<h1>Rename Files for $username</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

<p>Here is a list of all your files. Click on the url to view (or hear) your files. 
The file will pop-up in a new window. Close this window to get back to this page.</p>

<p>To rename a file, click on the checkbox beside the file name. Type in the new name
(and extension) in the box beside and then click on the Rename button at the bottom.</p>

<p><strong>Warning:</strong> You cannot overwrite existing files. If you want to overwrite a file
you MUST delete it first. If you try to overwrite an existing file the file you
were trying to rename will NOT be changed.</p>

<table border="1">
<form action="$script_path" method="POST">
<tr>
	<th>File Name</th>
	<th>Type</th>
    <th><b>New Name</th>
</tr>
END_OF_HEADER



	for $i(0..$#cont_name) {
		print "<tr>\n";
		print "<td><a href=\"javascript:view(\'$url_path/$cont_name[$i]\')\">$cont_name[$i]</a></td>\n";
		print "<td>$cont_ext[$i]</td>\n";	
		print "<td><input type=\"textbox\" name=\"rename_$cont_name[$i]\" maxlength=\"100\"></td>\n";
		print "</tr>\n";
	}
	
	print <<"END_OF_PAGE";
<tr>
	<td colspan="4" align="center">
	$hidden_fields	
	<input type="hidden" name="do_me" value="do_rename">
	<input type="submit" value="Rename Selected Files">
	<input type="reset" value="Reset Values">	
	</td>
</tr>
</table>

</form>
END_OF_PAGE


# Include copyright notice and navigation options.
&footer;

} # end of html_rename




# --------------------------------------------------------------
# SUBROUTINE: HTML_VIEW
# --------------------------------------------------------------

sub html_view {

&dir_contents;

print "Content-type: text/html\n\n";

	print <<"END_OF_HEADER";

<html>
	<head>
		<title>Files for $username</title>
<style type="text/css" media="screen">\@import "$css";</style>
<script language="javascript">
    function view(url) {
        viewfile = window.open(url, 'viewfile', 'width=300,height=300,left=100,top=100,scrollbars=1,menubar=1,toolbar=0,status=0');
	window.viewfile.focus();
    }
</script>
</head>

<body>
<h1>Files for $username</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

<p>Here is a list of all your files. Click on the url to view (or hear) your files.</p>

<p>A new window will open with your file in it.</p>

<table border="1">
<tr valign="top">
	<th>File Name</th>
	<th>Size</th>
	<th>Type</th>
</tr>
END_OF_HEADER

	for $i(0..$#cont_name) {
		print "<tr>\n";
		print "<td><a href=\"javascript:view(\'$url_path/$cont_name[$i]\')\">$cont_name[$i]</a></td>\n";

		$file_listing_size = $total_size[$i] / 1000;
		print "<td>\n";
		printf ("%.0f", $file_listing_size);
		print " kb</td>\n";

		print "<td>$cont_ext[$i]</td>\n";			
		print "</tr>\n";
	}
	
	print "</table>";

# include the copyright and navigation options
&footer;

} # end of html_view




# --------------------------------------------------------------
# SUBROUTINE: MAX_DIR
# --------------------------------------------------------------

sub max_dir {
	if ( &dir_size($dirname) + $ENV{CONTENT_LENGTH} > $dirlimit ) {
		&error("<p class=\"error\">Your directory is full. You might want to delete some files, or
ask a wiz for more space.</p>");
	}

} # end of max_dir




# --------------------------------------------------------------
# SUBROUTINE: MAX_FILE
# --------------------------------------------------------------

# Note: This adds the value of the parameters being submitted in
# the form as well. They shouldn't be that large, but make sure 
# you allow a slightly greater file upload than what the limit is
# supposed to be.

sub max_file {

	if ( $ENV{CONTENT_LENGTH} > $filelimit ) {
		&error("<p class=\"error\">This individual file exceeds the allowed file size of
$filelimit.</p>");
	}

} # end max_file




# --------------------------------------------------------------
# SUBROUTINE: PARSE_FORM
# --------------------------------------------------------------

sub parse_form {

# Create the new CGI object.

	$mooname = $q->param('mooname');
	$user = $q->param('user');
	$username = $q->param('username');
	$port = $q->param('port');
	$obj_num = $q->param('obj_num');
	$virtual_host = $q->param('virtual_host');
	$do_me = $q->param('do_me');
	$filelimit = $q->param('filelimit');
	$dirlimit = $q->param('dirlimit');
	$wizmail = $q->param('wizmail');
	$file = $q->param('file');
	@del_file = $q->param('del_file');
	$filename = $q->param('filename');

# This grabs all the names for each of the fields submitted.
	@all_params = $q->param();

# Next we want to strip out any values that aren't
# associated with NAMES that we DO want.
	@newname = ();
	@rename_file = ();

	for $i(0..$#all_params) {

	    # We want only params that start with rename.
	    if ($all_params[$i] =~ m/rename_/) {

		# Get the value.
		my $form_value = $q->param($all_params[$i]);
		
		# We want only values that have been set.		
		if ($form_value ne ""){
		    push (@newname, $form_value);
		    $all_params[$i] =~ s/rename_//;
		    push (@rename_file, $all_params[$i]);
		}
	    }
	}


# Make sure you clean up the $filename that is submitted by the
# user so that Unix will like it.
	$filename =~ s/([^\w.-])/_/g;



} # end of parse_form




# --------------------------------------------------------------
# SUBROUTINE: UPLOAD_MESSAGE
# --------------------------------------------------------------

sub upload_message {

# Get the passed variables out. Format: upload_message($mod_type, $message);
# Since shift plucks the last item out of the list, start at the end of
# the array and work to the beginning.
  my $mod_type = shift(@_);
  my $message = shift(@_);

# Build the URL for the new file. 
  my $url = "http://$virtual_host/$mooname/$all_files/$user/$filename";

# Print the HTML page.
print "Content-type: text/html\n\n";
  print <<"END_OF_MESSAGE";

<html>
<head>
<title>File Successfully $mod_type</title>
<style type="text/css" media="screen">\@import "$css";</style>
<script language="javascript">
    function view(url) {
        viewfile = window.open(url, 'viewfile', 'width=300,height=300,left=100,top=100,scrollbars=1,menubar=1,toolbar=0,status=0');
        window.viewfile.focus();
    }
</script>
</head>

<body>
<h1>Files $mod_type</h1>

<div id="details">
	<h2>VASE</h2>
	<p>User #: $user</p>
	<p>Username: $username</p>
</div>

$message


END_OF_MESSAGE

&footer;

exit;

} # end of upload_message subroutine






# --------------------------------------------------------------
# SUBROUTINE: VALIDATE_REFERRER
# --------------------------------------------------------------

# Note: You must use POST in the form submitting to this script.
# This is case sensitive!

sub validate_referrer {

	if ($q->referer !~ m/http:\/\/$virtual_host/ || $q->request_method ne "POST") {
		&error("<p class=\"error\">That host is not permitted! Or the form you're using has not used the POST method.</p>");
	}

} # end of validate_referrer

