#ifndef __ENODE_BASE_H__
#define __ENODE_BASE_H__


/* Create new child node */
ENode *enode_new_child (ENode * node, gchar * basename, GSList * attribs);

/* Returns the element type */
EBufConst *enode_type (ENode * node);

/* Returns the path to a node */
EBufFreeMe *enode_path (ENode * node);

/* Return type.name for node - Allocates new ebuf */
EBufFreeMe *enode_basename (ENode * node);

/* Return a description of this node type */
gchar *enode_description (ENode * node);



/* Private */

ENode * enode_alloc (EBuf * type);

/* Initialize enode interface */
void enode_init (void);

/* return root node */
ENode *enode_root_node (void);

/* Same as enode_new_child (), but rendering is delayed. * Used by parser */
ENode *enode_new_child_norender (ENode * node, EBuf * type, GSList * attribs);

/* Free a node allocation.. *DO NOT USE DIRECTLY!* use unref (). */
void enode_free (ENode * node);


#endif				/* __ENODE_BASE_H__ */


