#ifndef __CSINKSOCKET_H__
#define __CSINKSOCKET_H__

/* csinksocket.h -- provides an "abstract" type for dealing with socket sinks
 * (inet,ssl) */

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/socket.h>

#include "csink.h"

/* Casting macros */
#define CSINK_SOCKET(sink)		( (CSinkSocket*)sink )
#define CSINK_SOCKET_TYPE		0xdeedee

/* status type */
#define SOCKET_CONNECTED               (1 << 0)
#define SOCKET_CONNECT_INPROGRESS      (1 << 1)
typedef int CSinkSocketStatus;

/* The type itself */
typedef struct _CSinkSocket CSinkSocket;

/* method callback types */
typedef int (*CSinkSocketListenFunc) (CSink * sink);
typedef void (*CSinkSocketCanReadFunc) (CSink * sink);

struct _CSinkSocket {
  CSink sink;			/* The sink. */

  socklen_t address_len;	/* 'cause unix is lame */
  int address_family;		/* ditto. */
  struct sockaddr *local_address; /* local interface/port binding */
  struct sockaddr *remote_address; /* remote host/port binding */

  int fd;			/* Socket fd. */
  void *read_watch_tag;		/* ticket stubs to get the drycleaning back */
  void *write_watch_tag;

  CSinkSocketStatus status;	/* connected,connecting, or not. */

  /* methods */
  CSinkSocketListenFunc listen;	/* listen method pointer */

  /* internal callbacks */
  CSinkSocketCanReadFunc can_read_action; /* some sinks (ssl) do different reads */
  CSinkSocketCanReadFunc can_write_action; /* some sinks (ssl) do different writes*/
  CSinkCallbackFunc accept_action; /* some sinks (ssl) do different accepts */
  CSinkCallbackFunc open_action; /* some sinks (ssl) do different opens */

  /* user callbacks */
  CSinkCallbackFunc on_accept;	/* called with the new connection sink */
};

/*=======================================*/

/* There is no construction method for sockets, they are 'abstract'.
 * (not the same way pictures of guys draws with pokemon prints are abstract) */

/* user-level functions */
void csink_socket_open (CSinkSocket *sink);
int csink_socket_listen (CSinkSocket * sink); /* returns nonzero on error */
void csink_socket_set_accept_func (CSinkSocket *sink, CSinkCallbackFunc func);

/* internal functions */

/* creation/destruction */
void csink_socket_init(CSinkSocket *sink, int address_len, int address_family);
void csink_socket_release(CSinkSocket *sink);
void csink_socket_close (CSinkSocket *sink);

int csink_socket_do_connect (CSinkSocket *sink);

/* manage the addresses */
void csink_socket_set_remote_address
		(CSinkSocket *sink, struct sockaddr *address);
void csink_socket_set_local_address
		(CSinkSocket *sink, struct sockaddr *address);

void csink_socket_on_accept (CSinkSocket *sink, CSink *newconn);
void csink_socket_can_read_action (CSinkSocket *sink);
void csink_socket_can_write_action (CSinkSocket *sink);
int csink_socket_default_listen (CSinkSocket *sink);

/* Other functions might be useful for sockets, for example, sockets all use the
 * same address format, so we might provide functions that handle those.  Then
 * actual socket implementations could use those rather than do it themselves.
 */

#endif

