/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-mime-common.h,v 1.11 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_MIME_COMMON_H

#define ETPAN_MIME_COMMON_H

#include "etpan-mime-common-types.h"
#include "etpan-subapp-types.h"
#include <libetpan/libetpan.h>

/*
  these 3 headers MUST be included before <sys/select.h>
  to insure compatibility with Mac OS X (this is true for 10.2)
*/
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/select.h>

void etpan_mime_common_set_fd(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    fd_set * fds,
    int * maxfd);

void etpan_mime_common_handle_fd(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    fd_set * fds);

void etpan_mime_common_handle_key(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    int key);

void etpan_mime_common_set_color(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

int etpan_mime_common_init(struct etpan_mime_common_app_state * state);

void etpan_mime_common_flush(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

void etpan_mime_common_done(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

int etpan_mime_common_set_msg(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    struct mailfolder * folder,
    mailmessage * msg);

mailmessage * etpan_mime_common_get_msg(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

struct mailfolder * etpan_mime_common_get_folder(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

void etpan_mime_common_leave(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    struct etpan_subapp * new_app);

int etpan_mime_common_display(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state,
    WINDOW * w, char * help_str);

struct mailmime *
etpan_mime_common_get_selected_mime(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

void etpan_mime_common_display_update(struct etpan_subapp * app,
    struct etpan_mime_common_app_state * state);

#endif
