/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbbr.so
 *
 *   File: dm.c
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <plugin.h>

#include "bbr.h"
#include "dm.h"


/*
 *  Function: BBR_can_activate
 */
int BBR_can_activate( storage_object_t *object )
{
        int rc=EINVAL;
        BBR_Private_Data *pdata=NULL;

        LOG_ENTRY();

        if (object){
		pdata = (BBR_Private_Data *)object->private_data;
                if ( pdata ) {
                        if ( pdata->signature==EVMS_BBR_SIGNATURE) {
                                rc=0;
                        }
                }
        }

        LOG_EXIT_INT(rc);
        return rc;
}


/*
 *  Function: BBR_activate
 *
 *  Called in order to create a mapping of an evms bbr
 *  feature object in the kernel.
 */
int BBR_activate( storage_object_t *object )
{
        int rc=EINVAL;
        BBR_Private_Data *pdata=NULL;
        dm_target_t target;
        dm_target_bbr_t bbr;

        LOG_ENTRY();

        if (object){
		pdata = (BBR_Private_Data *)object->private_data;
                if ( pdata ) {
                        if ( pdata->signature==EVMS_BBR_SIGNATURE) {
                                rc=0;
                        }
                }
        }

        if (!rc) {
                target.start = 0;
                target.length = object->size;
                target.type = DM_TARGET_BBR;
                target.data.bbr = &bbr;
                target.params = NULL;
                target.next = NULL;
                bbr.device.major = pdata->child->dev_major;
                bbr.device.minor = pdata->child->dev_minor;
                bbr.device.start = 0;
                bbr.table1_lba = pdata->active_bbr_table_lsn1;
                bbr.table2_lba = pdata->active_bbr_table_lsn2;
                bbr.replacement_blocks_lba = pdata->replacement_blocks_lsn;
                bbr.table_size = pdata->bbr_table_size_in_sectors;
                bbr.num_replacement_blocks = pdata->replacement_blocks_size_in_sectors;
                bbr.block_size = pdata->block_size;

		rc = EngFncs->dm_activate(object, &target);
		
		if (!rc) {
			object->flags &= ~SOFLAG_NEEDS_ACTIVATE;
	        }

        }

        LOG_EXIT_INT(rc);
        return rc;
}


/*
 *  Function: BBR_can_deactivate
 */
int BBR_can_deactivate( storage_object_t *object )
{
        LOG_ENTRY();

        LOG_EXIT_INT(0);
        return 0;
}


/*
 *  Function: BBR_deactivate
 *
 *  Called in order to delete an existing mapping of an evms
 *  bbr feature in the kernel.
 */
int BBR_deactivate( storage_object_t *object )
{
        int rc;

        LOG_ENTRY();

        rc = EngFncs->dm_deactivate(object);

	if (!rc) {
		object->flags &= ~SOFLAG_NEEDS_DEACTIVATE;
	}

        LOG_EXIT_INT(rc);
        return rc;
}


