/*
 *
 *   (C) Copyright IBM Corp. 2001, 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: main_window.c
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "main_window_cb.h"
#include "main_window.h"
#include "support.h"
#include "reopen.h"

GtkWidget *create_main_window(void)
{
	GtkWidget *main_window;
	GtkWidget *main_window_vbox;
	GtkWidget *menubar_handlebox;
	GtkWidget *main_menubar;
	guint tmp_key;
	GtkWidget *actions_menu_item;
	GtkWidget *actions_menu_item_menu;
	GtkAccelGroup *actions_menu_item_menu_accels;
	GtkWidget *create_submenu;
	GtkWidget *create_submenu_menu;
	GtkAccelGroup *create_submenu_menu_accels;
	GtkWidget *create_evms_volume_menu_item;
	GtkWidget *create_compatibility_volume_menu_item;
	GtkWidget *create_object_menu_item;
	GtkWidget *create_region_menu_item;
	GtkWidget *create_container_menu_item;
	GtkWidget *create_segment_menu_item;
	GtkWidget *delete_submenu;
	GtkWidget *delete_submenu_menu;
	GtkAccelGroup *delete_submenu_menu_accels;
	GtkWidget *delete_volume_menu_item;
	GtkWidget *delete_object_menu_item;
	GtkWidget *delete_container_menu_item;
	GtkWidget *expand_submenu;
	GtkWidget *expand_submenu_menu;
	GtkAccelGroup *expand_submenu_menu_accels;
	GtkWidget *expand_volume_menu_item;
	GtkWidget *expand_object_menu_item;
	GtkWidget *expand_container_menu_item;
	GtkWidget *shrink_submenu;
	GtkWidget *shrink_submenu_menu;
	GtkAccelGroup *shrink_submenu_menu_accels;
	GtkWidget *shrink_volume_menu_item;
	GtkWidget *shrink_object_menu_item;
	GtkWidget *shrink_container_menu_item;
	GtkWidget *add_submenu;
	GtkWidget *add_submenu_menu;
	GtkAccelGroup *add_submenu_menu_accels;
	GtkWidget *add_feature_to_volume_menu_item;
	GtkWidget *assign_segment_manager_to_storage_object;
	GtkWidget *remove_submenu;
	GtkWidget *remove_submenu_menu;
	GtkAccelGroup *remove_submenu_menu_accels;
	GtkWidget *remove_object_from_container_menu_item;
	GtkWidget *separator5;
	GtkWidget *remove_segment_manager_menu_item;
	GtkWidget *modify_submenu;
	GtkWidget *modify_submenu_menu;
	GtkAccelGroup *modify_submenu_menu_accels;
	GtkWidget *modify_volume_menu_item;
	GtkWidget *modify_object_menu_item;
	GtkWidget *modify_container_menu_item;
	GtkWidget *view_submenu;
	GtkWidget *view_submenu_menu;
	GtkAccelGroup *view_submenu_menu_accels;
	GtkWidget *view_messages_menu_item;
	GtkWidget *view_log_menu_item;
	GtkWidget *convert_submenu;
	GtkWidget *convert_submenu_menu;
	GtkAccelGroup *convert_submenu_menu_accels;
	GtkWidget *convert_to_evms_volume_menu_item;
	GtkWidget *convert_to_compatibility_volume_menu_item;
	GtkWidget *activation_submenu;
	GtkWidget *activation_submenu_menu;
	GtkAccelGroup *activation_submenu_menu_accels;
	GtkWidget *activate_menu_item;
	GtkWidget *deactivate_menu_item;
	GtkWidget *replace_menu_item;
	GtkWidget *separator2;
	GtkWidget *other_tasks_submenu;
	GtkWidget *other_tasks_submenu_menu;
	GtkAccelGroup *other_tasks_submenu_menu_accels;
	GtkWidget *volume_tasks_menu_item;
	GtkWidget *object_tasks_menu_item;
	GtkWidget *container_tasks_menu_item;
	GtkWidget *plugin_tasks_menu_item;
	GtkWidget *separator6;
	GtkWidget *file_system_submenu;
	GtkWidget *file_system_submenu_menu;
	GtkAccelGroup *file_system_submenu_menu_accels;
	GtkWidget *mkfs_menu_item;
	GtkWidget *fsck_menu_item;
	GtkWidget *mount_menu_item;
	GtkWidget *unmount_menu_item;
	GtkWidget *obliterate_filesystem_menu_item;
	GtkWidget *separator3;
	GtkWidget *commit_menu_item;
	GtkWidget *backup_menu_item;
	GtkWidget *separator1;
	GtkWidget *exit_menu_item;
	GtkWidget *evmsgui_settings;
	GtkWidget *evmsgui_settings_menu;
	GtkAccelGroup *evmsgui_settings_menu_accels;
	GtkWidget *admin_node_menu_item;
	GtkWidget *set_log_level_submenu;
	GtkWidget *set_log_level_submenu_menu;
	GtkAccelGroup *set_log_level_submenu_menu_accels;
/*  GtkWidget *engine_log_level_submenu; */
	GtkWidget *engine_log_level_submenu_menu;
	GtkAccelGroup *engine_log_level_submenu_menu_accels;
	GSList *engine_debug_levels_group = NULL;
	GtkWidget *critical_engine_level_menuitem;
	GtkWidget *serious_engine_level_menuitem;
	GtkWidget *error_engine_level_menuitem;
	GtkWidget *warning_engine_level_menuitem;
	GtkWidget *default_engine_level_menuitem;
	GtkWidget *details_engine_level_menuitem;
	GtkWidget *entry_exit_engine_level_menuitem;
	GtkWidget *debug_engine_level_menuitem;
	GtkWidget *extra_engine_level_menuitem;
	GtkWidget *everything_engine_level_menuitem;
/*  GtkWidget *kernel_info_level_submenu;
  GtkWidget *kernel_info_level_submenu_menu;
  GtkAccelGroup *kernel_info_level_submenu_menu_accels;
  GSList *kernel_debug_levels_group = NULL;
  GtkWidget *critical_kernel_level_menuitem;
  GtkWidget *serious_kernel_level_menuitem;
  GtkWidget *error_kernel_level_menuitem;
  GtkWidget *warning_kernel_level_menuitem;
  GtkWidget *default_kernel_level_menuitem;
  GtkWidget *details_kernel_level_menuitem;
  GtkWidget *debug_kernel_level_menuitem;
  GtkWidget *extra_kernel_level_menuitem;
  GtkWidget *entry_exit_kernel_level_menuitem;
  GtkWidget *everything_kernel_level_menuitem; */
	GtkWidget *help_menu_item;
	GtkWidget *help_menu_item_menu;
	GtkAccelGroup *help_menu_item_menu_accels;
	GtkWidget *web_links_menu_item;
	GtkWidget *help_separator;
	GtkWidget *about_menu_item;
	GtkWidget *toolbar_handlebox;
	GtkWidget *icon_button_toolbar;
	GtkWidget *tmp_toolbar_icon;
	GtkWidget *toolbar_commit_button;
	GtkWidget *refresh_button;
	GtkWidget *exit_button;
	GtkWidget *browser_notebook;
	GtkWidget *view_volumes_tree_frame;
	GtkWidget *view_volumes_scrolledwindow;
	GtkWidget *view_volumes_ctree;
	GtkWidget *view_volumes_tree_ctree_label;
	GtkWidget *view_volumes_size_ctree_label;
	GtkWidget *view_volumes_modified_ctree_label;
	GtkWidget *_;
	GtkWidget *view_volumes_ro_ctree_label;
	GtkWidget *view_volumes_plugin_ctree_label;
	GtkWidget *view_volumes_mp_ctree_label;
	GtkWidget *volumes_view_tab_hbox;
	GtkWidget *volumes_view_tab_label;
	GtkWidget *view_objects_frame;
	GtkWidget *view_objects_scrolledwindow;
	GtkWidget *view_objects_ctree;
	GtkWidget *view_objects_tree_ctree_label;
	GtkWidget *view_objects_size_ctree_label;
	GtkWidget *view_objects_modified_ctree_label;
	GtkWidget *view_objects_active_ctree_label;
	GtkWidget *view_objects_ro_ctree_label;
	GtkWidget *view_objects_plugin_ctree_label;
	GtkWidget *topmost_view_tab_hbox;
	GtkWidget *topmost_view_tab_label;
	GtkWidget *view_feature_objects_frame;
	GtkWidget *scrolledwindow1;
	GtkWidget *ctree1;
	GtkWidget *label2;
	GtkWidget *label3;
	GtkWidget *label4;
	GtkWidget *label7;
	GtkWidget *label9;
	GtkWidget *label5;
	GtkWidget *feature_objects_view_tab_hbox;
	GtkWidget *feature_objects_view_tab_label;
	GtkWidget *view_regions_tree_frame;
	GtkWidget *view_regions_scrolledwindow;
	GtkWidget *view_regions_ctree;
	GtkWidget *view_regions_tree_ctree_label;
	GtkWidget *view_regions_size_ctree_label;
	GtkWidget *view_regions_modified_ctree_label;
	GtkWidget *view_regions_active_ctree_label;
	GtkWidget *view_regions_ro_ctree_label;
	GtkWidget *view_regions_corrupt_ctree_label;
	GtkWidget *regions_view_tab_hbox;
	GtkWidget *regions_view_tab_label;
	GtkWidget *view_containers_tree_frame;
	GtkWidget *view_containers_scrolledwindow;
	GtkWidget *view_containers_ctree;
	GtkWidget *view_containers_tree_ctree_label;
	GtkWidget *view_containers_size_ctree_label;
	GtkWidget *view_containers_modified_ctree_label;
	GtkWidget *view_containers_active_ctree_label;
	GtkWidget *view_containers_ro_ctree_label;
	GtkWidget *containers_view_tab_hbox;
	GtkWidget *containers_view_tab_label;
	GtkWidget *view_segments_tree_frame;
	GtkWidget *view_segments_scrolledwindow;
	GtkWidget *view_segments_ctree;
	GtkWidget *view_segments_tree_ctree_label;
	GtkWidget *view_segments_size_ctree_label;
	GtkWidget *view_segments_modified_ctree_label;
	GtkWidget *view_segments_active_ctree_label;
	GtkWidget *view_segments_ro_ctree_label;
	GtkWidget *view_segments_type_ctree_label;
	GtkWidget *view_segments_offset_ctree_label;
	GtkWidget *segments_view_tab_hbox;
	GtkWidget *segments_view_tab_label;
	GtkWidget *view_disks_tree_frame;
	GtkWidget *view_disks_tree_scrolledwindow;
	GtkWidget *view_disks_ctree;
	GtkWidget *view_disks_tree_ctree_label;
	GtkWidget *view_disks_size_ctree_label;
	GtkWidget *view_disks_modified_ctree_label;
	GtkWidget *view_disks_active_ctree_label;
	GtkWidget *view_disks_ro_ctree_label;
	GtkWidget *view_disks_geometry_ctree_label;
	GtkWidget *disks_view_tab_hbox;
	GtkWidget *disks_view_tab_label;
	GtkWidget *view_plugin_list_frame;
	GtkWidget *plugin_scrolledwindow;
	GtkWidget *plugin_columned_list;
	GtkWidget *plugin_icon_clist_label;
	GtkWidget *plugin_id_clist_label;
	GtkWidget *plugin_version_clist_label;
	GtkWidget *plugin_name_clist_label;
	GtkWidget *plugin_oem_clist_label;
	GtkWidget *plugin_description_clist_label;
	GtkWidget *plugins_view_tab_hbox;
	GtkWidget *plugins_view_tab_label;
	GtkWidget *table_containing_bars;
	GtkWidget *main_status_bar;
	GtkWidget *main_progress_bar;
	GtkAccelGroup *accel_group;
	GtkTooltips *tooltips;

	tooltips = gtk_tooltips_new();

	accel_group = gtk_accel_group_new();

	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_name(main_window, "main_window");
	gtk_object_set_data(GTK_OBJECT(main_window), "main_window", main_window);
	gtk_window_set_title(GTK_WINDOW(main_window), _("EVMS Administration Utility"));
	gtk_window_set_position(GTK_WINDOW(main_window), GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(main_window), 789, 550);
	gtk_window_set_policy(GTK_WINDOW(main_window), TRUE, TRUE, FALSE);

	main_window_vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_name(main_window_vbox, "main_window_vbox");
	gtk_widget_ref(main_window_vbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "main_window_vbox", main_window_vbox,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(main_window_vbox);
	gtk_container_add(GTK_CONTAINER(main_window), main_window_vbox);

	menubar_handlebox = gtk_handle_box_new();
	gtk_widget_set_name(menubar_handlebox, "menubar_handlebox");
	gtk_widget_ref(menubar_handlebox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "menubar_handlebox", menubar_handlebox,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(menubar_handlebox);
	gtk_box_pack_start(GTK_BOX(main_window_vbox), menubar_handlebox, FALSE, FALSE, 0);

	main_menubar = gtk_menu_bar_new();
	gtk_widget_set_name(main_menubar, "main_menubar");
	gtk_widget_ref(main_menubar);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "main_menubar", main_menubar,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(main_menubar);
	gtk_container_add(GTK_CONTAINER(menubar_handlebox), main_menubar);

	actions_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(actions_menu_item)->child),
					_("_Actions"));
	gtk_widget_add_accelerator(actions_menu_item, "activate_item", accel_group,
				   tmp_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	gtk_widget_set_name(actions_menu_item, "actions_menu_item");
	gtk_widget_ref(actions_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "actions_menu_item", actions_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(actions_menu_item);
	gtk_container_add(GTK_CONTAINER(main_menubar), actions_menu_item);

	actions_menu_item_menu = gtk_menu_new();
	gtk_widget_set_name(actions_menu_item_menu, "actions_menu_item_menu");
	gtk_widget_ref(actions_menu_item_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "actions_menu_item_menu",
				 actions_menu_item_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(actions_menu_item), actions_menu_item_menu);
	actions_menu_item_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(actions_menu_item_menu));

	create_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_submenu)->child), _("_Create"));
	gtk_widget_add_accelerator(create_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(create_submenu, "create_submenu");
	gtk_widget_ref(create_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_submenu", create_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), create_submenu);

	create_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(create_submenu_menu, "create_submenu_menu");
	gtk_widget_ref(create_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_submenu_menu",
				 create_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(create_submenu), create_submenu_menu);
	create_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(create_submenu_menu));

	create_evms_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_evms_volume_menu_item)->child),
					_("_EVMS Volume..."));
	gtk_widget_add_accelerator(create_evms_volume_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_evms_volume_menu_item, "create_evms_volume_menu_item");
	gtk_widget_ref(create_evms_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_evms_volume_menu_item",
				 create_evms_volume_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_evms_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu), create_evms_volume_menu_item);

	create_compatibility_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_compatibility_volume_menu_item)->child),
				  _("Compatibility _Volume..."));
	gtk_widget_add_accelerator(create_compatibility_volume_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_compatibility_volume_menu_item,
			    "create_compatibility_volume_menu_item");
	gtk_widget_ref(create_compatibility_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_compatibility_volume_menu_item",
				 create_compatibility_volume_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_compatibility_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu),
			  create_compatibility_volume_menu_item);

	create_object_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_object_menu_item)->child),
					_("_Feature Object..."));
	gtk_widget_add_accelerator(create_object_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_object_menu_item, "create_object_menu_item");
	gtk_widget_ref(create_object_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_object_menu_item",
				 create_object_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_object_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu), create_object_menu_item);

	create_region_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_region_menu_item)->child),
					_("_Region..."));
	gtk_widget_add_accelerator(create_region_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_region_menu_item, "create_region_menu_item");
	gtk_widget_ref(create_region_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_region_menu_item",
				 create_region_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_region_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu), create_region_menu_item);

	create_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_container_menu_item)->child),
					_("_Container..."));
	gtk_widget_add_accelerator(create_container_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_container_menu_item, "create_container_menu_item");
	gtk_widget_ref(create_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_container_menu_item",
				 create_container_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_container_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu), create_container_menu_item);

	create_segment_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(create_segment_menu_item)->child),
					_("_Segment..."));
	gtk_widget_add_accelerator(create_segment_menu_item, "activate_item",
				   create_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(create_segment_menu_item, "create_segment_menu_item");
	gtk_widget_ref(create_segment_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "create_segment_menu_item",
				 create_segment_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(create_segment_menu_item);
	gtk_container_add(GTK_CONTAINER(create_submenu_menu), create_segment_menu_item);

	delete_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(delete_submenu)->child), _("_Delete"));
	gtk_widget_add_accelerator(delete_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(delete_submenu, "delete_submenu");
	gtk_widget_ref(delete_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "delete_submenu", delete_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(delete_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), delete_submenu);

	delete_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(delete_submenu_menu, "delete_submenu_menu");
	gtk_widget_ref(delete_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "delete_submenu_menu",
				 delete_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(delete_submenu), delete_submenu_menu);
	delete_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(delete_submenu_menu));

	delete_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(delete_volume_menu_item)->child),
					_("_Volume..."));
	gtk_widget_add_accelerator(delete_volume_menu_item, "activate_item",
				   delete_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(delete_volume_menu_item, "delete_volume_menu_item");
	gtk_widget_ref(delete_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "delete_volume_menu_item",
				 delete_volume_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(delete_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(delete_submenu_menu), delete_volume_menu_item);

	delete_object_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(delete_object_menu_item)->child),
					_("_Storage Object..."));
	gtk_widget_add_accelerator(delete_object_menu_item, "activate_item",
				   delete_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(delete_object_menu_item, "delete_object_menu_item");
	gtk_widget_ref(delete_object_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "delete_object_menu_item",
				 delete_object_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(delete_object_menu_item);
	gtk_container_add(GTK_CONTAINER(delete_submenu_menu), delete_object_menu_item);

	delete_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(delete_container_menu_item)->child),
					_("_Container..."));
	gtk_widget_add_accelerator(delete_container_menu_item, "activate_item",
				   delete_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(delete_container_menu_item, "delete_container_menu_item");
	gtk_widget_ref(delete_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "delete_container_menu_item",
				 delete_container_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(delete_container_menu_item);
	gtk_container_add(GTK_CONTAINER(delete_submenu_menu), delete_container_menu_item);

	activation_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(activation_submenu)->child), _("Ac_tivation"));
	gtk_widget_add_accelerator(activation_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(activation_submenu, "activation_submenu");
	gtk_widget_ref(activation_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "activation_submenu", activation_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(activation_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), activation_submenu);

	activation_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(activation_submenu_menu, "activation_submenu_menu");
	gtk_widget_ref(activation_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "activation_submenu_menu",
				 activation_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(activation_submenu), activation_submenu_menu);
	activation_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(activation_submenu_menu));

	activate_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(activate_menu_item)->child),
					_("_Activate..."));
	gtk_widget_add_accelerator(activate_menu_item, "activate_item",
				   activation_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(activate_menu_item, "activate_menu_item");
	gtk_widget_ref(activate_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "activate_menu_item",
				 activate_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(activate_menu_item);
	gtk_container_add(GTK_CONTAINER(activation_submenu_menu), activate_menu_item);

	deactivate_menu_item = gtk_menu_item_new_with_label("");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL
				  (GTK_BIN(deactivate_menu_item)->child),
				  _("_Deactivate..."));
	gtk_widget_add_accelerator(deactivate_menu_item, "activate_item",
				   activation_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(deactivate_menu_item,
			    "deactivate_menu_item");
	gtk_widget_ref(deactivate_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window),
				 "deactivate_menu_item",
				 deactivate_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(deactivate_menu_item);
	gtk_container_add(GTK_CONTAINER(activation_submenu_menu),
			  deactivate_menu_item);

	expand_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(expand_submenu)->child), _("_Expand"));
	gtk_widget_add_accelerator(expand_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(expand_submenu, "expand_submenu");
	gtk_widget_ref(expand_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "expand_submenu", expand_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(expand_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), expand_submenu);

	expand_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(expand_submenu_menu, "expand_submenu_menu");
	gtk_widget_ref(expand_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "expand_submenu_menu",
				 expand_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(expand_submenu), expand_submenu_menu);
	expand_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(expand_submenu_menu));

	expand_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(expand_volume_menu_item)->child),
					_("_Volume..."));
	gtk_widget_add_accelerator(expand_volume_menu_item, "activate_item",
				   expand_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(expand_volume_menu_item, "expand_volume_menu_item");
	gtk_widget_ref(expand_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "expand_volume_menu_item",
				 expand_volume_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(expand_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(expand_submenu_menu), expand_volume_menu_item);

	expand_object_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(expand_object_menu_item)->child),
					_("_Storage Object..."));
	gtk_widget_add_accelerator(expand_object_menu_item, "activate_item",
				   expand_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(expand_object_menu_item, "expand_object_menu_item");
	gtk_widget_ref(expand_object_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "expand_object_menu_item",
				 expand_object_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(expand_object_menu_item);
	gtk_container_add(GTK_CONTAINER(expand_submenu_menu), expand_object_menu_item);

	expand_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(expand_container_menu_item)->child),
					_("_Container..."));
	gtk_widget_add_accelerator(expand_container_menu_item, "activate_item",
				   expand_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(expand_container_menu_item, "expand_container_menu_item");
	gtk_widget_ref(expand_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "expand_container_menu_item",
				 expand_container_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(expand_container_menu_item);
	gtk_container_add(GTK_CONTAINER(expand_submenu_menu), expand_container_menu_item);

	shrink_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(shrink_submenu)->child), _("S_hrink"));
	gtk_widget_add_accelerator(shrink_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(shrink_submenu, "shrink_submenu");
	gtk_widget_ref(shrink_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "shrink_submenu", shrink_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(shrink_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), shrink_submenu);

	shrink_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(shrink_submenu_menu, "shrink_submenu_menu");
	gtk_widget_ref(shrink_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "shrink_submenu_menu",
				 shrink_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(shrink_submenu), shrink_submenu_menu);
	shrink_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(shrink_submenu_menu));

	shrink_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(shrink_volume_menu_item)->child),
					_("_Volume..."));
	gtk_widget_add_accelerator(shrink_volume_menu_item, "activate_item",
				   shrink_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(shrink_volume_menu_item, "shrink_volume_menu_item");
	gtk_widget_ref(shrink_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "shrink_volume_menu_item",
				 shrink_volume_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(shrink_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(shrink_submenu_menu), shrink_volume_menu_item);

	shrink_object_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(shrink_object_menu_item)->child),
					_("_Storage Object..."));
	gtk_widget_add_accelerator(shrink_object_menu_item, "activate_item",
				   shrink_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(shrink_object_menu_item, "shrink_object_menu_item");
	gtk_widget_ref(shrink_object_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "shrink_object_menu_item",
				 shrink_object_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(shrink_object_menu_item);
	gtk_container_add(GTK_CONTAINER(shrink_submenu_menu), shrink_object_menu_item);

	shrink_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(shrink_container_menu_item)->child),
					_("_Container..."));
	gtk_widget_add_accelerator(shrink_container_menu_item, "activate_item",
				   shrink_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(shrink_container_menu_item, "shrink_container_menu_item");
	gtk_widget_ref(shrink_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "shrink_container_menu_item",
				 shrink_container_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(shrink_container_menu_item);
	gtk_container_add(GTK_CONTAINER(shrink_submenu_menu), shrink_container_menu_item);

	add_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(add_submenu)->child), _("_Add"));
	gtk_widget_add_accelerator(add_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(add_submenu, "add_submenu");
	gtk_widget_ref(add_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "add_submenu", add_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(add_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), add_submenu);

	add_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(add_submenu_menu, "add_submenu_menu");
	gtk_widget_ref(add_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "add_submenu_menu", add_submenu_menu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(add_submenu), add_submenu_menu);
	add_submenu_menu_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(add_submenu_menu));

	add_feature_to_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(add_feature_to_volume_menu_item)->child),
					_("_Feature to Volume..."));
	gtk_widget_add_accelerator(add_feature_to_volume_menu_item, "activate_item",
				   add_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(add_feature_to_volume_menu_item, "add_feature_to_volume_menu_item");
	gtk_widget_ref(add_feature_to_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "add_feature_to_volume_menu_item",
				 add_feature_to_volume_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(add_feature_to_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(add_submenu_menu), add_feature_to_volume_menu_item);

	assign_segment_manager_to_storage_object = gtk_menu_item_new_with_label("");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL
				  (GTK_BIN(assign_segment_manager_to_storage_object)->child),
				  _("_Segment Manager to Storage Object..."));
	gtk_widget_add_accelerator(assign_segment_manager_to_storage_object, "activate_item",
				   add_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(assign_segment_manager_to_storage_object,
			    "assign_segment_manager_to_storage_object");
	gtk_widget_ref(assign_segment_manager_to_storage_object);
	gtk_object_set_data_full(GTK_OBJECT(main_window),
				 "assign_segment_manager_to_storage_object",
				 assign_segment_manager_to_storage_object,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(assign_segment_manager_to_storage_object);
	gtk_container_add(GTK_CONTAINER(add_submenu_menu),
			  assign_segment_manager_to_storage_object);

	remove_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(remove_submenu)->child), _("_Remove"));
	gtk_widget_add_accelerator(remove_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(remove_submenu, "remove_submenu");
	gtk_widget_ref(remove_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "remove_submenu", remove_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(remove_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), remove_submenu);

	remove_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(remove_submenu_menu, "remove_submenu_menu");
	gtk_widget_ref(remove_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "remove_submenu_menu",
				 remove_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(remove_submenu), remove_submenu_menu);
	remove_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(remove_submenu_menu));

	remove_object_from_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(remove_object_from_container_menu_item)->child),
				  _("Storage _Object from Container..."));
	gtk_widget_add_accelerator(remove_object_from_container_menu_item, "activate_item",
				   remove_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(remove_object_from_container_menu_item,
			    "remove_object_from_container_menu_item");
	gtk_widget_ref(remove_object_from_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "remove_object_from_container_menu_item",
				 remove_object_from_container_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(remove_object_from_container_menu_item);
	gtk_container_add(GTK_CONTAINER(remove_submenu_menu),
			  remove_object_from_container_menu_item);

	separator5 = gtk_menu_item_new();
	gtk_widget_set_name(separator5, "separator5");
	gtk_widget_ref(separator5);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "separator5", separator5,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(separator5);
	gtk_container_add(GTK_CONTAINER(remove_submenu_menu), separator5);
	gtk_widget_set_sensitive(separator5, FALSE);

	remove_segment_manager_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(remove_segment_manager_menu_item)->child),
					_("Seg_ment Manager from Storage Object..."));
	gtk_widget_add_accelerator(remove_segment_manager_menu_item, "activate_item",
				   remove_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(remove_segment_manager_menu_item, "remove_segment_manager_menu_item");
	gtk_widget_ref(remove_segment_manager_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "remove_segment_manager_menu_item",
				 remove_segment_manager_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(remove_segment_manager_menu_item);
	gtk_container_add(GTK_CONTAINER(remove_submenu_menu), remove_segment_manager_menu_item);

	modify_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(modify_submenu)->child), _("_Modify"));
	gtk_widget_add_accelerator(modify_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(modify_submenu, "modify_submenu");
	gtk_widget_ref(modify_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "modify_submenu", modify_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(modify_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), modify_submenu);

	modify_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(modify_submenu_menu, "modify_submenu_menu");
	gtk_widget_ref(modify_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "modify_submenu_menu",
				 modify_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(modify_submenu), modify_submenu_menu);
	modify_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(modify_submenu_menu));

	modify_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(modify_volume_menu_item)->child),
					_("_Volume..."));
	gtk_widget_add_accelerator(modify_volume_menu_item, "activate_item",
				   modify_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(modify_volume_menu_item, "modify_volume_menu_item");
	gtk_widget_ref(modify_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "modify_volume_menu_item",
				 modify_volume_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(modify_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(modify_submenu_menu), modify_volume_menu_item);

	modify_object_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(modify_object_menu_item)->child),
					_("_Storage Object..."));
	gtk_widget_add_accelerator(modify_object_menu_item, "activate_item",
				   modify_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(modify_object_menu_item, "modify_object_menu_item");
	gtk_widget_ref(modify_object_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "modify_object_menu_item",
				 modify_object_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(modify_object_menu_item);
	gtk_container_add(GTK_CONTAINER(modify_submenu_menu), modify_object_menu_item);

	modify_container_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(modify_container_menu_item)->child),
					_("_Container..."));
	gtk_widget_add_accelerator(modify_container_menu_item, "activate_item",
				   modify_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(modify_container_menu_item, "modify_container_menu_item");
	gtk_widget_ref(modify_container_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "modify_container_menu_item",
				 modify_container_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(modify_container_menu_item);
	gtk_container_add(GTK_CONTAINER(modify_submenu_menu), modify_container_menu_item);

	view_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(view_submenu)->child), _("_View"));
	gtk_widget_add_accelerator(view_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(view_submenu, "view_submenu");
	gtk_widget_ref(view_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_submenu", view_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), view_submenu);

	view_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(view_submenu_menu, "view_submenu_menu");
	gtk_widget_ref(view_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_submenu_menu", view_submenu_menu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(view_submenu), view_submenu_menu);
	view_submenu_menu_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(view_submenu_menu));

	view_messages_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(view_messages_menu_item)->child),
					_("_Messages..."));
	gtk_widget_add_accelerator(view_messages_menu_item, "activate_item",
				   view_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(view_messages_menu_item, "view_messages_menu_item");
	gtk_widget_ref(view_messages_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_messages_menu_item",
				 view_messages_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_messages_menu_item);
	gtk_container_add(GTK_CONTAINER(view_submenu_menu), view_messages_menu_item);

	view_log_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(view_log_menu_item)->child),
					_("_Log File..."));
	gtk_widget_add_accelerator(view_log_menu_item, "activate_item", view_submenu_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(view_log_menu_item, "view_log_menu_item");
	gtk_widget_ref(view_log_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_log_menu_item", view_log_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_log_menu_item);
	gtk_container_add(GTK_CONTAINER(view_submenu_menu), view_log_menu_item);
	gtk_widget_set_sensitive(view_log_menu_item, FALSE);

	convert_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(convert_submenu)->child), _("C_onvert"));
	gtk_widget_add_accelerator(convert_submenu, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(convert_submenu, "convert_submenu");
	gtk_widget_ref(convert_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "convert_submenu", convert_submenu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(convert_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), convert_submenu);

	convert_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(convert_submenu_menu, "convert_submenu_menu");
	gtk_widget_ref(convert_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "convert_submenu_menu",
				 convert_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(convert_submenu), convert_submenu_menu);
	convert_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(convert_submenu_menu));

	convert_to_evms_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(convert_to_evms_volume_menu_item)->child),
					_("_Compatibility Volume to EVMS Volume..."));
	gtk_widget_add_accelerator(convert_to_evms_volume_menu_item, "activate_item",
				   convert_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(convert_to_evms_volume_menu_item, "convert_to_evms_volume_menu_item");
	gtk_widget_ref(convert_to_evms_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "convert_to_evms_volume_menu_item",
				 convert_to_evms_volume_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(convert_to_evms_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(convert_submenu_menu), convert_to_evms_volume_menu_item);

	convert_to_compatibility_volume_menu_item = gtk_menu_item_new_with_label("");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL
				  (GTK_BIN(convert_to_compatibility_volume_menu_item)->child),
				  _("_EVMS Volume to Compatibility Volume..."));
	gtk_widget_add_accelerator(convert_to_compatibility_volume_menu_item, "activate_item",
				   convert_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(convert_to_compatibility_volume_menu_item,
			    "convert_to_compatibility_volume_menu_item");
	gtk_widget_ref(convert_to_compatibility_volume_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window),
				 "convert_to_compatibility_volume_menu_item",
				 convert_to_compatibility_volume_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(convert_to_compatibility_volume_menu_item);
	gtk_container_add(GTK_CONTAINER(convert_submenu_menu),
			  convert_to_compatibility_volume_menu_item);

	replace_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(replace_menu_item)->child),
					_("Re_place..."));
	gtk_widget_add_accelerator(replace_menu_item, "activate_item",
				   actions_menu_item_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(replace_menu_item, "replace_menu_item");
	gtk_widget_ref(replace_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "replace_menu_item", replace_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(replace_menu_item);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), replace_menu_item);

	separator2 = gtk_menu_item_new();
	gtk_widget_set_name(separator2, "separator2");
	gtk_widget_ref(separator2);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "separator2", separator2,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(separator2);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), separator2);
	gtk_widget_set_sensitive(separator2, FALSE);

	other_tasks_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(other_tasks_submenu)->child),
					_("O_ther"));
	gtk_widget_add_accelerator(other_tasks_submenu, "activate_item",
				   actions_menu_item_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(other_tasks_submenu, "other_tasks_submenu");
	gtk_widget_ref(other_tasks_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "other_tasks_submenu",
				 other_tasks_submenu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(other_tasks_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), other_tasks_submenu);

	other_tasks_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(other_tasks_submenu_menu, "other_tasks_submenu_menu");
	gtk_widget_ref(other_tasks_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "other_tasks_submenu_menu",
				 other_tasks_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(other_tasks_submenu), other_tasks_submenu_menu);
	other_tasks_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(other_tasks_submenu_menu));

	volume_tasks_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(volume_tasks_menu_item)->child),
					_("_Volume Tasks..."));
	gtk_widget_add_accelerator(volume_tasks_menu_item, "activate_item",
				   other_tasks_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(volume_tasks_menu_item, "volume_tasks_menu_item");
	gtk_widget_ref(volume_tasks_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "volume_tasks_menu_item",
				 volume_tasks_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(volume_tasks_menu_item);
	gtk_container_add(GTK_CONTAINER(other_tasks_submenu_menu), volume_tasks_menu_item);

	object_tasks_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(object_tasks_menu_item)->child),
					_("_Storage Object Tasks..."));
	gtk_widget_add_accelerator(object_tasks_menu_item, "activate_item",
				   other_tasks_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(object_tasks_menu_item, "object_tasks_menu_item");
	gtk_widget_ref(object_tasks_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "object_tasks_menu_item",
				 object_tasks_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(object_tasks_menu_item);
	gtk_container_add(GTK_CONTAINER(other_tasks_submenu_menu), object_tasks_menu_item);

	container_tasks_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(container_tasks_menu_item)->child),
					_("_Container Tasks..."));
	gtk_widget_add_accelerator(container_tasks_menu_item, "activate_item",
				   other_tasks_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(container_tasks_menu_item, "container_tasks_menu_item");
	gtk_widget_ref(container_tasks_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "container_tasks_menu_item",
				 container_tasks_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(container_tasks_menu_item);
	gtk_container_add(GTK_CONTAINER(other_tasks_submenu_menu), container_tasks_menu_item);

	plugin_tasks_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(plugin_tasks_menu_item)->child),
					_("_Plugin Tasks..."));
	gtk_widget_add_accelerator(plugin_tasks_menu_item, "activate_item",
				   other_tasks_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(plugin_tasks_menu_item, "plugin_tasks_menu_item");
	gtk_widget_ref(plugin_tasks_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_tasks_menu_item",
				 plugin_tasks_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_tasks_menu_item);
	gtk_container_add(GTK_CONTAINER(other_tasks_submenu_menu), plugin_tasks_menu_item);

	separator6 = gtk_menu_item_new();
	gtk_widget_set_name(separator6, "separator6");
	gtk_widget_ref(separator6);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "separator6", separator6,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(separator6);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), separator6);
	gtk_widget_set_sensitive(separator6, FALSE);

	file_system_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(file_system_submenu)->child),
					_("_File System"));
	gtk_widget_add_accelerator(file_system_submenu, "activate_item",
				   actions_menu_item_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(file_system_submenu, "file_system_submenu");
	gtk_widget_ref(file_system_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "file_system_submenu",
				 file_system_submenu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(file_system_submenu);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), file_system_submenu);

	file_system_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(file_system_submenu_menu, "file_system_submenu_menu");
	gtk_widget_ref(file_system_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "file_system_submenu_menu",
				 file_system_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(file_system_submenu), file_system_submenu_menu);
	file_system_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(file_system_submenu_menu));

	mkfs_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(mkfs_menu_item)->child), _("_Make..."));
	gtk_widget_add_accelerator(mkfs_menu_item, "activate_item", file_system_submenu_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(mkfs_menu_item, "mkfs_menu_item");
	gtk_widget_ref(mkfs_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "mkfs_menu_item", mkfs_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(mkfs_menu_item);
	gtk_container_add(GTK_CONTAINER(file_system_submenu_menu), mkfs_menu_item);

	fsck_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(fsck_menu_item)->child),
					_("_Check/Repair..."));
	gtk_widget_add_accelerator(fsck_menu_item, "activate_item", file_system_submenu_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(fsck_menu_item, "fsck_menu_item");
	gtk_widget_ref(fsck_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "fsck_menu_item", fsck_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(fsck_menu_item);
	gtk_container_add(GTK_CONTAINER(file_system_submenu_menu), fsck_menu_item);

	obliterate_filesystem_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(obliterate_filesystem_menu_item)->child),
					_("_Remove..."));
	gtk_widget_add_accelerator(obliterate_filesystem_menu_item, "activate_item",
				   file_system_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(obliterate_filesystem_menu_item, "obliterate_filesystem_menu_item");
	gtk_widget_ref(obliterate_filesystem_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "obliterate_filesystem_menu_item",
				 obliterate_filesystem_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(obliterate_filesystem_menu_item);
	gtk_container_add(GTK_CONTAINER(file_system_submenu_menu), obliterate_filesystem_menu_item);

	mount_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(mount_menu_item)->child), _("M_ount..."));
	gtk_widget_add_accelerator(mount_menu_item, "activate_item",
				   file_system_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(mount_menu_item, "mount_menu_item");
	gtk_widget_ref(mount_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "mount_menu_item", mount_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(mount_menu_item);
	gtk_container_add(GTK_CONTAINER(file_system_submenu_menu), mount_menu_item);

	unmount_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(unmount_menu_item)->child),
					_("_Unmount..."));
	gtk_widget_add_accelerator(unmount_menu_item, "activate_item",
				   file_system_submenu_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(unmount_menu_item, "unmount_menu_item");
	gtk_widget_ref(unmount_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "unmount_menu_item", unmount_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(unmount_menu_item);
	gtk_container_add(GTK_CONTAINER(file_system_submenu_menu), unmount_menu_item);

	separator3 = gtk_menu_item_new();
	gtk_widget_set_name(separator3, "separator3");
	gtk_widget_ref(separator3);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "separator3", separator3,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(separator3);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), separator3);
	gtk_widget_set_sensitive(separator3, FALSE);

	commit_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(commit_menu_item)->child), _("_Save..."));
	gtk_widget_add_accelerator(commit_menu_item, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(commit_menu_item, "commit_menu_item");
	gtk_widget_ref(commit_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "commit_menu_item", commit_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(commit_menu_item);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), commit_menu_item);
	gtk_widget_add_accelerator(commit_menu_item, "activate", accel_group,
				   GDK_S, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	backup_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(backup_menu_item)->child), _("_Backup..."));
	gtk_widget_add_accelerator(backup_menu_item, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(backup_menu_item, "backup_menu_item");
	gtk_widget_ref(backup_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "backup_menu_item", backup_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(backup_menu_item);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), backup_menu_item);

	separator1 = gtk_menu_item_new();
	gtk_widget_set_name(separator1, "separator1");
	gtk_widget_ref(separator1);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "separator1", separator1,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(separator1);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), separator1);
	gtk_widget_set_sensitive(separator1, FALSE);

	exit_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(exit_menu_item)->child), _("_Quit"));
	gtk_widget_add_accelerator(exit_menu_item, "activate_item", actions_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(exit_menu_item, "exit_menu_item");
	gtk_widget_ref(exit_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "exit_menu_item", exit_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(exit_menu_item);
	gtk_container_add(GTK_CONTAINER(actions_menu_item_menu), exit_menu_item);
	gtk_widget_add_accelerator(exit_menu_item, "activate", accel_group,
				   GDK_Q, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	evmsgui_settings = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(evmsgui_settings)->child),
					_("_Settings"));
	gtk_widget_add_accelerator(evmsgui_settings, "activate_item", accel_group,
				   tmp_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	gtk_widget_set_name(evmsgui_settings, "evmsgui_settings");
	gtk_widget_ref(evmsgui_settings);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "evmsgui_settings", evmsgui_settings,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(evmsgui_settings);
	gtk_container_add(GTK_CONTAINER(main_menubar), evmsgui_settings);

	evmsgui_settings_menu = gtk_menu_new();
	gtk_widget_set_name(evmsgui_settings_menu, "evmsgui_settings_menu");
	gtk_widget_ref(evmsgui_settings_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "evmsgui_settings_menu",
				 evmsgui_settings_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(evmsgui_settings), evmsgui_settings_menu);
	evmsgui_settings_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(evmsgui_settings_menu));

	set_log_level_submenu = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(set_log_level_submenu)->child),
					_("_Log Level"));
	gtk_widget_add_accelerator(set_log_level_submenu, "activate_item",
				   evmsgui_settings_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(set_log_level_submenu, "set_log_level_submenu");
	gtk_widget_ref(set_log_level_submenu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "set_log_level_submenu",
				 set_log_level_submenu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(set_log_level_submenu);
	gtk_container_add(GTK_CONTAINER(evmsgui_settings_menu), set_log_level_submenu);

	admin_node_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(admin_node_menu_item)->child),
					_("_Node Administered..."));
	gtk_widget_add_accelerator(admin_node_menu_item, "activate_item",
				   evmsgui_settings_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(admin_node_menu_item, "admin_node_menu_item");
	gtk_widget_ref(admin_node_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "admin_node_menu_item",
				 admin_node_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(admin_node_menu_item);
	gtk_container_add(GTK_CONTAINER(evmsgui_settings_menu), admin_node_menu_item);
	if (get_number_of_nodes() <= 1) {
		gtk_widget_set_sensitive(admin_node_menu_item, FALSE);
	}

	set_log_level_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(set_log_level_submenu_menu, "set_log_level_submenu_menu");
	gtk_widget_ref(set_log_level_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "set_log_level_submenu_menu",
				 set_log_level_submenu_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(set_log_level_submenu), set_log_level_submenu_menu);
	set_log_level_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(set_log_level_submenu_menu));

/*
  engine_log_level_submenu = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (engine_log_level_submenu)->child),
                                   _("_Engine"));
  gtk_widget_add_accelerator (engine_log_level_submenu, "activate_item", set_log_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  gtk_widget_set_name (engine_log_level_submenu, "engine_log_level_submenu");
  gtk_widget_ref (engine_log_level_submenu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "engine_log_level_submenu", engine_log_level_submenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (engine_log_level_submenu);
  gtk_container_add (GTK_CONTAINER (set_log_level_submenu_menu), engine_log_level_submenu);
*/
	engine_log_level_submenu_menu = gtk_menu_new();
	gtk_widget_set_name(engine_log_level_submenu_menu, "engine_log_level_submenu_menu");
	gtk_widget_ref(engine_log_level_submenu_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "engine_log_level_submenu_menu",
				 engine_log_level_submenu_menu,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(set_log_level_submenu),
				  engine_log_level_submenu_menu);
	engine_log_level_submenu_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(engine_log_level_submenu_menu));

	critical_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(critical_engine_level_menuitem)->child),
				  _("_Critical (Least Information)"));
	gtk_widget_add_accelerator(critical_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(critical_engine_level_menuitem));
	gtk_widget_set_name(critical_engine_level_menuitem, "critical_engine_level_menuitem");
	gtk_widget_ref(critical_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "critical_engine_level_menuitem",
				 critical_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(critical_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  critical_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(critical_engine_level_menuitem),
					    TRUE);

	serious_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(serious_engine_level_menuitem)->child),
				  _("_Serious"));
	gtk_widget_add_accelerator(serious_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(serious_engine_level_menuitem));
	gtk_widget_set_name(serious_engine_level_menuitem, "serious_engine_level_menuitem");
	gtk_widget_ref(serious_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "serious_engine_level_menuitem",
				 serious_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(serious_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  serious_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(serious_engine_level_menuitem),
					    TRUE);

	error_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(error_engine_level_menuitem)->child),
				  _("_Error"));
	gtk_widget_add_accelerator(error_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(error_engine_level_menuitem));
	gtk_widget_set_name(error_engine_level_menuitem, "error_engine_level_menuitem");
	gtk_widget_ref(error_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "error_engine_level_menuitem",
				 error_engine_level_menuitem, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(error_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  error_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(error_engine_level_menuitem), TRUE);

	warning_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(warning_engine_level_menuitem)->child),
				  _("_Warning"));
	gtk_widget_add_accelerator(warning_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(warning_engine_level_menuitem));
	gtk_widget_set_name(warning_engine_level_menuitem, "warning_engine_level_menuitem");
	gtk_widget_ref(warning_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "warning_engine_level_menuitem",
				 warning_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(warning_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  warning_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(warning_engine_level_menuitem),
					    TRUE);

	default_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(default_engine_level_menuitem)->child),
				  _("_Default"));
	gtk_widget_add_accelerator(default_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(default_engine_level_menuitem));
	gtk_widget_set_name(default_engine_level_menuitem, "default_engine_level_menuitem");
	gtk_widget_ref(default_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "default_engine_level_menuitem",
				 default_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(default_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  default_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(default_engine_level_menuitem),
					    TRUE);

	details_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(details_engine_level_menuitem)->child),
				  _("De_tails"));
	gtk_widget_add_accelerator(details_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(details_engine_level_menuitem));
	gtk_widget_set_name(details_engine_level_menuitem, "details_engine_level_menuitem");
	gtk_widget_ref(details_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "details_engine_level_menuitem",
				 details_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(details_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  details_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(details_engine_level_menuitem),
					    TRUE);

	entry_exit_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(entry_exit_engine_level_menuitem)->child),
				  _("E_ntry/Exit"));
	gtk_widget_add_accelerator(entry_exit_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(entry_exit_engine_level_menuitem));
	gtk_widget_set_name(entry_exit_engine_level_menuitem, "entry_exit_engine_level_menuitem");
	gtk_widget_ref(entry_exit_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "entry_exit_engine_level_menuitem",
				 entry_exit_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(entry_exit_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  entry_exit_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(entry_exit_engine_level_menuitem),
					    TRUE);

	debug_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(debug_engine_level_menuitem)->child),
				  _("De_bug"));
	gtk_widget_add_accelerator(debug_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(debug_engine_level_menuitem));
	gtk_widget_set_name(debug_engine_level_menuitem, "debug_engine_level_menuitem");
	gtk_widget_ref(debug_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "debug_engine_level_menuitem",
				 debug_engine_level_menuitem, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(debug_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  debug_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(debug_engine_level_menuitem), TRUE);

	extra_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(extra_engine_level_menuitem)->child),
				  _("E_xtra"));
	gtk_widget_add_accelerator(extra_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(extra_engine_level_menuitem));
	gtk_widget_set_name(extra_engine_level_menuitem, "extra_engine_level_menuitem");
	gtk_widget_ref(extra_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "extra_engine_level_menuitem",
				 extra_engine_level_menuitem, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(extra_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  extra_engine_level_menuitem);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(extra_engine_level_menuitem), TRUE);

	everything_engine_level_menuitem =
	    gtk_radio_menu_item_new_with_label(engine_debug_levels_group, "");
	tmp_key =
	    gtk_label_parse_uline(GTK_LABEL(GTK_BIN(everything_engine_level_menuitem)->child),
				  _("E_verything (Most Information)"));
	gtk_widget_add_accelerator(everything_engine_level_menuitem, "activate_item",
				   engine_log_level_submenu_menu_accels, tmp_key, 0, 0);
	engine_debug_levels_group =
	    gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(everything_engine_level_menuitem));
	gtk_widget_set_name(everything_engine_level_menuitem, "everything_engine_level_menuitem");
	gtk_widget_ref(everything_engine_level_menuitem);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "everything_engine_level_menuitem",
				 everything_engine_level_menuitem,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(everything_engine_level_menuitem);
	gtk_container_add(GTK_CONTAINER(engine_log_level_submenu_menu),
			  everything_engine_level_menuitem);
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(everything_engine_level_menuitem), TRUE);
	gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(everything_engine_level_menuitem),
					    TRUE);

/*
  kernel_info_level_submenu = gtk_menu_item_new_with_label ("");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (kernel_info_level_submenu)->child),
                                   _("_Kernel"));
  gtk_widget_add_accelerator (kernel_info_level_submenu, "activate_item", set_log_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  gtk_widget_set_name (kernel_info_level_submenu, "kernel_info_level_submenu");
  gtk_widget_ref (kernel_info_level_submenu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "kernel_info_level_submenu", kernel_info_level_submenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (kernel_info_level_submenu);
  gtk_container_add (GTK_CONTAINER (set_log_level_submenu_menu), kernel_info_level_submenu);

  kernel_info_level_submenu_menu = gtk_menu_new ();
  gtk_widget_set_name (kernel_info_level_submenu_menu, "kernel_info_level_submenu_menu");
  gtk_widget_ref (kernel_info_level_submenu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "kernel_info_level_submenu_menu", kernel_info_level_submenu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (kernel_info_level_submenu), kernel_info_level_submenu_menu);
  kernel_info_level_submenu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (kernel_info_level_submenu_menu));

  critical_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (critical_kernel_level_menuitem)->child),
                                   _("_Critical (Least Information)"));
  gtk_widget_add_accelerator (critical_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (critical_kernel_level_menuitem));
  gtk_widget_set_name (critical_kernel_level_menuitem, "critical_kernel_level_menuitem");
  gtk_widget_ref (critical_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "critical_kernel_level_menuitem", critical_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (critical_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), critical_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (critical_kernel_level_menuitem), TRUE);

  serious_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (serious_kernel_level_menuitem)->child),
                                   _("_Serious"));
  gtk_widget_add_accelerator (serious_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (serious_kernel_level_menuitem));
  gtk_widget_set_name (serious_kernel_level_menuitem, "serious_kernel_level_menuitem");
  gtk_widget_ref (serious_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "serious_kernel_level_menuitem", serious_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (serious_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), serious_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (serious_kernel_level_menuitem), TRUE);

  error_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (error_kernel_level_menuitem)->child),
                                   _("_Error"));
  gtk_widget_add_accelerator (error_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (error_kernel_level_menuitem));
  gtk_widget_set_name (error_kernel_level_menuitem, "error_kernel_level_menuitem");
  gtk_widget_ref (error_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "error_kernel_level_menuitem", error_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (error_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), error_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (error_kernel_level_menuitem), TRUE);

  warning_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (warning_kernel_level_menuitem)->child),
                                   _("_Warning"));
  gtk_widget_add_accelerator (warning_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (warning_kernel_level_menuitem));
  gtk_widget_set_name (warning_kernel_level_menuitem, "warning_kernel_level_menuitem");
  gtk_widget_ref (warning_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "warning_kernel_level_menuitem", warning_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (warning_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), warning_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (warning_kernel_level_menuitem), TRUE);

  default_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (default_kernel_level_menuitem)->child),
                                   _("_Default"));
  gtk_widget_add_accelerator (default_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (default_kernel_level_menuitem));
  gtk_widget_set_name (default_kernel_level_menuitem, "default_kernel_level_menuitem");
  gtk_widget_ref (default_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "default_kernel_level_menuitem", default_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (default_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), default_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (default_kernel_level_menuitem), TRUE);

  details_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (details_kernel_level_menuitem)->child),
                                   _("De_tails"));
  gtk_widget_add_accelerator (details_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (details_kernel_level_menuitem));
  gtk_widget_set_name (details_kernel_level_menuitem, "details_kernel_level_menuitem");
  gtk_widget_ref (details_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "details_kernel_level_menuitem", details_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), details_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (details_kernel_level_menuitem), TRUE);

  debug_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (debug_kernel_level_menuitem)->child),
                                   _("De_bug"));
  gtk_widget_add_accelerator (debug_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (debug_kernel_level_menuitem));
  gtk_widget_set_name (debug_kernel_level_menuitem, "debug_kernel_level_menuitem");
  gtk_widget_ref (debug_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "debug_kernel_level_menuitem", debug_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (debug_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), debug_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (debug_kernel_level_menuitem), TRUE);

  extra_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (extra_kernel_level_menuitem)->child),
                                   _("E_xtra"));
  gtk_widget_add_accelerator (extra_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (extra_kernel_level_menuitem));
  gtk_widget_set_name (extra_kernel_level_menuitem, "extra_kernel_level_menuitem");
  gtk_widget_ref (extra_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "extra_kernel_level_menuitem", extra_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (extra_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), extra_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (extra_kernel_level_menuitem), TRUE);

  entry_exit_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (entry_exit_kernel_level_menuitem)->child),
                                   _("E_ntry/Exit"));
  gtk_widget_add_accelerator (entry_exit_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (entry_exit_kernel_level_menuitem));
  gtk_widget_set_name (entry_exit_kernel_level_menuitem, "entry_exit_kernel_level_menuitem");
  gtk_widget_ref (entry_exit_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "entry_exit_kernel_level_menuitem", entry_exit_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_exit_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), entry_exit_kernel_level_menuitem);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (entry_exit_kernel_level_menuitem), TRUE);

  everything_kernel_level_menuitem = gtk_radio_menu_item_new_with_label (kernel_debug_levels_group, "");
  tmp_key = gtk_label_parse_uline (GTK_LABEL (GTK_BIN (everything_kernel_level_menuitem)->child),
                                   _("E_verything (Most Information)"));
  gtk_widget_add_accelerator (everything_kernel_level_menuitem, "activate_item", kernel_info_level_submenu_menu_accels,
                              tmp_key, 0, 0);
  kernel_debug_levels_group = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (everything_kernel_level_menuitem));
  gtk_widget_set_name (everything_kernel_level_menuitem, "everything_kernel_level_menuitem");
  gtk_widget_ref (everything_kernel_level_menuitem);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "everything_kernel_level_menuitem", everything_kernel_level_menuitem,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (everything_kernel_level_menuitem);
  gtk_container_add (GTK_CONTAINER (kernel_info_level_submenu_menu), everything_kernel_level_menuitem);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (everything_kernel_level_menuitem), TRUE);
  gtk_check_menu_item_set_show_toggle (GTK_CHECK_MENU_ITEM (everything_kernel_level_menuitem), TRUE);
*/
	help_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(help_menu_item)->child), _("_Help"));
	gtk_widget_add_accelerator(help_menu_item, "activate_item", accel_group,
				   tmp_key, GDK_MOD1_MASK, (GtkAccelFlags) 0);
	gtk_widget_set_name(help_menu_item, "help_menu_item");
	gtk_widget_ref(help_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "help_menu_item", help_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(help_menu_item);
	gtk_container_add(GTK_CONTAINER(main_menubar), help_menu_item);

	help_menu_item_menu = gtk_menu_new();
	gtk_widget_set_name(help_menu_item_menu, "help_menu_item_menu");
	gtk_widget_ref(help_menu_item_menu);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "help_menu_item_menu",
				 help_menu_item_menu, (GtkDestroyNotify) gtk_widget_unref);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(help_menu_item), help_menu_item_menu);
	help_menu_item_menu_accels =
	    gtk_menu_ensure_uline_accel_group(GTK_MENU(help_menu_item_menu));

	web_links_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(web_links_menu_item)->child),
					_("_Web links"));
	gtk_widget_add_accelerator(web_links_menu_item, "activate_item",
				   help_menu_item_menu_accels, tmp_key, 0, 0);
	gtk_widget_set_name(web_links_menu_item, "web_links_menu_item");
	gtk_widget_ref(web_links_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "web_links_menu_item",
				 web_links_menu_item, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(web_links_menu_item);
	gtk_container_add(GTK_CONTAINER(help_menu_item_menu), web_links_menu_item);

	help_separator = gtk_menu_item_new();
	gtk_widget_set_name(help_separator, "help_separator");
	gtk_widget_ref(help_separator);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "help_separator", help_separator,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(help_separator);
	gtk_container_add(GTK_CONTAINER(help_menu_item_menu), help_separator);
	gtk_widget_set_sensitive(help_separator, FALSE);

	about_menu_item = gtk_menu_item_new_with_label("");
	tmp_key = gtk_label_parse_uline(GTK_LABEL(GTK_BIN(about_menu_item)->child), _("_About"));
	gtk_widget_add_accelerator(about_menu_item, "activate_item", help_menu_item_menu_accels,
				   tmp_key, 0, 0);
	gtk_widget_set_name(about_menu_item, "about_menu_item");
	gtk_widget_ref(about_menu_item);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "about_menu_item", about_menu_item,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(about_menu_item);
	gtk_container_add(GTK_CONTAINER(help_menu_item_menu), about_menu_item);

	toolbar_handlebox = gtk_handle_box_new();
	gtk_widget_set_name(toolbar_handlebox, "toolbar_handlebox");
	gtk_widget_ref(toolbar_handlebox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "toolbar_handlebox", toolbar_handlebox,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(toolbar_handlebox);
	gtk_box_pack_start(GTK_BOX(main_window_vbox), toolbar_handlebox, FALSE, FALSE, 0);

	icon_button_toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_widget_set_name(icon_button_toolbar, "icon_button_toolbar");
	gtk_widget_ref(icon_button_toolbar);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "icon_button_toolbar",
				 icon_button_toolbar, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(icon_button_toolbar);
	gtk_container_add(GTK_CONTAINER(toolbar_handlebox), icon_button_toolbar);
	gtk_container_set_border_width(GTK_CONTAINER(icon_button_toolbar), 5);
	gtk_toolbar_set_space_size(GTK_TOOLBAR(icon_button_toolbar), 8);
	gtk_toolbar_set_button_relief(GTK_TOOLBAR(icon_button_toolbar), GTK_RELIEF_NONE);

	tmp_toolbar_icon = create_pixmap(main_window, "commit.xpm");
	toolbar_commit_button = gtk_toolbar_append_element(GTK_TOOLBAR(icon_button_toolbar),
							   GTK_TOOLBAR_CHILD_BUTTON,
							   NULL,
							   _("Save"),
							   _("Save all changes to disk"), NULL,
							   tmp_toolbar_icon, NULL, NULL);
	gtk_widget_set_name(toolbar_commit_button, "toolbar_commit_button");
	gtk_widget_ref(toolbar_commit_button);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "toolbar_commit_button",
				 toolbar_commit_button, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(toolbar_commit_button);

	tmp_toolbar_icon = create_pixmap(main_window, "refresh.xpm");
	refresh_button = gtk_toolbar_append_element(GTK_TOOLBAR(icon_button_toolbar),
						    GTK_TOOLBAR_CHILD_BUTTON,
						    NULL,
						    _("Refresh"),
						    _("Refresh the contents of all the views"),
						    NULL, tmp_toolbar_icon, NULL, NULL);
	gtk_widget_set_name(refresh_button, "refresh_button");
	gtk_widget_ref(refresh_button);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "refresh_button", refresh_button,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(refresh_button);

	tmp_toolbar_icon = create_pixmap(main_window, "exit.xpm");
	exit_button = gtk_toolbar_append_element(GTK_TOOLBAR(icon_button_toolbar),
						 GTK_TOOLBAR_CHILD_BUTTON,
						 NULL,
						 _("Quit"),
						 _("Quit this application"), NULL,
						 tmp_toolbar_icon, NULL, NULL);
	gtk_widget_set_name(exit_button, "exit_button");
	gtk_widget_ref(exit_button);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "exit_button", exit_button,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(exit_button);

	browser_notebook = gtk_notebook_new();
	gtk_widget_set_name(browser_notebook, "browser_notebook");
	gtk_widget_ref(browser_notebook);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "browser_notebook", browser_notebook,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(browser_notebook);
	gtk_box_pack_start(GTK_BOX(main_window_vbox), browser_notebook, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(browser_notebook), 7);

	view_volumes_tree_frame = gtk_frame_new(_("Logical Volumes"));
	gtk_widget_set_name(view_volumes_tree_frame, "view_volumes_tree_frame");
	gtk_widget_ref(view_volumes_tree_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_tree_frame",
				 view_volumes_tree_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_tree_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_volumes_tree_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_volumes_tree_frame), 3);

	view_volumes_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_volumes_scrolledwindow, "view_volumes_scrolledwindow");
	gtk_widget_ref(view_volumes_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_scrolledwindow",
				 view_volumes_scrolledwindow, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_volumes_tree_frame), view_volumes_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_volumes_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_volumes_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_volumes_ctree = gtk_ctree_new(7, 0);
	gtk_widget_set_name(view_volumes_ctree, "view_volumes_ctree");
	gtk_widget_ref(view_volumes_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_ctree", view_volumes_ctree,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_ctree);
	gtk_container_add(GTK_CONTAINER(view_volumes_scrolledwindow), view_volumes_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 5, 102);
	gtk_clist_set_column_width(GTK_CLIST(view_volumes_ctree), 6, 102);
	gtk_clist_column_titles_show(GTK_CLIST(view_volumes_ctree));

	view_volumes_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_volumes_tree_ctree_label, "view_volumes_tree_ctree_label");
	gtk_widget_ref(view_volumes_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_tree_ctree_label",
				 view_volumes_tree_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 0,
				    view_volumes_tree_ctree_label);

	view_volumes_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_volumes_size_ctree_label, "view_volumes_size_ctree_label");
	gtk_widget_ref(view_volumes_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_size_ctree_label",
				 view_volumes_size_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 1,
				    view_volumes_size_ctree_label);

	view_volumes_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_volumes_modified_ctree_label, "view_volumes_modified_ctree_label");
	gtk_widget_ref(view_volumes_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_modified_ctree_label",
				 view_volumes_modified_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 2,
				    view_volumes_modified_ctree_label);

	_ = gtk_label_new(_("Active"));
	gtk_widget_set_name(_, "_");
	gtk_widget_ref(_);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "_", _,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(_);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 3, _);

	view_volumes_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_volumes_ro_ctree_label, "view_volumes_ro_ctree_label");
	gtk_widget_ref(view_volumes_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_ro_ctree_label",
				 view_volumes_ro_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 4, view_volumes_ro_ctree_label);

	view_volumes_plugin_ctree_label = gtk_label_new(_("Plugin"));
	gtk_widget_set_name(view_volumes_plugin_ctree_label, "view_volumes_plugin_ctree_label");
	gtk_widget_ref(view_volumes_plugin_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_plugin_ctree_label",
				 view_volumes_plugin_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_plugin_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 5,
				    view_volumes_plugin_ctree_label);

	view_volumes_mp_ctree_label = gtk_label_new(_("Mount Point"));
	gtk_widget_set_name(view_volumes_mp_ctree_label, "view_volumes_mp_ctree_label");
	gtk_widget_ref(view_volumes_mp_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_volumes_mp_ctree_label",
				 view_volumes_mp_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_volumes_mp_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_volumes_ctree), 6, view_volumes_mp_ctree_label);

	volumes_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(volumes_view_tab_hbox, "volumes_view_tab_hbox");
	gtk_widget_ref(volumes_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "volumes_view_tab_hbox",
				 volumes_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(volumes_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 0),
				   volumes_view_tab_hbox);

	volumes_view_tab_label = gtk_label_new(_("Volumes"));
	gtk_widget_set_name(volumes_view_tab_label, "volumes_view_tab_label");
	gtk_widget_ref(volumes_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "volumes_view_tab_label",
				 volumes_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(volumes_view_tab_label);
	gtk_box_pack_end(GTK_BOX(volumes_view_tab_hbox), volumes_view_tab_label, FALSE, FALSE, 0);

	view_objects_frame = gtk_frame_new(_("Available Topmost Storage Objects"));
	gtk_widget_set_name(view_objects_frame, "view_objects_frame");
	gtk_widget_ref(view_objects_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_frame", view_objects_frame,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_objects_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_objects_frame), 3);

	view_objects_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_objects_scrolledwindow, "view_objects_scrolledwindow");
	gtk_widget_ref(view_objects_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_scrolledwindow",
				 view_objects_scrolledwindow, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_objects_frame), view_objects_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_objects_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_objects_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_objects_ctree = gtk_ctree_new(6, 0);
	gtk_widget_set_name(view_objects_ctree, "view_objects_ctree");
	gtk_widget_ref(view_objects_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_ctree", view_objects_ctree,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_ctree);
	gtk_container_add(GTK_CONTAINER(view_objects_scrolledwindow), view_objects_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_objects_ctree), 5, 102);
	gtk_clist_column_titles_show(GTK_CLIST(view_objects_ctree));

	view_objects_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_objects_tree_ctree_label, "view_objects_tree_ctree_label");
	gtk_widget_ref(view_objects_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_tree_ctree_label",
				 view_objects_tree_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 0,
				    view_objects_tree_ctree_label);

	view_objects_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_objects_size_ctree_label, "view_objects_size_ctree_label");
	gtk_widget_ref(view_objects_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_size_ctree_label",
				 view_objects_size_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 1,
				    view_objects_size_ctree_label);

	view_objects_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_objects_modified_ctree_label, "view_objects_modified_ctree_label");
	gtk_widget_ref(view_objects_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_modified_ctree_label",
				 view_objects_modified_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 2,
				    view_objects_modified_ctree_label);

	view_objects_active_ctree_label = gtk_label_new(_("Active"));
	gtk_widget_set_name(view_objects_active_ctree_label, "view_objects_active_ctree_label");
	gtk_widget_ref(view_objects_active_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_active_ctree_label",
				 view_objects_active_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_active_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 3,
				    view_objects_active_ctree_label);

	view_objects_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_objects_ro_ctree_label, "view_objects_ro_ctree_label");
	gtk_widget_ref(view_objects_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_ro_ctree_label",
				 view_objects_ro_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 4, view_objects_ro_ctree_label);

	view_objects_plugin_ctree_label = gtk_label_new(_("Plugin"));
	gtk_widget_set_name(view_objects_plugin_ctree_label, "view_objects_plugin_ctree_label");
	gtk_widget_ref(view_objects_plugin_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_objects_plugin_ctree_label",
				 view_objects_plugin_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_objects_plugin_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_objects_ctree), 5,
				    view_objects_plugin_ctree_label);

	topmost_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(topmost_view_tab_hbox, "topmost_view_tab_hbox");
	gtk_widget_ref(topmost_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "topmost_view_tab_hbox",
				 topmost_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(topmost_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 1),
				   topmost_view_tab_hbox);

	topmost_view_tab_label = gtk_label_new(_("Available Objects"));
	gtk_widget_set_name(topmost_view_tab_label, "topmost_view_tab_label");
	gtk_widget_ref(topmost_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "topmost_view_tab_label",
				 topmost_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(topmost_view_tab_label);
	gtk_box_pack_end(GTK_BOX(topmost_view_tab_hbox), topmost_view_tab_label, FALSE, FALSE, 0);

	view_feature_objects_frame = gtk_frame_new(_("Feature Objects"));
	gtk_widget_set_name(view_feature_objects_frame, "view_feature_objects_frame");
	gtk_widget_ref(view_feature_objects_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_feature_objects_frame",
				 view_feature_objects_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_feature_objects_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_feature_objects_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_feature_objects_frame), 3);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(scrolledwindow1, "scrolledwindow1");
	gtk_widget_ref(scrolledwindow1);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "scrolledwindow1", scrolledwindow1,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(scrolledwindow1);
	gtk_container_add(GTK_CONTAINER(view_feature_objects_frame), scrolledwindow1);
	gtk_container_set_border_width(GTK_CONTAINER(scrolledwindow1), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow1), GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);

	ctree1 = gtk_ctree_new(6, 0);
	gtk_widget_set_name(ctree1, "ctree1");
	gtk_widget_ref(ctree1);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "ctree1", ctree1,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(ctree1);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), ctree1);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(ctree1), 5, 102);
	gtk_clist_column_titles_show(GTK_CLIST(ctree1));

	label2 = gtk_label_new("");
	gtk_widget_set_name(label2, "label2");
	gtk_widget_ref(label2);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label2", label2,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label2);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 0, label2);

	label3 = gtk_label_new(_("Size"));
	gtk_widget_set_name(label3, "label3");
	gtk_widget_ref(label3);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label3", label3,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label3);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 1, label3);

	label4 = gtk_label_new(_("Modified"));
	gtk_widget_set_name(label4, "label4");
	gtk_widget_ref(label4);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label4", label4,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label4);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 2, label4);

	label7 = gtk_label_new(_("Active"));
	gtk_widget_set_name(label7, "label7");
	gtk_widget_ref(label7);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label7", label7,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label7);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 3, label7);

	label9 = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(label9, "label9");
	gtk_widget_ref(label9);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label9", label9,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label9);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 4, label9);

	label5 = gtk_label_new(_("Plugin"));
	gtk_widget_set_name(label5, "label5");
	gtk_widget_ref(label5);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "label5", label5,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(label5);
	gtk_clist_set_column_widget(GTK_CLIST(ctree1), 5, label5);

	feature_objects_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(feature_objects_view_tab_hbox, "feature_objects_view_tab_hbox");
	gtk_widget_ref(feature_objects_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "feature_objects_view_tab_hbox",
				 feature_objects_view_tab_hbox,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(feature_objects_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 2),
				   feature_objects_view_tab_hbox);

	feature_objects_view_tab_label = gtk_label_new(_("Feature Objects"));
	gtk_widget_set_name(feature_objects_view_tab_label, "feature_objects_view_tab_label");
	gtk_widget_ref(feature_objects_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "feature_objects_view_tab_label",
				 feature_objects_view_tab_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(feature_objects_view_tab_label);
	gtk_box_pack_end(GTK_BOX(feature_objects_view_tab_hbox), feature_objects_view_tab_label,
			 FALSE, FALSE, 0);

	view_regions_tree_frame = gtk_frame_new(_("Storage Regions"));
	gtk_widget_set_name(view_regions_tree_frame, "view_regions_tree_frame");
	gtk_widget_ref(view_regions_tree_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_tree_frame",
				 view_regions_tree_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_tree_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_regions_tree_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_regions_tree_frame), 3);

	view_regions_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_regions_scrolledwindow, "view_regions_scrolledwindow");
	gtk_widget_ref(view_regions_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_scrolledwindow",
				 view_regions_scrolledwindow, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_regions_tree_frame), view_regions_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_regions_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_regions_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_regions_ctree = gtk_ctree_new(6, 0);
	gtk_widget_set_name(view_regions_ctree, "view_regions_ctree");
	gtk_widget_ref(view_regions_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_ctree", view_regions_ctree,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_ctree);
	gtk_container_add(GTK_CONTAINER(view_regions_scrolledwindow), view_regions_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_regions_ctree), 5, 80);
	gtk_clist_column_titles_show(GTK_CLIST(view_regions_ctree));

	view_regions_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_regions_tree_ctree_label, "view_regions_tree_ctree_label");
	gtk_widget_ref(view_regions_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_tree_ctree_label",
				 view_regions_tree_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 0,
				    view_regions_tree_ctree_label);

	view_regions_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_regions_size_ctree_label, "view_regions_size_ctree_label");
	gtk_widget_ref(view_regions_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_size_ctree_label",
				 view_regions_size_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 1,
				    view_regions_size_ctree_label);

	view_regions_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_regions_modified_ctree_label, "view_regions_modified_ctree_label");
	gtk_widget_ref(view_regions_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_modified_ctree_label",
				 view_regions_modified_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 2,
				    view_regions_modified_ctree_label);

	view_regions_active_ctree_label = gtk_label_new(_("Active"));
	gtk_widget_set_name(view_regions_active_ctree_label, "view_regions_active_ctree_label");
	gtk_widget_ref(view_regions_active_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_active_ctree_label",
				 view_regions_active_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_active_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 3,
				    view_regions_active_ctree_label);

	view_regions_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_regions_ro_ctree_label, "view_regions_ro_ctree_label");
	gtk_widget_ref(view_regions_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_ro_ctree_label",
				 view_regions_ro_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 4, view_regions_ro_ctree_label);

	view_regions_corrupt_ctree_label = gtk_label_new(_("Corrupt"));
	gtk_widget_set_name(view_regions_corrupt_ctree_label, "view_regions_corrupt_ctree_label");
	gtk_widget_ref(view_regions_corrupt_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_regions_corrupt_ctree_label",
				 view_regions_corrupt_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_regions_corrupt_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_regions_ctree), 5,
				    view_regions_corrupt_ctree_label);

	regions_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(regions_view_tab_hbox, "regions_view_tab_hbox");
	gtk_widget_ref(regions_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "regions_view_tab_hbox",
				 regions_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(regions_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 3),
				   regions_view_tab_hbox);

	regions_view_tab_label = gtk_label_new(_("Regions"));
	gtk_widget_set_name(regions_view_tab_label, "regions_view_tab_label");
	gtk_widget_ref(regions_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "regions_view_tab_label",
				 regions_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(regions_view_tab_label);
	gtk_box_pack_end(GTK_BOX(regions_view_tab_hbox), regions_view_tab_label, FALSE, FALSE, 0);

	view_containers_tree_frame = gtk_frame_new(_("Storage Containers"));
	gtk_widget_set_name(view_containers_tree_frame, "view_containers_tree_frame");
	gtk_widget_ref(view_containers_tree_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_tree_frame",
				 view_containers_tree_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_tree_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_containers_tree_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_containers_tree_frame), 3);

	view_containers_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_containers_scrolledwindow, "view_containers_scrolledwindow");
	gtk_widget_ref(view_containers_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_scrolledwindow",
				 view_containers_scrolledwindow,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_containers_tree_frame),
			  view_containers_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_containers_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_containers_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_containers_ctree = gtk_ctree_new(5, 0);
	gtk_widget_set_name(view_containers_ctree, "view_containers_ctree");
	gtk_widget_ref(view_containers_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_ctree",
				 view_containers_ctree, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_ctree);
	gtk_container_add(GTK_CONTAINER(view_containers_scrolledwindow), view_containers_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_containers_ctree), 0, 193);
	gtk_clist_set_column_width(GTK_CLIST(view_containers_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_containers_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_containers_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_containers_ctree), 4, 80);
	gtk_clist_column_titles_show(GTK_CLIST(view_containers_ctree));

	view_containers_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_containers_tree_ctree_label, "view_containers_tree_ctree_label");
	gtk_widget_ref(view_containers_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_tree_ctree_label",
				 view_containers_tree_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_containers_ctree), 0,
				    view_containers_tree_ctree_label);

	view_containers_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_containers_size_ctree_label, "view_containers_size_ctree_label");
	gtk_widget_ref(view_containers_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_size_ctree_label",
				 view_containers_size_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_containers_ctree), 1,
				    view_containers_size_ctree_label);

	view_containers_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_containers_modified_ctree_label, "view_containers_modified_ctree_label");
	gtk_widget_ref(view_containers_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_modified_ctree_label",
				 view_containers_modified_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_containers_ctree), 2,
				    view_containers_modified_ctree_label);

	view_containers_active_ctree_label = gtk_label_new(_("Active"));
	gtk_widget_set_name(view_containers_active_ctree_label,
			    "view_containers_active_ctree_label");
	gtk_widget_ref(view_containers_active_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_active_ctree_label",
				 view_containers_active_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_active_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_containers_ctree), 3,
				    view_containers_active_ctree_label);

	view_containers_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_containers_ro_ctree_label, "view_containers_ro_ctree_label");
	gtk_widget_ref(view_containers_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_containers_ro_ctree_label",
				 view_containers_ro_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_containers_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_containers_ctree), 4,
				    view_containers_ro_ctree_label);

	containers_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(containers_view_tab_hbox, "containers_view_tab_hbox");
	gtk_widget_ref(containers_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "containers_view_tab_hbox",
				 containers_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(containers_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 4),
				   containers_view_tab_hbox);

	containers_view_tab_label = gtk_label_new(_("Containers"));
	gtk_widget_set_name(containers_view_tab_label, "containers_view_tab_label");
	gtk_widget_ref(containers_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "containers_view_tab_label",
				 containers_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(containers_view_tab_label);
	gtk_box_pack_end(GTK_BOX(containers_view_tab_hbox), containers_view_tab_label, FALSE, FALSE,
			 0);

	view_segments_tree_frame = gtk_frame_new(_("Disk Segments"));
	gtk_widget_set_name(view_segments_tree_frame, "view_segments_tree_frame");
	gtk_widget_ref(view_segments_tree_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_tree_frame",
				 view_segments_tree_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_tree_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_segments_tree_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_segments_tree_frame), 3);

	view_segments_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_segments_scrolledwindow, "view_segments_scrolledwindow");
	gtk_widget_ref(view_segments_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_scrolledwindow",
				 view_segments_scrolledwindow, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_segments_tree_frame), view_segments_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_segments_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_segments_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_segments_ctree = gtk_ctree_new(7, 0);
	gtk_widget_set_name(view_segments_ctree, "view_segments_ctree");
	gtk_widget_ref(view_segments_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_ctree",
				 view_segments_ctree, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_ctree);
	gtk_container_add(GTK_CONTAINER(view_segments_scrolledwindow), view_segments_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 5, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_segments_ctree), 6, 68);
	gtk_clist_column_titles_show(GTK_CLIST(view_segments_ctree));

	view_segments_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_segments_tree_ctree_label, "view_segments_tree_ctree_label");
	gtk_widget_ref(view_segments_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_tree_ctree_label",
				 view_segments_tree_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 0,
				    view_segments_tree_ctree_label);

	view_segments_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_segments_size_ctree_label, "view_segments_size_ctree_label");
	gtk_widget_ref(view_segments_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_size_ctree_label",
				 view_segments_size_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 1,
				    view_segments_size_ctree_label);

	view_segments_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_segments_modified_ctree_label, "view_segments_modified_ctree_label");
	gtk_widget_ref(view_segments_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_modified_ctree_label",
				 view_segments_modified_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 2,
				    view_segments_modified_ctree_label);

	view_segments_active_ctree_label = gtk_label_new(_("Active"));
	gtk_widget_set_name(view_segments_active_ctree_label, "view_segments_active_ctree_label");
	gtk_widget_ref(view_segments_active_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_active_ctree_label",
				 view_segments_active_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_active_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 3,
				    view_segments_active_ctree_label);

	view_segments_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_segments_ro_ctree_label, "view_segments_ro_ctree_label");
	gtk_widget_ref(view_segments_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_ro_ctree_label",
				 view_segments_ro_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 4,
				    view_segments_ro_ctree_label);

	view_segments_type_ctree_label = gtk_label_new(_("Type"));
	gtk_widget_set_name(view_segments_type_ctree_label, "view_segments_type_ctree_label");
	gtk_widget_ref(view_segments_type_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_type_ctree_label",
				 view_segments_type_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_type_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 5,
				    view_segments_type_ctree_label);

	view_segments_offset_ctree_label = gtk_label_new(_("Offset"));
	gtk_widget_set_name(view_segments_offset_ctree_label, "view_segments_offset_ctree_label");
	gtk_widget_ref(view_segments_offset_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_segments_offset_ctree_label",
				 view_segments_offset_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_segments_offset_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_segments_ctree), 6,
				    view_segments_offset_ctree_label);

	segments_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(segments_view_tab_hbox, "segments_view_tab_hbox");
	gtk_widget_ref(segments_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "segments_view_tab_hbox",
				 segments_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(segments_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 5),
				   segments_view_tab_hbox);

	segments_view_tab_label = gtk_label_new(_("Segments"));
	gtk_widget_set_name(segments_view_tab_label, "segments_view_tab_label");
	gtk_widget_ref(segments_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "segments_view_tab_label",
				 segments_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(segments_view_tab_label);
	gtk_box_pack_end(GTK_BOX(segments_view_tab_hbox), segments_view_tab_label, FALSE, FALSE, 0);

	view_disks_tree_frame = gtk_frame_new(_("Logical Disks"));
	gtk_widget_set_name(view_disks_tree_frame, "view_disks_tree_frame");
	gtk_widget_ref(view_disks_tree_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_tree_frame",
				 view_disks_tree_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_tree_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_disks_tree_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_disks_tree_frame), 3);

	view_disks_tree_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(view_disks_tree_scrolledwindow, "view_disks_tree_scrolledwindow");
	gtk_widget_ref(view_disks_tree_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_tree_scrolledwindow",
				 view_disks_tree_scrolledwindow,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_tree_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_disks_tree_frame), view_disks_tree_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(view_disks_tree_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(view_disks_tree_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	view_disks_ctree = gtk_ctree_new(6, 0);
	gtk_widget_set_name(view_disks_ctree, "view_disks_ctree");
	gtk_widget_ref(view_disks_ctree);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_ctree", view_disks_ctree,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_ctree);
	gtk_container_add(GTK_CONTAINER(view_disks_tree_scrolledwindow), view_disks_ctree);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 0, 175);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 1, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 2, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 3, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(view_disks_ctree), 5, 102);
	gtk_clist_column_titles_show(GTK_CLIST(view_disks_ctree));

	view_disks_tree_ctree_label = gtk_label_new("");
	gtk_widget_set_name(view_disks_tree_ctree_label, "view_disks_tree_ctree_label");
	gtk_widget_ref(view_disks_tree_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_tree_ctree_label",
				 view_disks_tree_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_tree_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 0, view_disks_tree_ctree_label);

	view_disks_size_ctree_label = gtk_label_new(_("Size"));
	gtk_widget_set_name(view_disks_size_ctree_label, "view_disks_size_ctree_label");
	gtk_widget_ref(view_disks_size_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_size_ctree_label",
				 view_disks_size_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_size_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 1, view_disks_size_ctree_label);

	view_disks_modified_ctree_label = gtk_label_new(_("Modified"));
	gtk_widget_set_name(view_disks_modified_ctree_label, "view_disks_modified_ctree_label");
	gtk_widget_ref(view_disks_modified_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_modified_ctree_label",
				 view_disks_modified_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_modified_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 2, view_disks_modified_ctree_label);

	view_disks_active_ctree_label = gtk_label_new(_("Active"));
	gtk_widget_set_name(view_disks_active_ctree_label, "view_disks_active_ctree_label");
	gtk_widget_ref(view_disks_active_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_active_ctree_label",
				 view_disks_active_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_active_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 3, view_disks_active_ctree_label);

	view_disks_ro_ctree_label = gtk_label_new(_("Read Only"));
	gtk_widget_set_name(view_disks_ro_ctree_label, "view_disks_ro_ctree_label");
	gtk_widget_ref(view_disks_ro_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_ro_ctree_label",
				 view_disks_ro_ctree_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_ro_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 4, view_disks_ro_ctree_label);

	view_disks_geometry_ctree_label = gtk_label_new(_("Geometry"));
	gtk_widget_set_name(view_disks_geometry_ctree_label, "view_disks_geometry_ctree_label");
	gtk_widget_ref(view_disks_geometry_ctree_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_disks_geometry_ctree_label",
				 view_disks_geometry_ctree_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_disks_geometry_ctree_label);
	gtk_clist_set_column_widget(GTK_CLIST(view_disks_ctree), 5,
				    view_disks_geometry_ctree_label);

	disks_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(disks_view_tab_hbox, "disks_view_tab_hbox");
	gtk_widget_ref(disks_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "disks_view_tab_hbox",
				 disks_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(disks_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 6),
				   disks_view_tab_hbox);

	disks_view_tab_label = gtk_label_new(_("Disks"));
	gtk_widget_set_name(disks_view_tab_label, "disks_view_tab_label");
	gtk_widget_ref(disks_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "disks_view_tab_label",
				 disks_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(disks_view_tab_label);
	gtk_box_pack_end(GTK_BOX(disks_view_tab_hbox), disks_view_tab_label, FALSE, FALSE, 0);

	view_plugin_list_frame = gtk_frame_new(_("Plugins"));
	gtk_widget_set_name(view_plugin_list_frame, "view_plugin_list_frame");
	gtk_widget_ref(view_plugin_list_frame);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "view_plugin_list_frame",
				 view_plugin_list_frame, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(view_plugin_list_frame);
	gtk_container_add(GTK_CONTAINER(browser_notebook), view_plugin_list_frame);
	gtk_container_set_border_width(GTK_CONTAINER(view_plugin_list_frame), 3);

	plugin_scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_name(plugin_scrolledwindow, "plugin_scrolledwindow");
	gtk_widget_ref(plugin_scrolledwindow);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_scrolledwindow",
				 plugin_scrolledwindow, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_scrolledwindow);
	gtk_container_add(GTK_CONTAINER(view_plugin_list_frame), plugin_scrolledwindow);
	gtk_container_set_border_width(GTK_CONTAINER(plugin_scrolledwindow), 2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(plugin_scrolledwindow),
				       GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	plugin_columned_list = gtk_clist_new(6);
	gtk_widget_set_name(plugin_columned_list, "plugin_columned_list");
	gtk_widget_ref(plugin_columned_list);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_columned_list",
				 plugin_columned_list, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_columned_list);
	gtk_container_add(GTK_CONTAINER(plugin_scrolledwindow), plugin_columned_list);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 0, 21);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 1, 73);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 2, 57);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 3, 98);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 4, 80);
	gtk_clist_set_column_width(GTK_CLIST(plugin_columned_list), 5, 80);
	gtk_clist_column_titles_show(GTK_CLIST(plugin_columned_list));

	plugin_icon_clist_label = gtk_label_new("");
	gtk_widget_set_name(plugin_icon_clist_label, "plugin_icon_clist_label");
	gtk_widget_ref(plugin_icon_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_icon_clist_label",
				 plugin_icon_clist_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_icon_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 0, plugin_icon_clist_label);

	plugin_id_clist_label = gtk_label_new(_("Id"));
	gtk_widget_set_name(plugin_id_clist_label, "plugin_id_clist_label");
	gtk_widget_ref(plugin_id_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_id_clist_label",
				 plugin_id_clist_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_id_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 1, plugin_id_clist_label);

	plugin_version_clist_label = gtk_label_new(_("Version"));
	gtk_widget_set_name(plugin_version_clist_label, "plugin_version_clist_label");
	gtk_widget_ref(plugin_version_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_version_clist_label",
				 plugin_version_clist_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_version_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 2, plugin_version_clist_label);

	plugin_name_clist_label = gtk_label_new(_("Name"));
	gtk_widget_set_name(plugin_name_clist_label, "plugin_name_clist_label");
	gtk_widget_ref(plugin_name_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_name_clist_label",
				 plugin_name_clist_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_name_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 3, plugin_name_clist_label);

	plugin_oem_clist_label = gtk_label_new(_("Developer"));
	gtk_widget_set_name(plugin_oem_clist_label, "plugin_oem_clist_label");
	gtk_widget_ref(plugin_oem_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_oem_clist_label",
				 plugin_oem_clist_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_oem_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 4, plugin_oem_clist_label);

	plugin_description_clist_label = gtk_label_new(_("Description"));
	gtk_widget_set_name(plugin_description_clist_label, "plugin_description_clist_label");
	gtk_widget_ref(plugin_description_clist_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugin_description_clist_label",
				 plugin_description_clist_label,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugin_description_clist_label);
	gtk_clist_set_column_widget(GTK_CLIST(plugin_columned_list), 5,
				    plugin_description_clist_label);

	plugins_view_tab_hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_set_name(plugins_view_tab_hbox, "plugins_view_tab_hbox");
	gtk_widget_ref(plugins_view_tab_hbox);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugins_view_tab_hbox",
				 plugins_view_tab_hbox, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugins_view_tab_hbox);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(browser_notebook),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK(browser_notebook), 7),
				   plugins_view_tab_hbox);

	plugins_view_tab_label = gtk_label_new(_("Plugins"));
	gtk_widget_set_name(plugins_view_tab_label, "plugins_view_tab_label");
	gtk_widget_ref(plugins_view_tab_label);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "plugins_view_tab_label",
				 plugins_view_tab_label, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(plugins_view_tab_label);
	gtk_box_pack_end(GTK_BOX(plugins_view_tab_hbox), plugins_view_tab_label, FALSE, FALSE, 0);

	table_containing_bars = gtk_table_new(1, 2, FALSE);
	gtk_widget_set_name(table_containing_bars, "table_containing_bars");
	gtk_widget_ref(table_containing_bars);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "table_containing_bars",
				 table_containing_bars, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(table_containing_bars);
	gtk_box_pack_start(GTK_BOX(main_window_vbox), table_containing_bars, FALSE, FALSE, 0);

	main_status_bar = gtk_statusbar_new();
	gtk_widget_set_name(main_status_bar, "main_status_bar");
	gtk_widget_ref(main_status_bar);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "main_status_bar", main_status_bar,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(main_status_bar);
	gtk_table_attach(GTK_TABLE(table_containing_bars), main_status_bar, 0, 1, 0, 1,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

	main_progress_bar = gtk_progress_bar_new();
	gtk_widget_set_name(main_progress_bar, "main_progress_bar");
	gtk_widget_ref(main_progress_bar);
	gtk_object_set_data_full(GTK_OBJECT(main_window), "main_progress_bar", main_progress_bar,
				 (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show(main_progress_bar);
	gtk_table_attach(GTK_TABLE(table_containing_bars), main_progress_bar, 1, 2, 0, 1,
			 (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (0), 0, 0);
	gtk_tooltips_set_tip(tooltips, main_progress_bar,
			     _("Progress bar for long commit operations"), NULL);

	gtk_signal_connect(GTK_OBJECT(main_window), "destroy",
			   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_signal_connect(GTK_OBJECT(main_window), "delete_event",
			   GTK_SIGNAL_FUNC(on_main_window_delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(actions_menu_item_menu), "realize",
			   GTK_SIGNAL_FUNC(on_actions_menu_item_menu_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(create_evms_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Create a native EVMS volume"));
	gtk_signal_connect(GTK_OBJECT(create_evms_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_evms_volume_menu_item), "focus_in_event",
			   GTK_SIGNAL_FUNC(on_menu_item_focus_event),
			   _("Create a native EVMS volume"));
	gtk_signal_connect(GTK_OBJECT(create_evms_volume_menu_item), "focus_out_event",
			   GTK_SIGNAL_FUNC(on_menu_item_focus_event), NULL);
	gtk_signal_connect(GTK_OBJECT(create_evms_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_evms_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(create_compatibility_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Create a volume that maintains backward compatibility"));
	gtk_signal_connect(GTK_OBJECT(create_compatibility_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_compatibility_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_compatibility_volume_menu_item_activate),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(create_object_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Create a storage object using an EVMS feature"));
	gtk_signal_connect(GTK_OBJECT(create_object_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_object_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_object_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(create_region_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Create a storage region"));
	gtk_signal_connect(GTK_OBJECT(create_region_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_region_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_region_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(create_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Create a storage container"));
	gtk_signal_connect(GTK_OBJECT(create_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_container_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(create_segment_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Create a disk segment"));
	gtk_signal_connect(GTK_OBJECT(create_segment_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(create_segment_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_create_segment_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Delete volume and storage object hierarchy"));
	gtk_signal_connect(GTK_OBJECT(delete_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_delete_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_object_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Delete storage objects"));
	gtk_signal_connect(GTK_OBJECT(delete_object_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_object_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_delete_object_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Delete storage container"));
	gtk_signal_connect(GTK_OBJECT(delete_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(delete_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_delete_container_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Increase volume size"));
	gtk_signal_connect(GTK_OBJECT(expand_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_expand_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_object_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Increase storage object size"));
	gtk_signal_connect(GTK_OBJECT(expand_object_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_object_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_expand_object_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Grow container size by consuming new storage objects"));
	gtk_signal_connect(GTK_OBJECT(expand_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(expand_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_expand_container_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Reduce volume size"));
	gtk_signal_connect(GTK_OBJECT(shrink_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_shrink_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_object_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Reduce storage object size"));
	gtk_signal_connect(GTK_OBJECT(shrink_object_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_object_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_shrink_object_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Reduce container size by removing consumed storage objects"));
	gtk_signal_connect(GTK_OBJECT(shrink_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(shrink_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_shrink_container_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(add_feature_to_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Add a EVMS feature to an EVMS volume"));
	gtk_signal_connect(GTK_OBJECT(add_feature_to_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(add_feature_to_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_add_feature_to_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(assign_segment_manager_to_storage_object),
			   "enter_notify_event", GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Allow a storage object to be subdivided by an assigned segment manager"));
	gtk_signal_connect(GTK_OBJECT(assign_segment_manager_to_storage_object),
			   "leave_notify_event", GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(assign_segment_manager_to_storage_object), "activate",
			   GTK_SIGNAL_FUNC(on_assign_segment_manager_to_storage_object_activate),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(remove_object_from_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Transfer a consumed storage object out of a storage container"));
	gtk_signal_connect(GTK_OBJECT(remove_object_from_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(remove_object_from_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_remove_object_from_container_menu_item_activate),
			   NULL);
	gtk_signal_connect(GTK_OBJECT(remove_segment_manager_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Remove segment manager meta-data and data from storage object"));
	gtk_signal_connect(GTK_OBJECT(remove_segment_manager_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(remove_segment_manager_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_remove_segment_manager_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Modify logical volume properties"));
	gtk_signal_connect(GTK_OBJECT(modify_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_modify_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_object_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Modify storage object properties"));
	gtk_signal_connect(GTK_OBJECT(modify_object_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_object_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_modify_object_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_container_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Modify storage container properties"));
	gtk_signal_connect(GTK_OBJECT(modify_container_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(modify_container_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_modify_container_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(view_messages_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Display informational messages window"));
	gtk_signal_connect(GTK_OBJECT(view_messages_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(view_messages_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_view_messages_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(view_log_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Display a window with the current log entries"));
	gtk_signal_connect(GTK_OBJECT(view_log_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(view_log_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_view_log_menu_item_activate), NULL);

	gtk_signal_connect(GTK_OBJECT(convert_to_evms_volume_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Convert a compatibility volume to a EVMS volume"));
	gtk_signal_connect(GTK_OBJECT(convert_to_evms_volume_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(convert_to_evms_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_convert_to_evms_volume_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(convert_to_compatibility_volume_menu_item),
			   "enter_notify_event", GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Convert an EVMS volume back to a compatibility volume"));
	gtk_signal_connect(GTK_OBJECT(convert_to_compatibility_volume_menu_item),
			   "leave_notify_event", GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(convert_to_compatibility_volume_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_convert_to_compatibility_volume_menu_item_activate),
			   NULL);


	gtk_signal_connect(GTK_OBJECT(activate_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Activate a volume or object"));
	gtk_signal_connect(GTK_OBJECT(activate_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(activate_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_activate_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(deactivate_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Deactivate a volume or object"));
	gtk_signal_connect(GTK_OBJECT(deactivate_menu_item),
			   "leave_notify_event", GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(deactivate_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_deactivate_menu_item_activate),
			   NULL);

	gtk_signal_connect(GTK_OBJECT(replace_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Replace a storage object with another storage object"));
	gtk_signal_connect(GTK_OBJECT(replace_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(replace_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_move_object_data_menu_item_activate), NULL);

	gtk_signal_connect(GTK_OBJECT(volume_tasks_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Invoke plugin-specific operations for a logical volume"));
	gtk_signal_connect(GTK_OBJECT(volume_tasks_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(volume_tasks_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_volume_tasks_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(object_tasks_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Invoke plugin-specific operations for a storage object"));
	gtk_signal_connect(GTK_OBJECT(object_tasks_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(object_tasks_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_object_tasks_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(container_tasks_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Invoke plugin-specific operations for a storage container"));
	gtk_signal_connect(GTK_OBJECT(container_tasks_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(container_tasks_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_container_tasks_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(plugin_tasks_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Invoke plugin-specific operations"));
	gtk_signal_connect(GTK_OBJECT(plugin_tasks_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(plugin_tasks_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_plugin_tasks_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(mkfs_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Format a logical volume with a particular file system, e.g. ext2"));
	gtk_signal_connect(GTK_OBJECT(mkfs_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(mkfs_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_mkfs_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(fsck_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _
			   ("Check the file system on a volume for errors and optionally repair it"));
	gtk_signal_connect(GTK_OBJECT(fsck_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(fsck_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_fsck_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(obliterate_filesystem_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Remove meta-data that identifies the file system on a volume"));
	gtk_signal_connect(GTK_OBJECT(obliterate_filesystem_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(obliterate_filesystem_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_obliterate_filesystem_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(mount_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Mount a file system"));
	gtk_signal_connect(GTK_OBJECT(mount_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(mount_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_mount_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(unmount_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Unmount a file system"));
	gtk_signal_connect(GTK_OBJECT(unmount_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(unmount_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_unmount_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(commit_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Save all changes to disk"));
	gtk_signal_connect(GTK_OBJECT(commit_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(commit_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_commit_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(backup_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message),
			   _("Backup EVMS metadata"));
	gtk_signal_connect(GTK_OBJECT(backup_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(backup_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_backup_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(exit_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Quit this application"));
	gtk_signal_connect(GTK_OBJECT(exit_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(exit_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_exit_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(admin_node_menu_item), "enter_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), _("Switch to another node"));
	gtk_signal_connect(GTK_OBJECT(admin_node_menu_item), "leave_notify_event",
			   GTK_SIGNAL_FUNC(update_statusbar_message), NULL);
	gtk_signal_connect(GTK_OBJECT(admin_node_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_administer_node_menu_item_activate), NULL);

	gtk_signal_connect(GTK_OBJECT(engine_log_level_submenu_menu), "realize",
			   GTK_SIGNAL_FUNC(on_engine_log_level_submenu_menu_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(engine_log_level_submenu_menu), "map",
			   GTK_SIGNAL_FUNC(on_engine_log_level_submenu_menu_map), NULL);
	gtk_signal_connect(GTK_OBJECT(critical_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(CRITICAL));
	gtk_signal_connect(GTK_OBJECT(serious_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(SERIOUS));
	gtk_signal_connect(GTK_OBJECT(error_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(ERROR));
	gtk_signal_connect(GTK_OBJECT(warning_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(WARNING));
	gtk_signal_connect(GTK_OBJECT(default_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(DEFAULT));
	gtk_signal_connect(GTK_OBJECT(details_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(DETAILS));
	gtk_signal_connect(GTK_OBJECT(entry_exit_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(ENTRY_EXIT));
	gtk_signal_connect(GTK_OBJECT(debug_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(DEBUG));
	gtk_signal_connect(GTK_OBJECT(extra_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(EXTRA));
	gtk_signal_connect(GTK_OBJECT(everything_engine_level_menuitem), "activate",
			   GTK_SIGNAL_FUNC(set_engine_log_level), GUINT_TO_POINTER(EVERYTHING));
/*
  gtk_signal_connect (GTK_OBJECT (kernel_info_level_submenu_menu), "realize",
                      GTK_SIGNAL_FUNC (on_kernel_info_level_submenu_menu_realize),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (kernel_info_level_submenu_menu), "map",
                      GTK_SIGNAL_FUNC (on_kernel_info_level_submenu_menu_map),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (critical_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(CRITICAL));
  gtk_signal_connect (GTK_OBJECT (serious_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(SERIOUS));
  gtk_signal_connect (GTK_OBJECT (error_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(ERROR));
  gtk_signal_connect (GTK_OBJECT (warning_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(WARNING));
  gtk_signal_connect (GTK_OBJECT (default_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(DEFAULT));
  gtk_signal_connect (GTK_OBJECT (details_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(DETAILS));
  gtk_signal_connect (GTK_OBJECT (debug_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(DEBUG));
  gtk_signal_connect (GTK_OBJECT (extra_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(EXTRA));
  gtk_signal_connect (GTK_OBJECT (entry_exit_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(ENTRY_EXIT));
  gtk_signal_connect (GTK_OBJECT (everything_kernel_level_menuitem), "activate",
                      GTK_SIGNAL_FUNC (set_kernel_log_level),
                      GUINT_TO_POINTER(EVERYTHING));
*/
	gtk_signal_connect(GTK_OBJECT(web_links_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_web_links_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(about_menu_item), "activate",
			   GTK_SIGNAL_FUNC(on_about_menu_item_activate), NULL);
	gtk_signal_connect(GTK_OBJECT(toolbar_commit_button), "clicked",
			   GTK_SIGNAL_FUNC(on_toolbar_commit_button_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(refresh_button), "clicked",
			   GTK_SIGNAL_FUNC(on_refresh_button_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(exit_button), "clicked",
			   GTK_SIGNAL_FUNC(on_exit_button_clicked), NULL);
	gtk_signal_connect(GTK_OBJECT(browser_notebook), "realize",
			   GTK_SIGNAL_FUNC(on_browser_notebook_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_volumes_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_volumes_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_volumes_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_volumes_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_volumes_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_volumes_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(view_objects_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_objects_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_objects_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_objects_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_objects_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_objects_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(ctree1), "realize",
			   GTK_SIGNAL_FUNC(on_view_feature_objects_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(ctree1), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(ctree1), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(ctree1), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(ctree1), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(view_regions_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_regions_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_regions_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_regions_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_regions_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_regions_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(view_containers_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_containers_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_containers_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_containers_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_containers_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_containers_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(view_segments_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_segments_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_segments_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_segments_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_segments_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_segments_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(view_disks_ctree), "realize",
			   GTK_SIGNAL_FUNC(on_view_disks_ctree_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(view_disks_ctree), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(view_disks_ctree), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_disks_ctree), "tree_expand",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_expand), NULL);
	gtk_signal_connect_after(GTK_OBJECT(view_disks_ctree), "tree_collapse",
				 GTK_SIGNAL_FUNC(on_view_ctree_tree_collapse), NULL);
	gtk_signal_connect(GTK_OBJECT(plugin_columned_list), "realize",
			   GTK_SIGNAL_FUNC(on_plugin_columned_list_realize), NULL);
	gtk_signal_connect(GTK_OBJECT(plugin_columned_list), "button_press_event",
			   GTK_SIGNAL_FUNC(on_view_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(plugin_columned_list), "key_press_event",
			   GTK_SIGNAL_FUNC(on_view_key_press_event), NULL);

	gtk_object_set_data(GTK_OBJECT(main_window), "tooltips", tooltips);

	gtk_window_add_accel_group(GTK_WINDOW(main_window), accel_group);

	return main_window;
}
