/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

typedef void (*iterate_func)(GList *element, int index, void *user_data);

/**
 *	delete_all_elements - iterate elements and call user function before deleting
 *	@list: the address of the linked list to delete all elements from
 *	@func: the user function
 *	@extra: argument to pass to user user function
 *
 *	This routine walks the given linked list and invokes the user function for each
 *	link element. Once the we've walked the list to invoke the user functions, we
 *	destroy the entire list.
 */
static inline void delete_all_elements(GList *list, GFunc func, void *extra)
{
	g_assert(func != NULL);
	g_list_foreach(list, func, extra);
	g_list_free(list);
}

/**
 *	for_n_elements - process n list elements of the linked list
 *	@start: the first item to process
 *	@count: how many items to process
 *	@func: the user function to invoke for each element processed
 *	@extra: argument to pass to user function invocations
 *
 *	This routine processes n list elements starting at the given one.
 *	Note that if we run out of list elements, we continue the loop and
 *	invoking the user function. The user function must check for a NULL
 *	element.
 */
static inline void for_n_elements(GList *start, int count, iterate_func func, void *extra)
{
	int i;
	GList *element;

	g_assert(func != NULL);
	element = start;
	for (i = 0; i < count; i++) {
		func(element, i, extra);
		if (element != NULL) {
			element = element->next;
		}
	}
}

