#! /usr/bin/awk -f
#
# -------------------------------------------------------------------------
# fgoptions.awk - An AWK script to generate fbgetty variable names list
# This is part of fbgetty package
#
# -------------------------------------------------------------------------
# @(#) $Id: fgoptions.awk,v 1.1.2.1 2001/07/11 20:01:15 lch Exp $
# -------------------------------------------------------------------------
#
# Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

BEGIN {
  print "/*";
  print " * DO NOT MODIFY THIS FILE,";
  print " * it's automatically generated";
  print " */";
  
  printf("\n\n");
  
  print "typedef struct fbgetty_options_t";
  print "{"
    
  # setup the Field Separator
  FS=" *[(,)] *"; # break line like that:  VARIABLE  (  type  ,  name  )  ;
}

# match only VARIABLE lines
$0 ~ /^VARIABLE\(.*\)/ {
  name = $3;
  type = $2;

  printf("#define OFFSET_%s (offsetof(struct fbgetty_options_t, %s))\n", name, name);
  printf(" %s %s;\n\n", type, name);     
}

END {
  print "} fbgetty_options_t;"
}
