/*
 * main.c : fbgetty loader 
 * Part of fbgetty 
 * Copyright (C) 1999 2000 2001 Yann Droneaud <ydroneaud@meuh.eu.org>. 
 *
 * fbgetty is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * fbgetty is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

/*
 * CVS id: $Id: main.c,v 1.8.2.5 2001/12/23 21:55:12 ydroneaud Exp $
 */

#include <fbgetty/global.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <syslog.h>
#include <string.h>
#include <errno.h>

#include <fbgetty/options.h>
#include <fbgetty/init.h>
#include <fbgetty/errors.h>
#include <fbgetty/vt.h>
#include <fbgetty/prompt.h>
#include <fbgetty/utmp.h>

#ifdef DEBUG_MEMORY
#include <mcheck.h>
#endif

#ifdef DEBUGGER_SUPPORT
int wait_for_gdb = 1;
#endif /* DEBUGGER_SUPPORT */

int 
main (int argc, char *argv[])
{

#ifdef DEBUG_MEMORY
  mtrace();
#endif

#ifdef DEBUGGER_SUPPORT
  while(wait_for_gdb)
    sleep(1);

  goto real_main; /* i did not remember why i put a goto here */

 real_main:
#endif /* DEBUGGER_SUPPORT */

#ifndef __GLIBC__
  program_invocation_name = argv[0];

  /* get program short name */
  if (strrchr (program_invocation_name, '/') != NULL)
    program_invocation_short_name = strrchr (program_invocation_name, '/') + 1;
  else
    program_invocation_short_name = program_invocation_name;
#endif

  openlog (program_invocation_short_name, LOG_CONS | LOG_PID , LOG_AUTH);

  /* create the global fgoptions structure */
  fgoptions = fgoptions_create(); /* the return value will never be NULL */

  /* set to FALSE until fbgetty open the tty */
  fgoptions->master = FALSE; /* need early initialisation */

#ifdef FB_GETTY_DEBUG
  error("fbgetty launched");
#endif

  /* parse option */
  parse_options(argc, argv);
 
  /* open tty */
  init();

  /* Write we are using tty (or something like that) */
  utmp_update();

  /* this make fbgetty redisplay issue if an empty name is entered */
#define EMPTY_LOGIN_REFRESH_SCREEN 1

  /* read log name */
  do
    {
      /* Display issue */
      refresh_screen(); /* some problem if no issue and no clear screen */

      get_login_name();
    }
  while (fgoptions->login_name_valid != TRUE
	 || fgoptions->login_name == NULL
#ifdef EMPTY_LOGIN_REFRESH_SCREEN 
	 || fgoptions->login_name[0] == '\0'
#endif
	 );

  putchar('\n');

  /* close devices */
  fgcleanup();
  
  closelog();

#ifdef DEBUG_MEMORY
  muntrace();
#endif

  /* launch login process */
  if (execl (fgoptions->login_program, fgoptions->login_program , "--", fgoptions->login_name, NULL) == -1)
    {    
      openlog (program_invocation_short_name, LOG_CONS | LOG_PID , LOG_AUTH);
      fatal_error ("%s: can't exec %s: %m", fgoptions->tty_device, fgoptions->login_program );
    }

  fgexit(EXIT_FAILURE);

  return 0; /* only for stopping gcc warning */
}
