# FIAIF is an Intelligent firewall, version: $Revision: 1.18 $
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author:	Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2004 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

## This file contains the patterns and rules used by 'syntax.awk'
## To test the syntax of a zone configuration file.

BEGIN { 
    # Patterns:
    # Parse the list of zones:
    if (ZONES != "") {
	gsub(",", "|", ZONES)
	ZONES = sprintf("%s|ALL|all", ZONES)
    } else {
	ZONES = "#string#"
    }

    PATTERN["alias"]             = "#string#"
    PATTERN["zone"]              = ZONES
    PATTERN["empty"]             = ""
    PATTERN["any"]               = ".*"
    PATTERN["space"]             = "[ ]+"
    PATTERN["colon"]             = ":"
    PATTERN["integer"]           = "[0-9]+"
    PATTERN["hex"]               = "[0-9A-Fa-f]+"
    PATTERN["string"]            = "[A-Za-z][a-zA-Z0-9_-]*"
    PATTERN["boolean"]           = "(0|1)"
    PATTERN["filename"]          = "([/]*[A-Za-z0-9_.-]+)+"
    PATTERN["device"]            = "[A-Za-z]+([0-9]+|[+])"
    PATTERN["proto_tcp_udp"]     = "(TCP|tcp|UDP|udp)"
    PATTERN["proto_icmp"]        = "(ICMP|icmp)"
    PATTERN["protocol"]          = "(#integer#|#string#)"
    PATTERN["port"]              = "(#integer#|#string#)"
    PATTERN["port_range"]        = "#integer#(:#integer#)?"
    PATTERN["port_list"]         = "(#port_range#|#port#)(,(#port_range#|#port#))*"
    PATTERN["icmp_type"]         = "(#integer#)|(#string#)"
    PATTERN["policy"]            = "(ACCEPT|REJECT|DROP|LOG|ACCEPT_LOG|DROP_NOLOG|REJECT_NOLOG)"
    PATTERN["ip"]                = "[0-9]+[.][0-9]+[.][0-9]+[.][0-9]+"
    PATTERN["ip_mask"]           = "#ip#(/#mask#)?"
    PATTERN["ipset"]             = "#string#"
    PATTERN["mask"]              = "(#ip#|#integer#)"
    PATTERN["ip_extra_list"]     = "#ip#([ ]+#ip#)*"
    PATTERN["ip_list"]           = "#ip#(,#ip#)*"
    PATTERN["ip_mask_list"]      = "#ip_mask#([ ]+#ip_mask#)*"
    PATTERN["ip_range"]          = "#ip#(-#ip#)?"
    PATTERN["network"]           = "#ip#/#mask#"
    PATTERN["network_list"]      = "#network#([ ]+#network#)*" 
    PATTERN["src_ip"]            = "#ipset#|#ip_mask#"
    PATTERN["dst_ip"]            = "#ipset#|#ip_mask#"
    PATTERN["to"]                = "=>"
    PATTERN["mac"]               = "#hex#:#hex#:#hex#:#hex#:#hex#:#hex#"
    PATTERN["mac_list"]          = "#mac#([ ]+#mac#)*"
    PATTERN["limit_rate"]        = "(second|minute|hour|day)"
    PATTERN["limit"]             = "#integer#/(#limit_rate#)"
    PATTERN["burst"]             = "#integer#"
    PATTERN["tc_type"]           = "(CBQ|HTB)"

    # Rules:
    RULE["PROTO_IP"]             = "(proto_tcp_udp space port_list | proto_icmp space icmp_type | protocol) space src_ip to dst_ip"
    RULE["NAME"]                 = "zone"
    RULE["DEV"]                  = "device"
    RULE["DYNAMIC"]              = "boolean"
    RULE["GLOBAL"]               = "boolean"
    RULE["IP"]                   = "ip"
    RULE["MASK"]                 = "mask"
    RULE["NET"]                  = "network"
    RULE["BCAST"]                = "ip"
    RULE["IP_EXTRA"]             = "(ip_extra_list | empty)"
    RULE["NET_EXTRA"]            = "(network_list | empty)"
    RULE["DHCP_SERVER"]          = "boolean"
    RULE["INPUT"]                = "policy space <PROTO_IP>"
    RULE["OUTPUT"]               = "policy space <PROTO_IP>"
    RULE["FORWARD"]              = "zone space policy space <PROTO_IP>"
    RULE["MARK"]                 = "zone space integer space <PROTO_IP>"
    RULE["REPLY"]                = "zone space icmp_type space <PROTO_IP>"
    RULE["REDIRECT"]             = "<PROTO_IP> space (ip_list | alias) (space port | empty)"
    RULE["WATCH_IP"]             = "(ip_mask_list | filename | empty)"
    RULE["MAC_DROP"]             = "(mac_list | filename | empty)"
    RULE["IP_DROP"]              = "(ip_mask_list | filename | empty)"
    RULE["ECN_REMOVE"]           = "(ip_mask_list | filename | empty)"
    RULE["SNAT"]                 = "(zone | ip) space <PROTO_IP>"
    RULE["LIMIT"]                = "zone space policy space limit space burst space <PROTO_IP>"
    RULE["TC_ENABLE"]            = "integer"
    RULE["TC_TYPE"]              = "tc_type"
    RULE["TC_DOWNLINK"]          = "integer"
    RULE["TC_UPLINK"]            = "integer"
    RULE["IPSET"]                = "any"
}
