<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
    
    Backend module: CSV parsing of accounting tables

    These functions parse a given CSV file and return an array of arrays as a
    result. On error they return an integer denoting the faulty line number or
    null if given file cannot be opened.
*/

# parse account file
# result structure: (id, parentid, acronym, name, type)
function get_accounts_csv( $filename )
{
    if( $f = fopen( $filename, 'rb' ) ) {
	$line = 0;
	$data = array();
	while( $row = fgetcsv( $f, 1024 ) ) {
	    ++$line;
	    if( is_null( $row[0] ) ) continue;
	    if( count( $row ) == 5 &&
		    is_numeric( $row[0] ) && is_numeric( $row[1] ) && 
		    is_numeric( $row[4] ) && $row[4] >= 0 && $row[4] <= 4 )
		array_push( $data, $row );
	    else {
		fclose( $f );
		return $line;
	    }
	}
	fclose( $f );
	return $data;
    } else
	return null;
}

# parse journal file
# result structure: (id, debitacc, creditacc, value, receipt, description, time)
function get_journal_csv( $filename )
{
    if( $f = fopen( $filename, 'rb' ) ) {
	$line = 0;
	$data = array();
	while( $row = fgetcsv( $f, 1024 ) ) {
	    ++$line;
	    if( is_null( $row[0] ) ) continue;
	    if( count( $row ) == 7 &&
		    is_numeric( $row[0] ) && is_numeric( $row[1] ) && 
		    is_numeric( $row[2] ) && is_numeric( $row[3] ) ) 
		array_push( $data, $row );
	   else {
		fclose( $f );
		return $line;
	    }
	}
	fclose( $f );
	return $data;
    } else
	return null;
}

# parse repeated file
# result structure: 
# (id, debitacc, creditacc, value, receipt, description, nextdue, repDays, repMonths)
function get_repeated_csv( $filename )
{
    if( $f = fopen( $filename, 'rb' ) ) {
	$line = 0;
	$data = array();
	while( $row = fgetcsv( $f, 1024 ) ) {
	    ++$line;
	    if( is_null( $row[0] ) ) continue;

	    if( count( $row ) == 9 &&
		    is_numeric( $row[0] ) && is_numeric( $row[1] ) &&
		    is_numeric( $row[2] ) && is_numeric( $row[3] ) &&
		    ( ( is_numeric( $row[7] ) && !$row[8] ) ||
		      ( ( !$row[7] && is_numeric( $row[8] ) ) ) ) )
		array_push( $data, $row );
	    else {
		fclose( $f );
		return $line;
	    }
	}
	fclose( $f );
	return $data;
    } else
	return null;
}

?>
