//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: ConnectivityBuilder.cpp,v 1.2 2003/04/27 17:04:27 delpinux Exp $

#include <ConnectivityBuilder.hpp>
#include <Connectivity.hpp>
#include <MeshOfTetrahedra.hpp>
#include <MeshOfHexahedra.hpp>

void ConnectivityBuilder<MeshOfHexahedra>::setFaces()
{
  __face[0][0] = 4;
  __face[0][1] = 7;
  __face[0][2] = 3;
  __face[0][3] = 0;

  __face[1][0] = 1;
  __face[1][1] = 2;
  __face[1][2] = 6;
  __face[1][3] = 5;

  __face[2][0] = 4;
  __face[2][1] = 5;
  __face[2][2] = 1;
  __face[2][3] = 0;

  __face[3][0] = 3;
  __face[3][1] = 2;
  __face[3][2] = 6;
  __face[3][3] = 7;

  __face[4][0] = 0;
  __face[4][1] = 1;
  __face[4][2] = 2;
  __face[4][3] = 3;

  __face[5][0] = 7;
  __face[5][1] = 6;
  __face[5][2] = 5;
  __face[5][3] = 4;
}

void ConnectivityBuilder<MeshOfTetrahedra>::setFaces()
{
  __face[0][0] = 1;
  __face[0][1] = 2;
  __face[0][2] = 3;

  __face[1][0] = 3;
  __face[1][1] = 2;
  __face[1][2] = 0;

  __face[2][0] = 0;
  __face[2][1] = 1;
  __face[2][2] = 3;

  __face[3][0] = 2;
  __face[3][1] = 1;
  __face[3][2] = 0;
}

void ConnectivityBuilder<SurfaceMeshOfTriangles>::setFaces()
{
  __face[0][0] = 1;
  __face[0][1] = 2;

  __face[1][0] = 2;
  __face[1][1] = 0;

  __face[2][0] = 0;
  __face[2][1] = 1;
}
