//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalBorderOperator.hpp,v 1.3 2004/04/22 15:16:20 delpinux Exp $

#ifndef VARIATIONAL_BORDER_OPERATOR_HPP
#define VARIATIONAL_BORDER_OPERATOR_HPP

/**
 * @file   VariationalBorderOperator.hpp
 * @author Stephane Del Pino
 * @date   Thu May 30 18:19:22 2002
 * 
 * @brief  Variational Operator living on a border
 * 
 * Variational border operators
 */

#include <Boundary.hpp>

class VariationalBorderOperator
{
private:
  const size_t __testFunctionNumber; /**< test function number */

  ReferenceCounting<Boundary>
  __boundary; /**< The boundary where the integral is computed */

public:

  /** 
   * read only access to the boundary
   * 
   * @return *__boundary
   */
  const Boundary& boundary() const
  {
    return *__boundary;
  }

  /** 
   * Access to the boundary reference
   * 
   * @return __boundary
   */
  ReferenceCounting<Boundary> boundaryReference() const
  {
    return __boundary;
  }

  /** 
   * 
   * Returns the test function number
   * 
   * @return __testFunctionNumber
   */
  const size_t testFunctionNumber() const
  {
    return __testFunctionNumber;
  }

  /** 
   * Copy constructor
   * 
   * @param number number of the test function
   * @param boundary the boundary where the variational border operator is defined
   */
  VariationalBorderOperator(const size_t number,
			    ReferenceCounting<Boundary> boundary)
    : __testFunctionNumber(number),
      __boundary(boundary)
  {
    ;
  }

  /** 
   * Copy Constructor
   * 
   * @param vo VariationalBorderOperator
   */
  VariationalBorderOperator(const VariationalBorderOperator& vo)
    : __testFunctionNumber(vo.__testFunctionNumber),
      __boundary(vo.__boundary)
  {
    ;
  }

  /** 
   * Destructor
   * 
   */
  virtual ~VariationalBorderOperator()
  {
    ;
  }
};

#endif // VARIATIONAL_BORDER_OPERATOR_HPP

