# First draft 06/27/96    Jianjun

# constrct a FitsImage object
# FitsImage FitsImageObjName FitsFileObjName chdu 

class FitsImage {
    inherit Table
    constructor {args} {}
    destructor         {}

    public method makeImage { }
    public method showCell {col row}
    public method setFileName { fName }

    protected method buildMenus {}
    protected method postMenus {}
    protected method drawTable {}
    protected method readInTable {} 
    protected method saveTableToAscii  {win asciiFileName} 
    protected method plotCmd {} 
    protected method powMakeImage {} 
    protected method saoMakeImage {}
    protected method ds9MakeImage {}
    public    method imagePlot {parmList}

    protected method readTabData {fCol fRow nCols nRows} 
    protected method writeTabData {col row val}
    protected method getFormattedData {col row}
    protected method getRawData {col row}
    protected method putRawData {col row val}
    protected method getRawDataBlock { fCol fRow lCol lRow }
    protected method putRawDataBlock { fCol fRow data }

    protected variable imgType
    protected variable bitpixKey
    protected variable dataAddress
    protected variable cellSize
    protected variable isImageTable 0
    protected variable slice 1
    protected variable dims
    protected variable imgNull
}


body FitsImage::constructor {args} {

#use the FitsFile class to handle the FITS files.
    set fFObj  FitsExtension::[lindex $args 0]
    set father [lindex $args 1]

    set chdu           [$fFObj cget -chdu]
    set isFailedToCopy [$fFObj cget -isFailedToCopy]
    set fitsfileCmd    [$fFObj cget -fitsfile]
    set fileName       [$fFObj getOrigName]

# Image info        
    set dims [$fFObj getImgInfo]
    if { [llength $dims]>1 } {
       set numCols [lindex $dims 0]
       set numRows [lindex $dims 1]
    } else {
       # Display image vertically
       set numCols 1
       set numRows [lindex $dims 0]
    }
    if { $showRows > $numRows } {
       set showRows $numRows
    }
    if { $showCols > $numCols } {
       set showCols $numCols
    }

    set bitpixKey   [lindex [join [eval $fFObj getKeyword BITPIX] ] 1]

    if { [catch { set tmpNul [$fFObj getKeyword BLANK] }] } {
	set imgNull "NULL"
    } else {
	set imgNull [lindex [join $tmpNul] 1]
    }

    if { ![catch {$fFObj getKeyword BZERO}] ||
	 ![catch {$fFObj getKeyword BSCALE}] } {
	set imgType 4
	set imgForm "% #.10E"
    } else {
	if { $bitpixKey == "8" } {
	    set imgType 0 
	    set imgForm "%u"
	} elseif {$bitpixKey == "16"} {
	    set imgType 1 
	    set imgForm "%d"
	} elseif {$bitpixKey == "32"} {
	    set imgType 2 
	    set imgForm "%d"
	} elseif {$bitpixKey == "-32"} {
	    set imgType 3 
	    set imgForm "% #.5f"
	} elseif {$bitpixKey == "-64"} {
	    set imgType 4 
	    set imgForm "% #.10E"
	} else {
	    puts "unsupported image format, treat as integer type"
	    set imgType 2
	}
    }

    $father addChild $this table
}

body FitsImage::destructor {} {

#take care of the stuff on the canvas
    if { $isImageTable } {
       set isBeingDestroyed 1
       destroy $droot
    }

    $father freeChild $this
}


body FitsImage::setFileName { fName } {

   Table::setFileName $fName
   .fvwinkeeper signoff  $droot
   .fvwinkeeper register $droot "Image Table" [urlTail $fName] $chdu \
         $this
}


body FitsImage::drawTable {} {

   Table::drawTable

   bind $droot <<Plot>>        [code $this plotCmd]
}


body FitsImage::buildMenus {} {
    global isMac
    
    if { $isMac } {
        set mBar .mbar.itable
    } else {
        set mBar $droot.mbar
    }
    $droot config -menu $mBar
    
    if { ![winfo exists $mBar] } {
       buildNewMenus

       # Can only Plot an image
       $mBar.tools add command -label "Plot..." \
             -command "doMenuEvent <<Plot>>"

    }
}


body FitsImage::postMenus {} {
   Table::postMenus
   update idle
}   


body FitsImage::readInTable { } {
    global charPix

    set DC(height)      20
    set DC(width)       [expr (int(log10($numRows))+6)*$charPix]
    set DC(headroom)    20
    set DC(footroom)    40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace)   6
    set DC(interline)    0
    set DC(tmar)         6
    set DC(lmar)         8
    set DC(tabspace)     0

# flag that the imageTable is being displayed
    set isImageTable 1

    if { $imgType == 0 } {
	set cellSize 8
    } elseif {$imgType == 1} {
	set cellSize 8
    } elseif {$imgType == 2} {
	set cellSize 16
    } elseif {$imgType == 3} {
	set cellSize 16
    } elseif {$imgType == 4} {
	set cellSize 20
    } else {
	set cellSize 8
    }

    set colSelList {}
    set dispCols $numCols
    set tabType Image

# use fits command setrowstate to initialize the rowState
# usage   setrowstate totalNumOfRos startRow endRow status 
# (0:normal, 1:selected, 2: deleted)
    setarray rowState 0 [expr $numRows-1] 0
    setarray colState 0 [expr $dispCols-1] 0

    set absXPos(0) [expr $DC(lmar) + $DC(width) + $DC(rightspace)]
    for {set i 0} {$i < $dispCols} {incr i} {
	set columnName($i) [expr $i+1]
	set columnType($i) " "
	set columnUnit($i) " "
	lappend colSelList [expr $i+1]
	set cellWidth($i) $cellSize 
	set cellPixWidth($i) [expr $charPix*(1+$cellWidth($i))]
	set absXPos([expr $i+1]) [expr $absXPos($i) + $cellPixWidth($i) \
				      +$DC(rightspace)] 
    }

}


body FitsImage::makeImage { } {
    global hasSAOtng hasDS9

    if { $fvPref::imgDisplayer == "SAOtng" && $hasSAOtng } {
	set err [catch {saoMakeImage} errmsg]
    } elseif { $fvPref::imgDisplayer == "DS9" && $hasDS9 } {
	set err [catch {ds9MakeImage} errmsg]
    } else {
	set err [catch {powMakeImage} errmsg]
    }
    
    # after the image is displayed. clean up   
    delete object $this
    if { $err } {
        error $errmsg
    }
}

body FitsImage::saoMakeImage {} {
    global backupDir

    set err "none"

    set tmpfile $backupDir/saoimage.fits
    if { ![catch {$fFObj copyCHDU $tmpfile} ] } {
	catch {exec xpaaccess SAOtng} result  
	if { [string range $result 0 1] == "no" } {
	    # start SAOtng if SAOtng isn't there
	    if { [catch {exec saotng &} saopid] } {
		file delete $tmpfile
	        if { [tk_dialog .saoError "SAOtng startup error" \
		        "Cannot start saotng!\nUse POW instead?" \
			question 0 Yes No] == 0 } {
		     powMakeImage
                }
		return
	    } 
	    # wait till saotng is up
	    set flag  1
            set nSecs 0
	    while { $flag } {
                after 1000
                incr  nSecs
		catch {exec xpaaccess SAOtng} result
                if { [string range $result 0 2] == "yes" } {
                   set flag 0
                } else {
                   if { $nSecs > 10 } {
                      file delete $tmpfile
                      if { [tk_dialog .saoError "SAOtng startup error" \
                            "Cannot start saotng!\nUse POW instead?" \
                            question 0 Yes No] == 0 } {
                         powMakeImage
                      }
                      return
                   }
                }
	    } 
	} 
	exec echo "flip y"  | xpaset SAOtng
	exec xpaset SAOtng fits < $tmpfile
	file delete $tmpfile 
    }
}
    
body FitsImage::ds9MakeImage {} {
    global backupDir

    set err "none"

    set tmpfile $backupDir/saoimage.fits
    if { ![catch {$fFObj copyCHDU $tmpfile} ] } {
	catch {exec xpaaccess ds9} result  
	if { [string range $result 0 1] == "no" } {
	    # start DS9 if DS9 isn't there
	    if { [catch {exec ds9 &} ds9pid] } {
		file delete $tmpfile
	        if { [tk_dialog .saoError "DS9 startup error" \
		        "Cannot start DS9!\nUse POW instead?" \
			question 0 Yes No] == 0 } {
		     powMakeImage
                }
		return
	    } 
	    # wait till ds9 is up
	    set flag  1
            set nSecs 0
	    while { $flag } {
                after 1000
                incr  nSecs
		catch {exec xpaaccess ds9} result
                if { [string range $result 0 2] == "yes" } {
                   set flag 0
                } else {
                   if { $nSecs > 10 } {
                      file delete $tmpfile
                      if { [tk_dialog .saoError "DS9 startup error" \
                            "Cannot start ds9!\nUse POW instead?" \
                            question 0 Yes No] == 0 } {
                         powMakeImage
                      }
                      return
                   }
                }
	    } 
	} 
	exec xpaset ds9 fits < $tmpfile
	file delete $tmpfile 
    }
}
    
body FitsImage::powMakeImage {} {
    global powWCS

    # get the pow widget 
    if { [winfo exist .pow.pow]!=1 } { 
	powInit .dummy
    }
    set dataAddress [$fFObj loadImage] 

    set cleanFileName [urlTail $fileName]
    set imgIndex  ${cleanFileName}_[expr $chdu-1]
    set imgHandle ${cleanFileName}_[expr $chdu-1]

    set imgType $imgType
    if { [llength $dims]==1 } {
       # Display image horizontally
       set nCols $numRows
       set nRows $numCols
    } else {
       set nCols $numCols
       set nRows $numRows
    }

# the last param is for copying  data
    eval powCreateData $imgHandle $dataAddress $imgType \
		   [expr $nCols*$nRows] 1
# free the data array
    $fFObj freeImage  $dataAddress
    
    set x_0 1
    set y_0 1
    set incrx 1
    set incry 1
    set x_label ""
    set y_label ""
    set x_unit "pixels"
    set y_unit "pixels"
    if { ![catch {set tmp [$fFObj getKeyword CTYPE1]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set x_label [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CTYPE2]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set y_label [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CUNIT1]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set x_unit [string trim $v {' }]
    }
    if { ![catch {set tmp [$fFObj getKeyword CUNIT2]}] } {
       set v [lindex [lindex $tmp 0] 1]
       set y_unit [string trim $v {' }]
    }


    # Get the WCS info (if needed) and pass them to pow

    if { $fvPref::ifWCSInfo } {

       set wcsinfo [$fFObj getWcs]
       set powWCS($imgIndex) $wcsinfo
       set x_label [lindex [lindex $wcsinfo 3] 0]
       set y_label [lindex [lindex $wcsinfo 3] 1]
       if { $x_unit=="pixels" } {set x_unit NULL}
       if { $y_unit=="pixels" } {set y_unit NULL}

    } else {
       set powWCS($imgIndex) ""
    }

	
    powCreateImage $imgHandle $imgHandle 0 0 $nCols $nRows $x_0 \
		   $incrx $y_0 $incry $x_label $y_label counts

    powCreateGraph $imgHandle NULL $imgHandle $x_unit $y_unit \
	$x_label $y_label \
	[lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1] 
    
# register for the linkage to table display
    .pow.pow bind img_$imgHandle <<DblBtnPress>> \
          "+returnCurrentImageInfo [$fFObj getMaster] $chdu $imgHandle %x %y"
}

body FitsImage::saveTableToAscii  {win asciiFileName} {

# setup the grouping 
  set tmpWidth  $cellSize
  set tmpFirstCol(0) 1
  set groupCount  0  

  for {set  n 0} {$n < $numCols-1} {incr n} {
      set tmpWidth [expr  $tmpWidth + $cellSize]
      if { $tmpWidth > $asciiColWidth} {
      incr groupCount 
      set tmpWidth  $cellSize;
	  set tmpFirstCol($groupCount) [expr  $n+2]
    }
  }
  incr groupCount
  set tmpFirstCol($groupCount) [expr 1+$numCols]

  $win.f.fb configure -steps $groupCount
  for {set k 0} {$k< $groupCount} {incr k} {
      set nCols  [expr $tmpFirstCol([expr $k+1])-$tmpFirstCol($k)]
      $fFObj saveImgToASCII $asciiFileName $k \
	  1 $numRows $tmpFirstCol($k) $nCols $cellSize
      if {[catch {$win.f.fb step}]} {
	  file delete $asciiFileName
	  return
      }
  }
  destroy $win

}

body FitsImage::plotCmd { } {
    global GL

    set tmpName [namespace tail $this]

    FitsImgPlotSel .pltSel_$tmpName $this $numCols $numRows
    wm title .pltSel_$tmpName "Image Plot Selection"

    tkwait window .pltSel_$tmpName

    if { [info exist GL($this,plotImg)] == 0} {
	return
    }

    if { [llength $GL($this,plotImg)] == 0} {
	return
    }

    imagePlot $GL($this,plotImg)
}

body FitsImage::imagePlot {paramList} {

    set imgPlotType   [lindex $paramList 0]
    set imgPlotStart  [lindex $paramList 1]
    set imgPlotEnd    [lindex $paramList 2]
    set imgCurrgn     [lindex $paramList 3]

    set graphID [namespace tail $this] 
    set graphID ${graphID}_$gid
    
    if { $imgPlotType == "row" } {

       powCreateVectorEN x_$graphID ColumnNumber $numCols \
                         1 1 NULL
       if { [llength $dims]==1 } {
	  set dataAdd [$fFObj loadImageMeanCols $imgPlotStart \
		$imgPlotEnd $slice]
       } else {
	  set dataAdd [$fFObj loadImageMeanRows $imgPlotStart \
		$imgPlotEnd $slice]
       }
    } else { 

	powCreateVectorEN x_$graphID RowNumber $numRows \
	    1 1 NULL
       if { [llength $dims]==1 } {
	  set dataAdd [$fFObj loadImageMeanRows $imgPlotStart \
		$imgPlotEnd $slice]
       } else {
	  set dataAdd [$fFObj loadImageMeanCols $imgPlotStart \
		$imgPlotEnd $slice]
       }
    }

    powCreateData y_d_$graphID  [lindex $dataAdd 0] \
	[lindex $dataAdd 1]  [lindex $dataAdd 2] 1
    $fFObj freeColumn [lindex $dataAdd 0]	
    powCreateVector y_$graphID y_d_$graphID 0 [lindex $dataAdd 2] 1	
    
    set xUnit NULL
    set yUnit NULL
    if { $imgPlotType == "row" } {
	set xLabel "Column_Number"
    } else {
	set xLabel "Row_Number"
    }
    set yLabel "Counts"

    if { [winfo exist .pow.pow]!=1 } { 
	powInit .dummy
    }

    set cleanFileName [urlTail $fileName]
    set graphHandle ${cleanFileName}_[expr $chdu-1]_$gid

    eval powCreateCurve $graphHandle \
	x_$graphID "NULL" y_$graphID "NULL"

    if { $imgCurrgn && [powGetCurrentGraph]!="" } {
       powAddCurves [powGetCurrentGraph] $graphHandle
    } else {
       powCreateGraph $graphHandle $graphHandle NULL $xUnit $yUnit \
	     $xLabel $yLabel  \
	     [lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1]
    }
    incr gid
}

# Highlight the center

body FitsImage::showCell {col row} {
   if { $droot=="" || ![winfo exists $droot] } return
   if { [llength $dims]==1 } {
      # Swap col/row
      set tmp $col; set col $row; set row $tmp
   }
   jump [expr $row + $showRows/2]
   setHScroll [expr $col-$showCols/2-1]
   update idletask
   setStartMark [expr $col-$firstCol] [expr $numRows-$firstRow+1-$row]
}


##############################################
#
# Handle Reading/Writing/Formatting of Data
#

body FitsImage::writeTabData {col row val} {

   set tmpStr [string toupper [string trim $val " "]]

   if { $tmpStr == "NULL" } {

      # float and double do not need a BLANK key
      if { $imgNull == "NULL" && $imgType!=3 && $imgType!=4 } {
         error "\nNo NULL value is defined. Please write a\
               BLANK keyword in the header first."
      }
      set val "NULL"

   }

   putRawData $col $row $val
}

body FitsImage::readTabData {fCol fRow nCols nRows} {
   set fRow [expr $numRows - $fRow - $nRows + 1]
   incr fCol
   $fitsfileCmd load iblock "tabData" $fRow $nRows $fCol $nCols
}

body FitsImage::getFormattedData {col row} {
   set val [getRawData $col $row]
   if { $val=="NULL" } {
      return $val
   }
   return [format $imgForm $val]
}

body FitsImage::getRawData {col row} {
   set v $tabData($col,[expr $numRows-$row-1])
   if { $v!="NULL" } {
      if { $imgType==3 } {
         return [format "%.7G" $v]
      } elseif { $imgType==4 } {
         return [format "%.15G" $v]
      }
   }
   return $v
}

body FitsImage::putRawData {col row val} {
   set realRow [expr $numRows-$row-1]
   set firstElem [expr $realRow*$numCols+$col+1]
   $fFObj putImage $firstElem 1 [list $val]
   readTabData $col $row 1 1
}

body FitsImage::getRawDataBlock { fCol fRow lCol lRow } {
   # col/row zero-indexed

   set nElem [expr $lCol - $fCol + 1]
   for { set col 0 } { $col<$nElem } { incr col } {
      set colData($col) {}
   }

   set row $fRow
   for { set row $fRow } { $row <= $lRow } { incr row } {
      set realRow   [expr $numRows-$row-1]
      set firstElem [expr $realRow*$numCols+$fCol+1]
      set col 0
      foreach datum [$fitsfileCmd get image $firstElem $nElem] {
         lappend colData($col) $datum
         incr col
      }
   }

   set data {}
   for { set col 0 } { $col<$nElem } { incr col } {
      lappend data $colData($col)
   }

   return $data
}

body FitsImage::putRawDataBlock { fCol fRow data } {
   # col/row zero-indexed

   set nCols [llength $data]
   set nRows [llength [lindex $data 0]]

   for { set i 0 } { $i<$nRows } { incr i } {
      set rowData {}
      foreach cData $data {
         lappend rowData [lindex $cData $i]
      }
      set realRow   [expr $numRows-$fRow-1]
      set firstElem [expr $realRow*$numCols+$fCol+1]
      $fitsfileCmd put image $firstElem $nCols $rowData
      incr fRow
   }
}


#
#  End Data handlers
#
##############################################
