class fvApp {
   constructor {args} {}
   destructor {}

   public  method processOptions { opts }

   private method loadLibs { }
   private method setupColormap { }
   private method setupOptions { }
   private method setupBindings { }
   private method setupFont { }
   private method setupBackup { }

   private variable cmap 0
   private variable isAborting 0
   private variable modules {}
}

body fvApp::constructor {args} {
   global fvVersion
   global isWin isMac isQuiet
   global openDir isExitting plugin

   if { ![info exists plugin] } {
      wm withdraw .
   }
 
   set fvVersion 3.0
   setupOptions

   # Initialize preferences before searching through command-line options

   fvPreferences ::fvPref

   set unusedArgs [processOptions $args]
   if { $isAborting } {
      exitCmd
      return
   }

   loadLibs
   setupColormap

   if { $isMac } {
      BuildMacMenus
   }
   
   ###
   #   Build some global objects...
   ###

   fcb ::fvClipBoard
   fvWinKeeper ::.fvwinkeeper
   ffb ::.fD -title "fv: File Dialog"
   
   setupBackup
   setupBindings

   #####################

   # Initialize modules before opening any files

   foreach module $modules {
      set unusedArgs [eval ${module}::init $unusedArgs]
   }

   #####################
   #
   # unused Args should be nothing but file/directory names


    

   set optIdx [lsearch -glob $unusedArgs "-*"]
   if { $optIdx!=-1 } {
      puts "Unrecognized option [lindex $unusedArgs $optIdx]"
      processOptions -help
      set isAborting 0
      exitCmd
      return
   }
   set openDir {}

   if { [llength $unusedArgs] == 0 } {
      if { !$isQuiet } {
         selFile
      }
   } else {
      foreach filename $unusedArgs {
         openFile $filename
      }
      if { $openDir != {} } {
         selFile $openDir
      }
   }

}

body fvApp::destructor {} { 
   if { !$isAborting } {
      foreach module $modules {
         ${module}::release
      }
      delete object fvClipBoard
      delete object fvPref
      delete object .fvwinkeeper
      if { [winfo exists .fD] } {
         delete object .fD
      }
      destroy .dummy
      if { [winfo exists .pow] } {
         destroy .pow
      }
   }
   destroy .
   after idle exit
}

body fvApp::loadLibs { } {
   global isWin isMac
   global env plugin
   global FITSVIEWER_LIBRARY

   set FITSVIEWER_LIBRARY "$env(FITSVIEWER_LIBRARY)"

   if [info exists plugin] { 
      load "" fits
      load "" pow
   } elseif { $isWin } {
      set env(POW_LIBRARY) "$FITSVIEWER_LIBRARY/../pow"
      set env(POW_HELPDIR) $env(POW_LIBRARY)
      load fitstcl fits
      load powtcl  pow
   } elseif { $isMac } {
      set FITSVIEWER_LIBRARY "$env(FITSVIEWER_LIBRARY)"
      set env(POW_LIBRARY) "${FITSVIEWER_LIBRARY}::pow Sources"
      set env(POW_HELPDIR)  $env(POW_LIBRARY)
      load "" fits
      load "" pow
      console hide
      bind all <Command-Option-KeyPress-0> {console show}
      # Implement Drag-n-Drop file opens
      proc ::tkOpenDocument {args} {
         foreach elem $args {
            openFile $elem
         }
         if { [winfo ismapped .fD] } {
            wm withdraw .fD
         }
      }
   } else {
      if ![ info exist env(FV_ISEXEC) ] {
          set env(POW_LIBRARY) "$FITSVIEWER_LIBRARY/../pow"
          set  env(POW_HELPDIR) $env(POW_LIBRARY)
          load [glob $FITSVIEWER_LIBRARY/../libfitstcl.s\[ol\]*]
          load [glob $FITSVIEWER_LIBRARY/../libpow.s\[ol\]*]
      } else {
	  if ![info exist env(FV_HELPDIR)] {
	     set fullname [info nameofexecutable]
	     set abspath [file dirname $fullname]
	     set env(FV_HELPDIR) [file join $abspath doc]
          }
	  set env(POW_LIBRARY) "/"
          set  env(POW_HELPDIR) $env(FV_HELPDIR)
          #Initialize the pow (script part)
	  powInitGlobals
      }
   }

   # Turn on fitsTcl's WCS swap flag, which adds a parameter to 'get wcs'
   # indicating whether the RA/Dec keywords are swapped with X/Y
   fits option wcsSwap 1

   # Besides trying to load XPA, this forces the scripting code to be loaded
   fvXPA::init
}

body fvApp::setupColormap { } {
   global plugin

   if { [info exists plugin] } {
      set cmap 0
   } else {
      wm withdraw .
   }
   
   update idletask
   
   # try to avoid the flash. 
   powSetupColormap .dummy 6 $cmap
   wm withdraw .dummy
}

body fvApp::setupOptions { } {
   global hasSAOtng hasDS9
   global ftpID
   global httpID
   global listObjs
   global histoFileID
   global histoPlotId
   global isNewFile
   global lastEventWndw
   global fileselect
   global fitsFileMode
   global isExitting isQuiet
   global isScript
   global isWin isMac tcl_platform

   # setup the options
   option add *borderWidth 1
   option add *Button.takeFocus      0 startupFile
   option add *Checkbutton.takeFocus 0 startupFile
   option add *Scrollbar.takeFocus   0 startupFile
   
   #  Initialize Some Globals
   
   set ftpID         0
   set httpID        0
   set listObjs      {}
   set histoFileID   0
   set histoPlotId   0
   set isNewFile     0
   set lastEventWndw ""
   set fileselect    ""
   set fitsFileMode  0
   set isExitting    0
   set isQuiet       0
   set isScript      0
   
   if { $tcl_platform(platform) == "windows" } {
      set isWin 1
      set isMac 0
   } elseif { $tcl_platform(platform) == "macintosh" } {
      set isWin 0
      set isMac 1
   } else {
      set isWin 0
      set isMac 0
   }   

   setupFont
   
   #
   # check to see if there is SAOtng or DS9 and xpaset (with SAOtng)
   #
   
   #  Try to run saotng with a bogus flag and see if we get the expected
   #  error message including the substring "command-line"
   
   set hasSAOtng 0
   catch {exec saotng -test} result
   if { [string first command-line $result] != -1 } {

      #  Check for xpaset by seeing if it will dump the expected
      #  help text containing the substring "usage"
      catch {exec xpaset -h} result
      if {[string first usage $result] != -1} {
         set hasSAOtng 1
      }

   }
   
   set hasDS9 0
   catch {exec ds9 -help} result
   if { [string first " option" $result] != -1 } {

      #  Check for xpaset by seeing if it will dump the expected
      #  help text containing the substring "usage"
      catch {exec xpaset -h} result
      if {[string first usage $result] != -1} {
         set hasDS9 1
      }

   }
   
}

body fvApp::setupBindings { } {
   global isMac

   ##################################################
   #
   #     Create application-level bindings
   #
   ##################################################
   
   if { !$isMac } {
      # Implement all the necessary menu shortcuts
      
      bind all <Alt-KeyPress> {}
      event add <<Undo>>   <Control-Key-z>
      
      # File Menu
      event add <<NewFile>>     <Alt-Key-n>
      event add <<OpenFile>>    <Alt-Key-o>
      event add <<SaveFile>>    <Alt-Key-s>
      event add <<Export>>      <Alt-Key-h>
      event add <<RevertFile>>  <Alt-Key-r>
      event add <<CloseWindow>> <Alt-Key-w>
      event add <<Quit>>        <Alt-Key-q>
      bind Toplevel <<NewFile>>  createNewFITS
      bind Toplevel <<OpenFile>> selFile
      
      # Edit Menu
      event add <<Undo>>        <Alt-Key-z>
      event add <<Cut>>         <Alt-Key-x>
      event add <<Copy>>        <Alt-Key-c>
      event add <<Paste>>       <Alt-Key-v>
      
      event add <<AppendHDU>>   <Alt-Key-e>
   }
   
   bind . <<Quit>>      exitCmd
   bind . <<CheckExit>> checkForExit
}

body fvApp::setupFont { } {
    global charPix
    global isWin isMac

    if { $isWin } {
       font create titleFont -family Arial     -size -12
    } elseif { $isMac } {
       font create titleFont -family system    -size -12
    } else {
       font create titleFont -family Helvetica -size -12 -weight bold
    }
    font create entryFont -family Courier -size -12
    set charPix      [font measure entryFont m]

    # These lines guarantee that the default fonts are always loaded.
    entry .dummyFnt1
    entry .dummyFnt2 -font entryFont
    entry .dummyFnt3 -font titleFont
}

body fvApp::setupBackup { } {
   global backupDir env
   global isWin isMac

   # check if the backupDir exist 
   # read/write make a back up in ~/.fv (or fv_tmp for win32) dir or FVTMP dir
   
   if { $isWin } {
      set fvTmp "fv_tmp"
      set fvHOME FV_HOME
   } elseif { $isMac } {
      set fvTmp "fv_temp_folder"
      set fvHOME HOME
   } else {
      set fvTmp ".fv"
      set fvHOME HOME
   }
     
   if { ![info exist env(FVTMP)] } {
      if { ![info exist env($fvHOME)] } {
         error "Please set up your $fvHOME environment first"
         exit 
      } else {
         if { [file exist [file join $env($fvHOME) $fvTmp]] } {
	    file stat [file join $env($fvHOME) $fvTmp] fstat
	    if { $fstat(type) != "directory"} {
               puts "~/$fvTmp is not a directory, can not create back up files"
               exit
	    } 
         } else {
	    file mkdir [file join $env($fvHOME) $fvTmp]
         }	       
         set backupDir [file join $env($fvHOME) $fvTmp]
         if { ![catch {glob [file join $backupDir *]}] } {	
            promptMsg "There are files left in $backupDir \n \
                  (probably from a terminated fv session).\n Do you want to delete them ?"  \
                  cleanBackupDir Yes No       
         }
      }
   } else {
      set backupDir $env(FVTMP)
   }
   if { $isWin } {
      # Must change all \'s to /'s to avoid problems with escape chars
      regsub -all "\\\\" $backupDir "/" backupDir
   }
}


body fvApp::processOptions { opts } {
   global isQuiet

   set argc [llength $opts]
   set unusedArgs {}
   for {set i 0} {$i<$argc} {incr i} {
      switch -glob -- [lindex $opts $i] {
         "--help" -
          "-help" {
            puts "Usage: fv ?-cmap mode? ?-winmanager BOOL? ?-quiet? ?file?"
            puts "   -cmap <0-3>        Sets the colormap mode"
            puts "   -winmanager <1/0>  Turn Window manager On and Off"
            puts "   -quiet             Startup fv without open dialog and"
            puts "                      stay open even if all files are closed"
            puts "   -module modName    Load a web module into fv"
            set isAborting 1
         }
         "-cmap" {
            incr i
            if { $i==$argc } {
               # flag an "error" so that help message gets printed
               set cmap -1
            } else {
               set cmap [lindex $opts $i]
            }
            if { $cmap < 0 || $cmap > 3 } {
               puts "Usage: fv ?-cmap code? ?file?"
               puts "  code: 2 and 3 might eliminate color flash when\
                     you run out of color"
               puts "  0: Chose the best colormap"
               puts "  1: Force to install private pseudo colormap"
               puts "  2: Force to use truecolor colormap\
                     (if you don't have it will crash!)"
               puts "  3: Force to use screen default colormap"
               set isAborting 1
            }
   
         }
         "-winmanager" {
            incr i
            if { $i==$argc || ![string is boolean -strict [lindex $opts $i]] } {
               puts "Usage: fv ?-winmanager BOOL? ?file?"
               set isAborting 1
            } else {
               set ::fvPref::ifUseManager [lindex $opts $i]
            }
         }
         "-quiet" {
            set isQuiet 1
         }
         "-mod*" {
            incr i
            if { $i==$argc } {
               puts "Usage: fv ?-module moduleName?"
               set isAborting 1
            } else {
               set module [lindex $opts 1]
               set idx [lsearch $::fvPref::webModules $module]
               if { $idx==-1 } {
                  puts "Unrecognized module name"
                  set isAborting 1
               } else {
                  set url [lindex $::fvPref::webModulesURLs $idx]
                  loadTclCode $url tclIndex
                  lappend modules $module
               }
            }
         }
         default {
            lappend unusedArgs [lindex $opts $i]
         }
      }
   }
   return $unusedArgs
}
