#!/bin/sh
if [ $# -ne 2 ]
then
  echo Usage: $0 \"file pattern\" XxY
  echo Example: ms.sh \"*.jpg\" 1024x768
  exit
fi

declare -a iinfo
declare -a reqXY

# Get the desired newX
reqXY=( `echo $2 | sed 's/x/ /'` )
reqX=${reqXY[0]}
reqY=${reqXY[1]}

for f in $1 
do
  # Read the image info and store it in realX and realY
  iinfo=( `identify -format "%w %h" $f` ) 
  realX=${iinfo[0]}
  realY=${iinfo[1]}
  echo -n $f is $realX x $realY

  # If realX < realY then we need to swap newX with newY
  if [ "`expr $realX \> $realY`" = "0" ]
  then
    newX=$reqY
    newY=$reqX
  else
    newX=$reqX
    newY=$reqY
  fi

  echo " "and will be $newX"x"$newY 
  echo $f | awk '{print $1 " _" $1}' | xargs -l convert -scale $newX"x"$newY
done

