#!/usr/bin/env python
# vim:sw=4
    
import sys
sys.path.append('..')

import bonobo
import bonobo.ui
import gtk
import gaphor.config as config
import gaphor.ui.command as command
import gaphor.ui.command.file as command_file
import gaphor.ui.command.about as command_about
import gaphor.ui.command.diagram as command_diagram

GAPHOR_UI_XML = "gaphor-ui.xml"
#GAPHOR_UI_XML = "gaphorui.xml"

def show_nothing_dialog (widget):
    dialog = gtk.MessageDialog (widget,
                                gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
				gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
				'This does nothing; it is only a demonstration')
    dialog.run ()
    dialog.destroy ()
    
    
def hello_on_menu_help_about (uic, verbname, win):
    dialog = gtk.MessageDialog (win,
                                gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
				gtk.MESSAGE_INFO, gtk.BUTTONS_OK,
				'BonoboUI-Hello')
    dialog.run ()
    dialog.destroy ()    
    
def hello_on_button_click (w, label):
    text = label.get_text ()
    label.set_text (strreverse (text))

# These verb names are standard, see libonobobui/doc/std-ui.xml
# to find a list of standard verb names.
# The menu items are specified in Bonobo_Sample_Hello.xml and
#Insert given names which map to these verbs here.

class CommandExecuter(object):

    def __init__(self, command):
	self.command = command

    def __call__(self, uic, verbname, win):
	self.command.execute()

def insert_toggle(uic, verbname, win):
    print 'Path exists:', uic.path_exists('/commands/InsertDiagram')
    print 'get:', uic.get('/commands/InsertDiagram', True)
    try:
	if int(uic.get_prop('/commands/InsertDiagram', 'sensitive')):
	    uic.set_prop('/commands/InsertDiagram', 'sensitive', '0')
	else:
	    uic.set_prop('/commands/InsertDiagram', 'sensitive', '1')
    except RuntimeError:
	uic.set_prop('/commands/InsertDiagram', 'sensitive', '0')


hello_verbs = [
    ('FileNew',    CommandExecuter(command_file.NewCommand())),
    ('FileOpen',   CommandExecuter(command_file.OpenCommand())),
    ('FileSave',   CommandExecuter(command_file.SaveCommand())),
    ('FileSaveAs', CommandExecuter(command_file.SaveAsCommand())),
    #('FileClose',  hello_on_menu_file_close),
    ('FileExit',   CommandExecuter(command_file.QuitCommand())),
    ('HelpAbout',  CommandExecuter(command_about.AboutCommand())),
    ('InsertDiagram', CommandExecuter(command_diagram.CreateDiagramCommand())),
    ('InsertToggle', insert_toggle)
]
    
def hello_create_main_window ():
    window = bonobo.ui.Window ('gaphor', 'Gaphor v0.1.0')
    window.show_all ()

    ui_container = window.get_ui_container ()
    engine = window.get_ui_engine ()
    engine.config_set_path ('/gaphor/UIConfig/kvps')
    ui_component = bonobo.ui.Component ('main')
    ui_component.set_container (ui_container.corba_objref ())

    bonobo.ui.util_set_ui (ui_component, config.DATADIR,
                           GAPHOR_UI_XML,
		           'gaphor')
			   
    ui_component.add_verb_list (hello_verbs, window)
    return window

def delete_event_cb (window, event):
    return gtk.TRUE

def hello_new ():
    win = hello_create_main_window ()
    
    button = gtk.Button ()
    button.set_border_width (10)
    
    label = gtk.Label ('Hello World')
    button.add (label)
    button.connect ('clicked', hello_on_button_click, label)
    
    win.set_size_request (250, 350)
    win.set_resizable (gtk.TRUE)
    win.set_property ('allow-shrink', gtk.FALSE)
    
    frame = gtk.Frame ()
    frame.set_shadow_type (gtk.SHADOW_IN)
    frame.add (button)
    win.set_contents (frame)
    
    win.connect ('delete_event', delete_event_cb)
    
    return win

if __name__ == '__main__':
    app = hello_new ()
    app.show_all ()
    bonobo.main ()
