/*
Copyright (C) 2003 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include <math.h>
#include <stdio.h>

#include "gdis.h"
#include "coords.h"
#include "file.h"
#include "interface.h"

/* main structures */
extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

/* NB: property table is still assoc with model */
/* configs should link to relevant dialog & settings */
struct config_pak
{
gint id;
gchar *label;            /* tree label */
gpointer data;           /* computational code structure */
};

struct project_pak
{
gchar *label;          /* tree label */
gchar *path;           /* job directory */

GSList *models;        /* associated structures */
GSList *configs;       /* associated code configs */
};

/***************************/
/* destroy a configuration */
/***************************/
void project_config_free(gpointer data)
{
}

/**********************/
/* destroy a projects */
/**********************/
gpointer project_free(gpointer data)
{
struct project_pak *project = data;

g_free(project->label);
g_free(project->path);

/*
g_slist_free(project->models);
g_slist_free(project->configs);
*/
}

/************************/
/* create a new project */
/************************/
gpointer project_new(const gchar *label)
{
struct project_pak *project;

project = g_malloc(sizeof(struct project_pak));
sysenv.projects = g_slist_append(sysenv.projects, project);

project->path = NULL;
if (label)
  project->label = g_strdup(label);
else
  project->label = g_strdup("project x");

project->models = NULL;
project->configs = NULL;

return(project);
}

/***********************************/
/* create a new model in a project */
/***********************************/
gpointer project_model_new(gpointer data)
{
struct project_pak *project = data;
struct model_pak *model;

/* NB: too many things look at model_pak -> keep public */
model = g_malloc(sizeof(struct model_pak));
project->models = g_slist_append(project->models, model);

template_model(model);
model->project = project;

return(model);
}

/***********************************************/
/* create a new computional code configuration */
/***********************************************/
gpointer project_config_get(gint id, gpointer data)
{
gchar *label;
GSList *list;
struct config_pak *config;
struct project_pak *project = data;

g_assert(project != NULL);

/* search for pre-existing config */
for (list=project->configs ; list ; list=g_slist_next(list))
  {
  config = list->data;
  if (config->id == id)
    return(config);
  }

/* create new config */
switch (id)
  {
  case ABINIT:
    label = g_strdup("abinit");
    break;
  case CASTEP:
    label = g_strdup("castep");
    break;
  case GAMESS:
    label = g_strdup("gamess");
    break;
  case GAUSS:
    label = g_strdup("gaussian");
    break;
  case GULP:
    label = g_strdup("gulp");
    break;

  default:
    show_text(ERROR, "Unknown computational code.\n");
    return(NULL);
  }

config = g_malloc(sizeof(struct config_pak));
/* TODO - add using a sort */
project->configs = g_slist_prepend(project->configs, config);
config->id = id;
config->label = label;
config->data = NULL;

return(config);
}

/****************************************************/
/* extract a pointer to the nth model of a projects */
/****************************************************/
gpointer project_model_get(gint n, gpointer data)
{
struct project_pak *project = data;

return(g_slist_nth_data(project->models, n));
}

