#!/bin/bash

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#------------------------------------------------------------------
#--------------------------------JM Routoure-----------------------
#---------------------------------28/02/2000-----------------------
#------------------------------------------------------------------

if [ -z $1 ]; then
	echo "No sch file indicated"
	echo "usage:"
	echo "annotate file"
	echo "	file is generated by gschem"
	exit 1
fi 


# Determine the different refdes=?

list=`gawk '/^refdes=[A-Z]+\?/ {
		A=$1; gsub(/refdes=/,"",A)
		gsub(/\?/,"",A)
		print A}' $1 | sort | gawk 'BEGIN {if (NR==1) {A=$1} }{if (A !=$1) print ; A=$1}' - `


if [ -z "$list" ]; then
	echo "No new devices found!"
	exit 0
fi	

# make a copy of the current schematics

cp $1 $1.sauv

# Replace the ? by a number 

for f in  $list; do 
    # creation du script gawk 1 
    echo "BEGIN {R=0}" >sc.awk
    echo "/^refdes=$f[0-9]+/ {B=\$1" >>sc.awk
    echo "gsub(/refdes=[A-Z]+/,\"\",B)" >>sc.awk
    echo "if (B>R) {R=B}" >>sc.awk
    echo "}" >>sc.awk
    echo "END {printf(\"%d\",R)}" >>sc.awk
    # execution des scripts
    
    IMAX=`gawk -f sc.awk $1`
    echo "Numbering of $f will start at $IMAX"
    
    # creation du script gawk 2 
    
    echo "BEGIN {R=MAX} ">sc.awk
    echo "{if (match(\$1,/^refdes=$f\?/)!=0) {" >>sc.awk
    echo "R=R+1" >>sc.awk
    echo "sub(/\?/,R,\$1)" >>sc.awk
    echo "print \$1 } " >>sc.awk
    echo "else {print \$0}}">>sc.awk
    
    #echo "OK=1" >>sc.awk
    #echo "LL=NR}" >>sc.awk
    #echo "{" >>sc.awk
    #echo "if ((OK==1)&&(NR==LL+1)) {print \$1\" \"\$2\" \"\$3\" \"\$4\" \"\$5\" \"1\" \"\$7\" \"\$8 }" >>sc.awk
    #echo "if (NR==LL+2) {OK=0} " >>sc.awk
    #echo "if (OK==0) {print \$0} " >>sc.awk
    #echo "}" >>sc.awk
    
    #execute the second script
    
    cat $1 | gawk -v MAX=$IMAX -f sc.awk  - > $1.tmp
    mv $1.tmp $1
    
done
    
# clean !

if [ -e sc.awk ]; then
	rm sc.awk
fi	

