/****************************************************************************
** systime.h
**
** Michael S. Borella <mike@borella.net>
**
** Class definition for system time (wall clock time)
**
*****************************************************************************/

#ifndef SYSTIME_H
#define SYSTIME_H

#include <string>
#include <time.h>
#include <sys/time.h>
#include "eh_system.h"

//---------------------------------------------------------------------------
//
// class Systime
//
//---------------------------------------------------------------------------

class Systime
{
private:
  struct timeval _tv;   // Store absolute time here
  struct tm *    _tp;   // seconds since unix epoch, broken down (relative)
   
public:
  // Constructor and destructor
  Systime();
  ~Systime(){}

  // Operator overrides
  Systime& operator=(const Systime&);
  Systime operator-(const Systime);
  
  // Read the clock again
  void refresh() throw (EH_system);

  // functions to display the time
  int microseconds() { return _tv.tv_usec; }
  int seconds()      { return _tv.tv_sec; }
  int sec()          { return _tp->tm_sec; }
  int minute()       { return _tp->tm_min; }
  int hour()         { return _tp->tm_hour; }
  int year()         { return _tp->tm_year; }
  string hms();
  string month();
  string day();
  string unix_ctime();
};

#endif



