/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  keymapsignals.cc - Gdk::Keymap virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "keymap.hh"
#include "keymapsignals.hh"
#include "private/keymapclass.hh"

using namespace GFC;

/*  Gdk::KeymapSignals
 */

Gdk::KeymapSignals::KeymapSignals(Keymap *keymap)
: G::ObjectSignals(keymap)
{
	Gdk::KeymapClass::init(GDK_KEYMAP_GET_CLASS(keymap->gdk_keymap()));
}

Gdk::KeymapSignals::~KeymapSignals()
{
}

void
Gdk::KeymapSignals::on_direction_changed()
{
	GdkKeymapClass *g_class = KeymapClass::get_parent_class(instance_);
	if (g_class->direction_changed)
		g_class->direction_changed((GdkKeymap*)instance_);
}

void
Gdk::KeymapSignals::on_keys_changed()
{
	GdkKeymapClass *g_class = KeymapClass::get_parent_class(instance_);
	if (g_class->keys_changed)
		g_class->keys_changed((GdkKeymap*)instance_);
}

/*  Gdk::KeymapClass
 */

void
Gdk::KeymapClass::init(GdkKeymapClass *g_class)
{
	g_class->direction_changed = &direction_changed_proxy;
	g_class->keys_changed = &keys_changed_proxy;
}

GdkKeymapClass*
Gdk::KeymapClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GDK_KEYMAP_GET_CLASS(instance));
	return static_cast<GdkKeymapClass*>(ptr);
}

GType
Gdk::KeymapClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_KEYMAP);
	}
	return type;
}

void*
Gdk::KeymapClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gdk::KeymapClass::direction_changed_proxy(GdkKeymap *keymap)
{
	void *ptr = g_object_get_qdata((GObject*)keymap, G::ObjectSignals::quark());
	if (ptr)
		static_cast<KeymapSignals*>(ptr)->on_direction_changed();
	else
	{
		GdkKeymapClass *g_class = KeymapClass::get_parent_class(keymap);
		if (g_class->direction_changed)
			g_class->direction_changed(keymap);
	}
}

void
Gdk::KeymapClass::keys_changed_proxy(GdkKeymap *keymap)
{
	void *ptr = g_object_get_qdata((GObject*)keymap, G::ObjectSignals::quark());
	if (ptr)
		static_cast<KeymapSignals*>(ptr)->on_keys_changed();
	else
	{
		GdkKeymapClass *g_class = KeymapClass::get_parent_class(keymap);
		if (g_class->keys_changed)
			g_class->keys_changed(keymap);
	}
}

