/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  cellrenderertogglesignals.cc - Gtk::CellRendererToggle virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderertoggle.hh"
#include "cellrenderertogglesignals.hh"
#include "private/cellrenderertoggleclass.hh"

using namespace GFC;

/*  Gtk::CellRendererToggleSignals
 */

Gtk::CellRendererToggleSignals::CellRendererToggleSignals(CellRendererToggle *cell)
: CellRendererSignals(cell)
{
	Gtk::CellRendererToggleClass::init(GTK_CELL_RENDERER_TOGGLE_GET_CLASS(cell->gtk_cell_renderer_toggle()));
}

Gtk::CellRendererToggleSignals::~CellRendererToggleSignals()
{
}

void
Gtk::CellRendererToggleSignals::on_toggled(const String& path)
{
	GtkCellRendererToggleClass *g_class = CellRendererToggleClass::get_parent_class(instance_);
	if (g_class->toggled)
		g_class->toggled((GtkCellRendererToggle*)instance_, path.c_str());
}

/*  Gtk::CellRendererToggleClass
 */

void
Gtk::CellRendererToggleClass::init(GtkCellRendererToggleClass *g_class)
{
	g_class->toggled = &toggled_proxy;
}

GtkCellRendererToggleClass*
Gtk::CellRendererToggleClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_CELL_RENDERER_TOGGLE_GET_CLASS(instance));
	return static_cast<GtkCellRendererToggleClass*>(ptr);
}

GType
Gtk::CellRendererToggleClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER_TOGGLE);
	}
	return type;
}

void*
Gtk::CellRendererToggleClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CellRendererToggleClass::toggled_proxy(GtkCellRendererToggle *cell_renderer_toggle, const gchar *path)
{
	void *ptr = g_object_get_qdata((GObject*)cell_renderer_toggle, G::ObjectSignals::quark());
	if (ptr)
	{
		std::string tmp_path(path);
		static_cast<CellRendererToggleSignals*>(ptr)->on_toggled(tmp_path);
	}
	else
	{
		GtkCellRendererToggleClass *g_class = CellRendererToggleClass::get_parent_class(cell_renderer_toggle);
		if (g_class->toggled)
			g_class->toggled(cell_renderer_toggle, path);
	}
}

