/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  editablesignals.cc - Gtk::Editable virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "editable.hh"
#include "editablesignals.hh"
#include "private/editableclass.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Gtk::EditableSignals
 */

Gtk::EditableSignals::EditableSignals(Editable *editable)
{
	Gtk::EditableClass::init(GTK_EDITABLE_GET_CLASS(editable->gtk_editable()));
}
	
Gtk::EditableSignals::~EditableSignals()
{
}
	
void
Gtk::EditableSignals::on_insert_text(const String& text, int *position)
{
	GtkEditableClass *g_iface = EditableClass::get_parent_iface(instance_);
	if (g_iface->insert_text)
		g_iface->insert_text((GtkEditable*)instance_, text.c_str(), text.size(), position);
}

void
Gtk::EditableSignals::on_delete_text(int start_pos, int end_pos)
{
	GtkEditableClass *g_iface = EditableClass::get_parent_iface(instance_);
	if (g_iface->delete_text)
		g_iface->delete_text((GtkEditable*)instance_, start_pos, end_pos);
}

void
Gtk::EditableSignals::on_changed()
{
	GtkEditableClass *g_iface = EditableClass::get_parent_iface(instance_);
	if (g_iface->changed)
		g_iface->changed((GtkEditable*)instance_);
}

/*  Gtk::EditableClass
 */

void
Gtk::EditableClass::init(GtkEditableClass *g_iface)
{
	g_iface->insert_text = &insert_text_proxy;
	g_iface->delete_text = &delete_text_proxy;
	g_iface->changed = &changed_proxy;
}

GtkEditableClass*
Gtk::EditableClass::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(GTK_EDITABLE_GET_CLASS(instance));
	return static_cast<GtkEditableClass*>(ptr);
}

void
Gtk::EditableClass::insert_text_proxy(GtkEditable *editable, const gchar *text, gint length, gint *position)
{
	void *ptr = g_object_get_qdata((GObject*)editable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		std::string tmp_text(text, length);
		dynamic_cast<EditableSignals*>(object)->on_insert_text(tmp_text, position);
	}
	else
	{
		GtkEditableClass *g_iface = EditableClass::get_parent_iface(editable);
		if (g_iface->insert_text)
			g_iface->insert_text(editable, text, length, position);
	}
}

void
Gtk::EditableClass::delete_text_proxy(GtkEditable *editable, gint start_pos, gint end_pos)
{
	void *ptr = g_object_get_qdata((GObject*)editable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<EditableSignals*>(object)->on_delete_text(start_pos, end_pos);
	}
	else
	{
		GtkEditableClass *g_iface = EditableClass::get_parent_iface(editable);
		if (g_iface->delete_text)
			g_iface->delete_text(editable, start_pos, end_pos);
	}
}

void
Gtk::EditableClass::changed_proxy(GtkEditable *editable)
{
	void *ptr = g_object_get_qdata((GObject*)editable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<EditableSignals*>(object)->on_changed();
	}
	else
	{
		GtkEditableClass *g_iface = EditableClass::get_parent_iface(editable);
		if (g_iface->changed)
			g_iface->changed(editable);
	}
}

