/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 * Modified as per need by S.Ekanth <gfslicer@rediffmail.com>
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "interface.h"
#include "support.h"

#include "gfs_defs.h"
#include "gfs_conf.h"
#include "gfs_dnd.h"

gint delete_event (GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit ();
  return (FALSE);
}

int
main (int argc, char *argv[])
{
/*  GtkWidget *gfslicer;*/

  int i;

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  for (i = 1; i < argc; i++)
  {
    if ((!strcmp (argv[i], "--version")) || (!strcmp(argv[i], "-v")))
    {
      printf("Gnome File Slicer v%s", VERSION);
      printf("\nA cool file slicing and joining utility developed with gtk+ widgets.");
      printf("\nCopyright (c) 2000 Ekanth. <gfslicer@rediffmail.com>\n");
      exit(0);
    }
    else if ((!strcmp (argv[i], "--man")) || (!strcmp(argv[i], "-m")))
    {
      system("clear");
      printf("gfslicer(Gnome File Slicer) is a file slicing and deslicing utility.\n\n");
      printf("gfslicer provides the user with 4 options to work on.\n");
      printf("  1. Slice :\n");
      printf("\tThis option helps the user to split any given file into pieces of any desirable size. Invoke this slice window by clicking the slice button or using the menu option. Now select a file and choose a size. Check and then slice.\n");
      printf("  2. Deslice :\n");
      printf("\tThis option helps the user to join files sliced using gfslicer. This option can also be invoked as said above. Open the file with extension .b00 and re-check. This will check for the availability of all the pieces and size of the file. Now deslice the files to get the original file.\n");
      printf("  3. Tar :\n");
      printf("\tThis option helps to tar a folder. Accumulate all the files to be tar-red in a folder and select the folder in the tar dialog box. Now select the compression type to use and the output file name. Now click tar button.\n");
      printf("  4. Untar :\n");
      printf("\tThis option helps to untar a tar-red file. Select the compression type used before untar-ring. The user can select an output path for the untar-red files to be copied.\n");
      printf("\n  Copyright (c) 2000 Ekanth <gfslicer@rediffmail.com>\n\n");
      exit(0);
    }
  }


  gnome_init ("gfslicer", VERSION, argc, argv);
  
  gfs_conf_init ();


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  gfslicer = create_gfslicer ();
  gtk_widget_show (gfslicer);

  gfs_conf_copy (&temprefs, &prefs);

  gfs_dnd_init ();


  gtk_signal_connect (GTK_OBJECT (gfslicer), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);

  gtk_main ();
  return 0;

}

