/*
 * $Id: tx_stack.h,v 1.2 2003/09/17 17:44:11 hipnod Exp $
 *
 * Copyright (C) 2003 giFT project (gift.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */

#ifndef GIFT_GT_TX_STACK_H_
#define GIFT_GT_TX_STACK_H_

/*****************************************************************************/

struct gt_tx_stack;

typedef struct gt_tx_stack GtTxStack;

typedef void (*GtTxStackCleanup) (GtTxStack *stack, void *udata);

/*****************************************************************************/

GtTxStack     *gt_tx_stack_new          (TCPC *c, BOOL tx_deflated);
void           gt_tx_stack_free         (GtTxStack *stack);

void           gt_tx_stack_abort        (GtTxStack *stack);

void           gt_tx_stack_set_handler  (GtTxStack *stack,
                                         GtTxStackCleanup cleanup, 
                                         void *udata);

BOOL           gt_tx_stack_queue        (GtTxStack *stack, uint8_t *data,
                                         size_t len);

/* used by tx_link to send data on the connection...argh, i can't
 * come up with a good interface for this */
int            gt_tx_stack_send         (GtTxStack *stack, uint8_t *data,
                                         size_t len);

/* another hack to prevent passing the TCPC around */
input_id       gt_tx_stack_input_add     (GtTxStack *stack, InputCallback cb, 
                                          void *udata);

/*****************************************************************************/

#endif /* GIFT_GT_TX_STACK_H_ */
