/*
 * version 0.000000000001
 *
 * i might update the program when the guy who wrote x86info shows me the code
 * required in fetching the cpu speed only (cus i think it's a little to hard
 * on your system every x86info -mhz call).
 *
 */

#include <gkrellm/gkrellm.h>
#include "gkx86info.h"

#define	CONFIG_NAME	"gkx86info"
#define	STYLE_NAME	"gkx86info"

static Monitor	*monitor;
static Panel	*panel;
static Decal	*decal_text1;
static gchar	*info; 
static gint	style_id;
static FILE 	*x86info_pipe = 0;


static gint
panel_expose_event(GtkWidget *widget, GdkEventExpose *ev) {

	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
			ev->area.width, ev->area.height);
	return FALSE;
}


static void
update_plugin() {

	static gint	x_scroll, w;

	if (w == 0)
		w = gkrellm_chart_width();
	x_scroll = (x_scroll + 1) % (2 * w);
	
	// dont do it too much...
	if ((GK.timer_ticks % 10) != 0) return;

	info = estimate_MHz(1);

	decal_text1->x_off =
		(w - gdk_string_width(decal_text1->text_style.font, info)) / 2;
	if (decal_text1->x_off < 0)
		decal_text1->x_off = 0;

	gkrellm_draw_decal_text(panel, decal_text1, info, w - x_scroll);
	gkrellm_draw_panel_layers(panel);

	// malloc'd it from estimate_MHz();
	free(info);
}


static void
create_plugin(GtkWidget *vbox, gint first_create) {

	Style			*style;
	TextStyle		*ts, *ts_alt;

	if (first_create)
		panel = gkrellm_panel_new0();

	style = gkrellm_meter_style(style_id);

	ts = gkrellm_meter_textstyle(style_id);
	ts_alt = gkrellm_meter_alt_textstyle(style_id);

	decal_text1 = gkrellm_create_decal_text(panel, "Ay", ts, style, -1, -1, -1);



	gkrellm_panel_configure(panel, NULL, style);
	gkrellm_panel_create(vbox, monitor, panel);


	if (first_create)
	    gtk_signal_connect(GTK_OBJECT (panel->drawing_area), "expose_event",
    	        (GtkSignalFunc) panel_expose_event, NULL);
}


static Monitor	plugin_mon = {

	CONFIG_NAME,		/* Name, for config tab.    */
	0,			/* Id,  0 if a plugin       */
	create_plugin,		/* The create function      */
	update_plugin,		/* The update function      */
	NULL,			/* The config tab create function   */
	NULL,			/* Apply the config function        */

	NULL,			/* Save user config			*/
	NULL,			/* Load user config			*/
	NULL,			/* config keyword			*/

	NULL,			/* Undefined 2	*/
	NULL,			/* Undefined 1	*/
	NULL,			/* private		*/

	MON_INSERT_AFTER|MON_CPU,	/* Insert plugin before this monitor			*/

	NULL,			/* Handle if a plugin, filled in by GKrellM     */
	NULL			/* path if a plugin, filled in by GKrellM       */
};


Monitor *
init_plugin() {

	style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME);
	monitor = &plugin_mon;
	return &plugin_mon;
}
