// $Id: WidgetFile.cc,v 1.17 2003/01/06 07:27:13 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2001 Adolf Petig GmbH & Co. KG
 *  written by Christof Petig and Malte Thoma
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <WidgetFile.hh>
#include <Configuration.hh>
#include <string>
#include <unistd.h>

WidgetFile::WidgetFile(const Widget &w,File_type tp) 
        : CxxFile(Configuration.FileName(w.Name(),tp,File_NOREPLACE).c_str()),
          top(w.getTagPtr()), _type(tp), has_requirements(false)
{  
}

void WidgetFile::open(const Widget &w,File_type tp) 
{  CxxFile::open(Configuration.FileName(w.Name(),tp,File_NOREPLACE).c_str());
   top=w.getTagPtr();
   _type=tp;
}
                                           
const std::string WidgetFile::FileName(File_type tp,int flags)
{  return Configuration.FileName(Widget(*top).Name(),tp,flags);
}

void WidgetFile::close()
{ CxxFile::close();
  unsigned int end_laenge = Configuration.template_postfix.size() ; 
  if ( _type==File_FOO_GLADE_HH || 
       _type==File_FOO_GLADE_CC ||
       _type==File_SUPPORT_CC ||
       _type==File_SUPPORT_CC )
   {  std::string filename_new = SystemFile::FileName();
      std::string filename_old = FileName(0);
      if (filename_new!=filename_old)
#ifndef __MINGW32__      
      {  // ignore timestamp, version and command line differences
         std::string syscall_d ="diff -q "
         // don't ask me why '.+' does no longer work ...
         		"-I '^// generated ' "
      			"-I '^// using glademm V' "
      			"-I '^// .*glade-- ' "
      			"-I '^// for gtk .* and gtkmm ' "
   			+filename_new +" "+filename_old;
   	 if (!Configuration.debug) syscall_d +=" >/dev/null";
         int changed = system(syscall_d.c_str());
         if (changed) 
         {  if (Configuration.debug)
            {  std::cout << syscall_d << " returned " << changed << '\n';
               system(("mv "+filename_old +" "+filename_old+".bak").c_str());
            }
            system(("mv "+filename_new +" "+filename_old).c_str());
         }
         else
         {  unlink(filename_new.c_str()); 
         }
      }
#else // ugly ... but better than nothing
      {  system(("copy "+filename_new +" "+filename_old).c_str());
         unlink(filename_new.c_str()); 
      }
#endif      
   }
}
