// $Id: menuitem.cc,v 1.39 2003/04/01 11:45:08 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2002 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "menuitem.hh"

static Gtk_MenuItem Gtk_MenuItem(false);

const std::string Gtk_MenuItem::TypeName(const Widget &w) const
{  return GtkPrefix()+"MenuItem";
}

const std::string Gtk_MenuItem::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"menuitem.h";
}

Gtk_MenuItem::Gtk_MenuItem(bool base_class_init)
{  if (!base_class_init) 
   {  Writer["GtkMenuItem"]=this;
      Writer["GtkSeparatorMenuItem"]=this;
   }
}

void Gtk_MenuItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg(); 
   if(w.hasProperty("label"))
      f << Configuration.Translatable(w.getProperty("label"));
}

bool Gtk_MenuItem::NeedExplicitCtor(const Widget &w) const
{  return w.hasProperty("label"); }

void Gtk_MenuItem::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{
  // Parent's AddChild() (i.e. the one for Menu/MenuBar) also adds menu 
  // item children.
}

void Gtk_MenuItem::CreatePointer(const Widget &w, CxxFile &f) const
{
  /* Note: We only declare necessary variables and initialise to NULL,
           Gtk_Menu::PushMenuItem creates the actual widget. */
  if (w.getProperty("cxx_visibility","private")=="private" && CanBeManaged(w))
     f.Declaration() << TypeName(w) << " *";
   else
     f.Statement();

  f << Configuration.InstanceName(w.Name());
  f.Assignment() << "NULL";
  f.EndLine();
  
  if(CanBeManaged(w)) w.markManaged();
  
  CreatePointer_Toplevel(w,f);
}

void Gtk_MenuItem::MenuElemCreation(const Widget &w, CxxFile &f) const
{  f.FunctionName() << MenuElemName(w);
   MenuElemArgs(w,f);
}

std::string Gtk_MenuItem::MenuElemName(const Widget &w) const
{  if (w.hasProperty("label")) return MenuElemPrefix()+"MenuElem";
   else return MenuElemPrefix()+"SeparatorElem";
}

void Gtk_MenuItem::MenuElemArgs0(const Widget &w, CxxFile &f) const
{  if (w.hasProperty("label"))
   {  f.FunctionArg() << Configuration.Translatable(w.getProperty("label"));

      std::string accel;
      /* Convert accelerator spec to parseable string. May actually have
	 passed something like mods|key directly instead, but this allows
	 accelerators to be localized. */
      if (Configuration.has_accelerators && w.get_Accels()!=w.end())
      { for (Widget::const_iterator i=w.get_Accels();i!=w.end();++i) {
	 std::string mods=i->getGladeAttr("modifiers");
	std::string key=i->getGladeAttr("key");

	erase_all(key,"GDK_");
	erase_all(key," ");
	if (GTKMM1)
       { // Remove some unwanted text from strings. *** Is there a standard
	  // function/method that will erase all occurences of a substring?

	  erase_all(mods,"GDK_");
	  erase_all(mods,"_MASK");
	  erase_all(mods," ");
	  erase_all(mods,"0");
	  
	  for(std::string::size_type modEnd=mods.find("|"); !mods.empty();
	      modEnd=mods.find("|")) {
	    std::string mod(mods, 0, modEnd);

	    mods=mods.substr(mod.size()); // Remove mod and '|' !
	    if (!mods.empty() && mods[0]=='|') mods=mods.substr(1);
	    
	    for(std::string::iterator p=mod.begin()+1; p!=mod.end(); p++)
	      *p=tolower(*p);

	    accel+="<" + mod + ">";
	  }
	  if(key.size()==1)
	    accel+=toupper(key[0]);
	  else
	    accel+=key;
	  // or translatable?
          f.FunctionArg() << Configuration.CString_WithQuotes(accel);
       }
       else // GTKMM2
       {  replace_all(mods,"GDK_","Gdk::");
          if (mods=="0") mods="Gdk::ModifierType(0)";
          f.FunctionArg() << "Gtk::Menu_Helpers::AccelKey(GDK_" << key 
          	<< ", " << mods << ")";
       }
      }
      }
   }
   else f.FunctionArg();
}

void Gtk_MenuItem::MenuElemArgsSub(const Widget &w, CxxFile &f) const
{  // does not work, TODO: explain why [gtkmm callbacks are different from gtk?]
      //   f.FunctionArg() << callback;
   // as of 2.0 it should work but is it worth to code it that way?
   // our delayed connection is more flexible and should not be slower
   if(w.hasChildren())
   {  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      {  if (Widget(*i).Class()=="GtkMenu") f.FunctionArg() << Reference(*i);
         else if (Widget(*i).Class()!="GtkImage")
            std::cerr << "Gtk_MenuItem "<< w.Name()<<": strange child type "
            	<<Widget(*i).Class()<<'\n';
      }
   }
}

void Gtk_MenuItem::MenuElemArgs(const Widget &w, CxxFile &f) const
{  MenuElemArgs0(w,f);
   MenuElemArgsSub(w,f);
}
