/******************************************************************************\
 gnofin/account.h   $Revision: 1.8 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef ACCOUNT_H
#define ACCOUNT_H

#include "bankbook.h"
#include "record-select.h"

struct _Account
{
  guint     ref_count;
  Bankbook *parent;
  GList    *records;
  gchar    *name;
  gchar    *notes;
  money_t   overall_bal;
  money_t   cleared_bal;
  guint     sort_field;
  guint	    sort_rev : 1;
  guint     foreign  : 1;   /* transfers use exchange_rate if foreign */
  RecordSelect records_select; /* It's a object who permit to choose if a record need to be view, selected, save ... */
};

Account     *get_account_by_name         (GList *accounts, const gchar *name);

guint        account_info_copy           (AccountInfo *dest, const AccountInfo *src, guint mask);
void         account_info_clear          (AccountInfo *, guint mask);
gboolean     account_info_diff           (const AccountInfo *, const AccountInfo *, guint mask);

Account     *account_new                 (void);
void         account_ref                 (Account *);
void         account_unref               (Account *);
void         account_destroy             (Account *);
gboolean     account_attach              (Account *, Bankbook *parent, gboolean full);
void         account_detach              (Account *, gboolean full);
gboolean     account_set_info            (Account *, guint mask, const AccountInfo *);
void         account_get_info            (const Account *, guint mask, AccountInfo *);
void         account_sort_records        (Account *, guint sort_by_field, gboolean sort_descending);
GCompareFunc account_get_record_sort_fcn (const Account *);
void         account_recompute_bal       (Account *, guint start_from);
gint         account_index               (const Account *);
void         account_dump                (const Account *);

#endif
