/******************************************************************************\
 gnofin/record.h   $Revision: 1.9 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef RECORD_H
#define RECORD_H

#include "bankbook.h"
#include "account.h"
#include "record-type.h"

typedef struct
{
  /* These are only valid if the record does not have
   * the link_broken flag set, otherwise their values
   * should be considered undefined. */
  Account *acc;
  Record  *rec;

  /* This is always valid, provided the record's type
   * has the linked flag set. */
  CachedString *acc_name;

} RecordLink;

struct _Record
{
  guint         ref_count;
  Account      *parent;
  RecordType   *type;
  GDate         date;
  guint         number;
  RecordLink    link;
  CachedString *category;
  CachedString *payee;
  CachedString *memo;
  money_t       amount;
  money_t       overall_bal;
  money_t       cleared_bal;
  gfloat        exchange_rate;
  guint         cleared     : 1;
  guint         link_broken : 1;
};

guint     record_info_copy       (RecordInfo *dest, const RecordInfo *src, guint mask);
void      record_info_clear      (RecordInfo *, guint mask);
gboolean  record_info_diff       (const RecordInfo *, const RecordInfo *, guint mask);

Record   *record_new             (void);
Record   *record_copy            (const Record *);

void      record_ref             (Record *);
void      record_unref           (Record *);
void      record_destroy         (Record *);

gboolean  record_attach          (Record *, Account *parent);
gboolean  record_attach_children (Record *);
void      record_detach          (Record *, gboolean full);
void      record_detach_children (Record *);

void      record_realize_link    (Record *);
void      record_break_link      (Record *);
void      record_unbreak_link    (Record *);

gboolean  record_set_info        (Record *, guint mask, const RecordInfo *);
void      record_get_info        (const Record *, guint mask, RecordInfo *);

guint     record_number          (const Record *);
money_t   record_amount          (const Record *);
Account  *record_linked_acc      (const Record *);
gchar    *record_linked_acc_name (const Record *);
Record   *record_linked_rec      (const Record *);
gint      record_index           (const Record *);

void      record_dump            (const Record *);

#endif
