/******************************************************************************\
 gnofin/gnofin-api.h   $Revision: 1.8 $
 Copyright (C) 2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef GNOFIN_API_H
#define GNOFIN_API_H

/* Plugins can query the API version from Gnofin to determine if
 * it exports a compatible interface.  This allows 3rd party
 * plugins to exist on an independent development cycle.
 *
 * The major API version number indicates the data structure
 * alignments.  The minor API version number indicates the
 * possible addition of API functions.  Hence, if Gnofin reports 
 * its API version as 1.3, and a plugin was built against 1.1,
 * the plugin can be sure to work properly.  However, a plugin
 * built against say an API version of 1.4 can not be sure to
 * work properly as there may be undefined functions.
 *
 * The API in question is defined by all headers file enclosed by:
 * 
 *    GNOFIN_API_BEGIN
 *    ...
 *    
 *    GNOFIN_API_END
 *
 * Plugins should consider all other header files "private" and
 * hence subject to change.
 */

/* Version History
 * ---------------
 *   4.0 - Support for broken links     (Feb 26 2000)
 *   4.1 - Addition of merging API      (Feb 29 2000)
 *   4.2 - Addition of batch_mode stubs (Feb 29 2000)
 */

#ifdef __cplusplus
# define GNOFIN_API_BEGIN extern "C" {
# define GNOFIN_API_END }
#else
# define GNOFIN_API_BEGIN
# define GNOFIN_API_END
#endif

GNOFIN_API_BEGIN

#define GNOFIN_API_VERSION_MAJOR 4
#define GNOFIN_API_VERSION_MINOR 2

void gnofin_api_version_get (guint *major, guint *minor);

GNOFIN_API_END

#endif
