/******************************************************************************\
 gnofin/notification-list.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include "notification-list.h"

typedef struct {
  NotificationFunc func;
  gpointer         data;
} Listener;

static gint
match_listener (const Listener *listener, NotificationFunc func)
{
  return (listener->func != func);  /* return 0 if equal */
}

void
notification_list_add (NotificationList *list, NotificationFunc func, gpointer data)
{
  Listener *listener;

  trace ("");
  g_return_if_fail (list);
  g_return_if_fail (func);
  g_return_if_fail (data);

  listener = g_new (Listener, 1);
  listener->func = func;
  listener->data = data;

  list->listeners = g_slist_prepend (list->listeners, listener);
}

void
notification_list_remove (NotificationList *list, NotificationFunc func)
{
  Listener *listener;

  trace ("");
  g_return_if_fail (list);
  g_return_if_fail (func);

  listener = (Listener *)
    g_slist_find_custom (list->listeners, func, (GCompareFunc) match_listener);
  if (listener)
  {
    list->listeners = g_slist_remove (list->listeners, listener);
    g_free (listener);
  }
}

void
notification_list_notify (NotificationList *list)
{
  GSList *node;

  trace ("");
  g_return_if_fail (list);

  for (node=list->listeners; node; node=node->next)
  {
    Listener *listener = LIST_DEREF (Listener, node);
    listener->func (listener->data);
  }
}
