/******************************************************************************\
 gnofin/numeric-parser.h   $Revision: 1.6 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef NUMERIC_PARSER_H
#define NUMERIC_PARSER_H

GNOFIN_API_BEGIN

/* This file contains prototypes for simple numeric parsers.
 */

gboolean int_parse   (const gchar *text, gint *val);
gboolean uint_parse  (const gchar *text, guint *val);
gboolean float_parse (const gchar *text, gfloat *val);

#ifdef G_HAVE_GINT64
gboolean int64_parse (const gchar *text, gint64 *val);
#endif

GNOFIN_API_END

#endif
