#include "common.h"
#include "tool.h"

/******************************************************************************/

static guint tool_stamp = 0;
static GSList *tools = NULL;

/******************************************************************************/

gboolean
tool_register (Tool *tool)
{
  trace ("");
  g_return_val_if_fail (tool, FALSE);

  tools = g_slist_append (tools, tool);
  if (tool->funcs.init)
    tool->funcs.init (tool->private_data);
  tool_stamp++;
  return TRUE;
}

void
tool_unregister (Tool *tool)
{
  trace ("");
  g_return_if_fail (tool);
  
  tools = g_slist_remove (tools, tool);
  if (tool->funcs.cleanup)
    tool->funcs.cleanup (tool->private_data);
  tool_stamp++;
}

GSList *
tools_get (guint *stamp)
{
  trace ("");
  if (stamp) *stamp = tool_stamp;
  return tools;
}

gboolean
tools_changed (guint stamp)
{
  trace ("");
  return tool_stamp != stamp;
}
