/******************************************************************************\
 gnofin/ui-statusbar.c   $Revision: 1.4 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <gtk/gtkframe.h>
#include <gtk/gtkeventbox.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>
#include <libgnomeui/gnome-appbar.h>
#include "ui.h"
#include "ui-menubar.h"
#include "ui-statusbar.h"
#include "money.h"


/******************************************************************************
 * Interface functions
 */

UI_Statusbar *
ui_statusbar_create (UI *ui)
{
  UI_Statusbar *status;
  GtkWidget *label, *hbox, *frame, *eventbox;
  GtkTooltips *tips;

  trace ("");
  g_return_val_if_fail (ui, NULL);

  status = g_new0 (UI_Statusbar, 1);
  status->ui = ui;

  status->appbar =
    GNOME_APPBAR (gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_NEVER));

  tips = gtk_tooltips_new ();

  /* Overall balance indicator */
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_box_pack_end (GTK_BOX (status->appbar), frame, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 8);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  
  label = gtk_label_new (_("Balance:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  eventbox = gtk_event_box_new ();
  gtk_box_pack_start (GTK_BOX (hbox), eventbox, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tips, eventbox, _("Cleared Balance"), NULL);

  label = gtk_label_new ("0.00");
  gtk_container_add (GTK_CONTAINER (eventbox), label);
  status->cleared_bal = GTK_LABEL (label);

  eventbox = gtk_event_box_new ();
  gtk_box_pack_start (GTK_BOX (hbox), eventbox, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tips, eventbox, _("Overall Balance"), NULL);

  label = gtk_label_new ("0.00");
  gtk_container_add (GTK_CONTAINER (eventbox), label);
  status->overall_bal = GTK_LABEL (label);

#if 0
  /* Cleared balance indicator */
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
  gtk_box_pack_end (GTK_BOX (status->appbar), frame, FALSE, FALSE, 0);
  
  label = gtk_label_new ("Clear  456.71");
  gtk_container_add (GTK_CONTAINER (frame), label);
  status->cleared_bal = GTK_LABEL (label);
#endif

  /* Attach statusbar to app window */
  gtk_widget_show_all (GTK_WIDGET (status->appbar));
  gnome_app_set_statusbar (GNOME_APP (ui->app), GTK_WIDGET (status->appbar));

  return status;
}

void
ui_statusbar_set_cleared_bal (UI_Statusbar *status, money_t value)
{
  gchar *buf;

  trace ("");
  g_return_if_fail (status);

  buf = money_stringize (NULL, 0, value);
  //gtk_label_set_text (status->cleared_bal, "");
  gtk_label_set_text (status->cleared_bal, buf);
  g_free (buf);
}

void
ui_statusbar_set_overall_bal (UI_Statusbar *status, money_t value)
{
  gchar *buf;

  trace ("");
  g_return_if_fail (status);

  buf = money_stringize (NULL, 0, value);
  //gtk_label_set_text (status->overall_bal, "");
  gtk_label_set_text (status->overall_bal, buf);
  g_free (buf);
}
