%define name    gnoise
%define version 0.1.15
%define release 1
%define prefix  /usr

Summary: Sound wave editor

Name:           %{name}
Version:        %{version}
Release:        %{release}
Copyright:      GPL
Group:          Applications/Multimedia
URL:            http://gnoise.sourceforge.net

Source:         %{name}-%{version}.tar.gz
Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root
Prefix:         %{prefix}
Requires:       gtk+ >= 1.2.0

%description
GNoise is a GTK+ based wave file editor. It uses a display cache and a
double-buffered display for maximum speed with large files. It supports
common editing functions such as cut, copy, paste, fade in/out, reverse,
interpolate, normalize and more with unlimited undo.

%prep
%setup -q -n %{name}-%{version}
if [ -f configure ]; then
        CFLAGS=$RPM_OPT_FLAGS \
        ./configure --prefix=%{prefix};
else
        CFLAGS=$RPM_OPT_FLAGS \
        ./autogen.sh --prefix=%{prefix};
fi

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix}
gmake

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip

%files

%defattr (0555, bin, bin)
%{prefix}/bin/gnoise

%doc NEWS README TODO ChangeLog

%defattr (-, root, root)
%{prefix}/share/gnome/apps/Multimedia/gnoise.desktop
%{prefix}/share/pixmaps/gnoise.png

%clean
rm -r $RPM_BUILD_ROOT
