/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dlgselection.c,v 1.5 2001/02/24 02:42:35 dengen Exp $
 *
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include "gnoise.h"
#include "gtkwaveset.h"

static GtkWidget *win_selection	= NULL;

void on_dlgselection(GtkMenuItem *menuitem, gpointer user_data)
{
    GtkWaveSet *ws;
    if ((!file_open) || (win_selection != NULL))
	return;

    ws = GTK_WAVE_SET(user_data);
    win_selection = create_SelectionDialog();
    gtk_signal_connect(GTK_OBJECT(lookup_widget(win_selection, "SelectionSet")),
		       "clicked", GTK_SIGNAL_FUNC (on_dlgselection_set),
		       ws);

    gtk_widget_show(win_selection);
    queue_cmd(CMD_SELECTION_DIALOG_UPDATE, NULL);
}

gboolean on_dlgselection_destroy(GtkWidget	*widget, GdkEvent *event,
				     gpointer user_data)
{
    win_selection = NULL;
    return FALSE;
}

void on_dlgselection_set(GtkButton *button, gpointer user_data)
{
    GtkWaveSet *ws = GTK_WAVE_SET(user_data);
    GtkSpinButton *SpinBtn;
    char sb_name[80];
    int channel;
    guint32 start;
    guint32 end;
    
    if (!file_open || !ws)
	return;

    /* FIXME: reference to global ws */
    for (channel = 0; channel < ws->sb->info.channels; channel++)
    {
	// Get start
	sprintf(sb_name, "StartSB%2.2d", channel);
	SpinBtn = GTK_SPIN_BUTTON(lookup_widget(win_selection, sb_name));
	start = gtk_spin_button_get_value_as_int(SpinBtn);

	// Get end
	sprintf(sb_name, "EndSB%2.2d", channel);
	SpinBtn = GTK_SPIN_BUTTON(lookup_widget(win_selection, sb_name));
	end = gtk_spin_button_get_value_as_int(SpinBtn);

	gtk_wave_set_selection_set(ws, start, end, channel);
    }
    dlgselection_update(ws);
}

void on_dlgselection_close(GtkButton *button, gpointer user_data)
{
    if (win_selection)
	gtk_widget_destroy(win_selection);
    win_selection = NULL;
}

void dlgselection_update(GtkWaveSet *ws)
{
    if (win_selection)
    {
	int channel;
	char widget_name[80];
	char display_fmt[80];
	GtkSpinButton *SpinBtn;
	GtkLabel *Label;

	for (channel = 0; channel < ws->sb->info.channels; channel++)
	{
	    smpl_indx smpls;

	    /* get start */
	    sprintf(widget_name, "StartSB%2.2d", channel);
	    SpinBtn = GTK_SPIN_BUTTON(lookup_widget(win_selection, widget_name));
	    gtk_spin_button_set_value(SpinBtn, ws->wd[channel]->selection_start);

	    sprintf(widget_name, "StartLbl%2.2d", channel);
	    Label = GTK_LABEL(lookup_widget(win_selection, widget_name));
	    sample_fmt(SMPL_FMT_PREFS, ws->wd[channel]->selection_start,
		       &ws->sb->info, display_fmt, sizeof(display_fmt));
	    gtk_label_set_text(Label, display_fmt);


	    /* get end */
	    sprintf(widget_name, "EndSB%2.2d", channel);
	    SpinBtn = GTK_SPIN_BUTTON(lookup_widget(win_selection, widget_name));
	    gtk_spin_button_set_value(SpinBtn, ws->wd[channel]->selection_end);

	    sprintf(widget_name, "EndLbl%2.2d", channel);
	    Label = GTK_LABEL(lookup_widget(win_selection, widget_name));
	    sample_fmt(SMPL_FMT_PREFS, ws->wd[channel]->selection_end,
		       &ws->sb->info, display_fmt, sizeof(display_fmt));
	    gtk_label_set_text(Label, display_fmt);


	    /* sums */
	    if (ws->wd[channel]->selection_end != -1 &&
		ws->wd[channel]->selection_start != -1)
	    {
        	smpls = ws->wd[channel]->selection_end -
			ws->wd[channel]->selection_start + 1;
		sprintf(widget_name, "SampleSumLbl%2.2d", channel);
		Label = GTK_LABEL(lookup_widget(win_selection, widget_name));
		sprintf(display_fmt, "%d", smpls);
		gtk_label_set_text(Label, display_fmt);

		sprintf(widget_name, "DisplaySumLbl%2.2d", channel);
		Label = GTK_LABEL(lookup_widget(win_selection, widget_name));
		sample_fmt(SMPL_FMT_PREFS, smpls,
		   	&ws->sb->info, display_fmt, sizeof(display_fmt));
		gtk_label_set_text(Label, display_fmt);
	    }
	}
    }
}
