/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtkwaveset.h,v 1.6 2002/01/13 02:51:16 dengen Exp $
 *
 */

#ifndef __GTK_WAVE_SET_H__
#define __GTK_WAVE_SET_H__

#include <gdk/gdk.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkvbox.h>
#include <X11/cursorfont.h>
#include "gnoise.h"
#include "gtkwavedisplay.h"

#define GTK_TYPE_WAVE_SET            (gtk_wave_set_get_type ())
#define GTK_WAVE_SET(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_WAVE_SET, GtkWaveSet))
#define GTK_WAVE_SET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_WAVE_SET, GtkWaveSetClass))
#define GTK_IS_WAVE_SET(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_WAVE_SET))
#define GTK_IS_WAVE_SET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_WAVE_SET))

#define CURSOR_NORMAL XC_xterm
#define CURSOR_SELEXT XC_sb_h_double_arrow

typedef struct _GtkWaveSet       GtkWaveSet;
typedef struct _GtkWaveSetClass  GtkWaveSetClass;

typedef enum
{
    SELECTING_NOTHING,
    SELECTING_START,
    SELECTING_END,
    SELECTING_NEW
} selecting_t;

struct _GtkWaveSet
{
    GtkVBox          widget;
    GtkWidget       *eventbox;
    GtkWidget       *wdvbox;
    GtkWidget       *scrollbar;
    GtkWaveDisplay  *wd[MAX_CHANNELS];
    snd_buf_t       *sb;		/* sound buffer to display */
    gint8            zoom;		/* 1<<zoom == zoom ratio */
    smpl_indx        win_frst;		/* first sample shown in window */
    smpl_indx        win_size;		/* length in samples shown in window */

    gboolean         selection_bond;	/* select all channels together */
    gboolean         just_clicked;
    selecting_t      selecting;		/* what is being selected */

};

struct _GtkWaveSetClass
{
    GtkVBoxClass     parent_class;
    GdkCursor       *cursor_selext;	/* selection extend cursor */
    GdkCursor       *cursor_normal;	/* normal i-beam cursor */
};

GtkType      gtk_wave_set_get_type       (void);
GtkWidget   *gtk_wave_set_new            (void);
void         gtk_wave_set_snd_attach     (GtkWaveSet *ws, snd_buf_t *);
void         gtk_wave_set_snd_detach     (GtkWaveSet *ws);
void         gtk_wave_set_zoom           (GtkWaveSet *ws, gboolean in);
void         gtk_wave_set_zoom_out_full  (GtkWaveSet *ws, gboolean redraw);
void         gtk_wave_set_zoom_selection (GtkWaveSet *ws);
void         gtk_wave_set_win_set        (GtkWaveSet *ws, smpl_indx frst, gboolean sbadjust);
void         gtk_wave_set_marker_add     (GtkWaveSet *ws, smpl_indx smp);
void         gtk_wave_set_marker_del_all (GtkWaveSet *ws);
void         gtk_wave_set_marker_del_sel (GtkWaveSet *ws);
void         gtk_wave_set_marker_del_cur (GtkWaveSet *ws);
void         gtk_wave_set_marker_set_cur (GtkWaveSet *ws, gboolean next);
void         gtk_wave_set_play_set       (GtkWaveSet *ws, smpl_indx smp);
void         gtk_wave_set_redraw_area    (GtkWaveSet *ws, smpl_indx start, smpl_indx end, chnl_indx channel);
void         gtk_wave_set_selection_set  (GtkWaveSet *ws, smpl_indx start, smpl_indx end, chnl_indx channel);
gboolean     gtk_wave_set_scroll         (GtkWaveSet *ws, gint pixels);

#endif /* __GTK_WAVE_SET_H__ */
