# GNU Enterprise Forms - GTK UI Driver - About Box
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: about.py 7008 2005-02-11 17:03:06Z reinhard $

import gtk
import types

from gnue.common.apps import i18n

# =============================================================================
# Class implementing an about box for GTK2
# =============================================================================

class AboutBox (gtk.Dialog):

  # ---------------------------------------------------------------------------
  # Constructor
  # ---------------------------------------------------------------------------

  def __init__ (self, params, form):
    title = u_("About %s") % params.get ('name', 'Unknown')
    gtk.Dialog.__init__ (self, title, None, gtk.DIALOG_MODAL,
                         (gtk.STOCK_OK, gtk.RESPONSE_OK))
    self.set_border_width (5)
    self.vbox.set_spacing (8)

    box = gtk.Frame (" GNUe Forms ")
    tbl = gtk.Table (2, 2)
    tbl.set_border_width (8)
    tbl.set_col_spacings (8)

    params ['ui_driver'] = 'GTK2'

    labels = []
    items  = []

    labels.append (self._newLabel (u_("Version:"), tbl, 0, 1, 0, 1))
    labels.append (self._newLabel (u_("Driver:"), tbl, 0, 1, 1, 2))

    items.append (self._newLabel (params ['appversion'], tbl, 1, 2, 0, 1))
    items.append (self._newLabel (params ['ui_driver'], tbl, 1, 2, 1, 2))

    box.add (tbl)
    tbl.show ()

    self.vbox.pack_start (box)
    box.show ()

    box = gtk.Frame (u_(" Form Information "))
    tbl = gtk.Table (4, 2)
    tbl.set_border_width (8)
    tbl.set_col_spacings (8)

    labels.append (self._newLabel (u_("Name:"),        tbl, 0, 1, 0, 1))
    labels.append (self._newLabel (u_("Version:"),     tbl, 0, 1, 1, 2))
    labels.append (self._newLabel (u_("Author:"),      tbl, 0, 1, 2, 3))
    labels.append (self._newLabel (u_("Description:"), tbl, 0, 1, 3, 4))

    items.append (self._newLabel (params ['name'],        tbl, 1, 2, 0, 1))
    items.append (self._newLabel (params ['formversion'], tbl, 1, 2, 1, 2))
    items.append (self._newLabel (params ['author'],      tbl, 1, 2, 2, 3))
    l = self._newLabel (params ['description'], tbl, 1, 2, 3, 4)
    l.set_line_wrap (True)
    items.append (l)

    box.add (tbl)
    tbl.show ()

    self.vbox.pack_start (box)
    box.show ()

    self._resizeLabels (labels)
    self._resizeLabels (items)


  # ---------------------------------------------------------------------------
  # Resize all labels in a sequence to the same width
  # ---------------------------------------------------------------------------

  def _resizeLabels (self, labels):
    """
    This function determines the widest label in the sequence and sets all
    items to this width.
    @param labels: sequence of gtk.Label instances
    """
    maxW = 0
    for item in labels:
      maxW = max (maxW, item.size_request () [0])

    for item in labels:
      item.set_size_request (maxW, -1)


  # ---------------------------------------------------------------------------
  # Create a new left- and top-aligned label and attach it to a given table
  # ---------------------------------------------------------------------------

  def _newLabel (self, text, table, left, right, top, bottom):
    if isinstance (text, types.StringType):
      text = unicode (text, i18n.encoding)
    result = gtk.Label (text)
    result.set_alignment (0, 0)
    table.attach (result, left, right, top, bottom)
    result.show ()
    return result

if __name__ == '__main__':
  parameters = {
    'appversion'  : 'app-version',
    'ui_driver'   : 'ui-driver-name',
    'name'        : "form-name",
    'formversion' : "form-version",
    'author'      : "form-author",
    'description' : "this is a description to the form. it "
                    "could be a much "
                    "longer text than one would excpet."
  }

  x = AboutBox (parameters, None)
  x.run ()
  x.destroy ()
