/*
**  FilteringView.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "FilteringView.h"

#include "ExtendedTableColumn.h"
#include "FilteringViewController.h"
#include "Constants.h"
#include "LabelWidget.h"
#include "SwitchTableView.h"

@implementation FilteringView

//
//
//
- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;
  
  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(rulesColumn);
  RELEASE(activeColumn);
  RELEASE(tableView);
  
  [super dealloc];
}


//
//
//
- (void) layoutView
{
  ExtendedButtonCell *cell;
  LabelWidget *label;
  
  label = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,195,430,35)
		       label: _(@"In this panel, you can add Filters used by GNUMail.app to perform\nactions when sending or receiving mails.")];
  [self addSubview: label];

  rulesColumn = [[NSTableColumn alloc] initWithIdentifier: @"rules"];
  [rulesColumn setEditable: NO];
  [[rulesColumn headerCell] setStringValue: _(@"Rules")];
  [rulesColumn setMinWidth: 275];

  activeColumn = [[ExtendedTableColumn alloc] initWithIdentifier: @"active"];
  [activeColumn setEditable: NO];
  
  // We set our custom cell for the active column
  cell = [[ExtendedButtonCell alloc] init];
  [cell setButtonType: NSSwitchButton];
  [cell setImagePosition: NSImageOnly];
  [activeColumn setDataCell: cell];
  [activeColumn setShouldUseAndSetState: YES];
  [activeColumn setShouldUseMouse: YES];
  RELEASE(cell);

  [[activeColumn headerCell] setStringValue: _(@"Active")];
  [activeColumn setMinWidth: 50];
  
  tableView = [[SwitchTableView alloc] initWithFrame: NSMakeRect(5,40,430,145)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: NO];
  [tableView addTableColumn: rulesColumn];
  [tableView addTableColumn: activeColumn];
  [tableView setDataSource: parent];
  [tableView setDelegate: parent];
  [tableView setTarget: parent];
  [tableView setDoubleAction: @selector(edit:)];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,40,430,145)];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView: tableView];
  [self addSubview: scrollView];
  RELEASE(scrollView);
  
  add = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,75,ButtonHeight)];
  [add setTitle: _(@"Add")];
  [add setTarget: parent];
  [add setAction: @selector(add:)];
  [self addSubview: add];
  RELEASE(add);
  
  edit = [[NSButton alloc] initWithFrame: NSMakeRect(85,5,75,ButtonHeight)];
  [edit setTitle: _(@"Edit")];
  [edit setTarget: parent];
  [edit setAction: @selector(edit:)];
  [self addSubview: edit];
  RELEASE(edit);

  delete = [[NSButton alloc] initWithFrame: NSMakeRect(165,5,75,ButtonHeight)];
  [delete setTitle: _(@"Delete")];
  [delete setTarget: parent];
  [delete setAction: @selector(delete:)];
  [self addSubview: delete];
  RELEASE(delete);

  duplicate = [[NSButton alloc] initWithFrame: NSMakeRect(245,5,75,ButtonHeight)];
  [duplicate setTitle: _(@"Duplicate")];
  [duplicate setTarget: parent];
  [duplicate setAction: @selector(duplicate:)];
  [self addSubview: duplicate];
  RELEASE(duplicate);

  moveUp = [[NSButton alloc] initWithFrame: NSMakeRect(330,5,50,ButtonHeight)];
  [moveUp setTitle: @""];
  [moveUp setImagePosition: NSImageOnly];
  [moveUp setImage: [NSImage imageNamed: @"sort_up.tiff"]];
  [moveUp setTarget: parent];
  [moveUp setAction: @selector(moveUp:)];
  [self addSubview: moveUp];
  RELEASE(moveUp);
  
  moveDown = [[NSButton alloc] initWithFrame: NSMakeRect(385,5,50,ButtonHeight)];
  [moveDown setTitle: @""];
  [moveDown setImagePosition: NSImageOnly];
  [moveDown setImage: [NSImage imageNamed: @"sort_down.tiff"]];
  [moveDown setTarget: parent];
  [moveDown setAction: @selector(moveDown:)];
  [self addSubview: moveDown];
  RELEASE(moveDown);
}

@end

