/*
**  TaskManager.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_TaskManager
#define _GNUMail_H_TaskManager

#include <Foundation/NSObject.h>

@class Filter;
@class Message;
@class NSConnection;
@class NSData;
@class NSMutableArray;
@class NSTimer;
@class POP3Folder;
@class Task;

@interface TaskManager : NSObject
{
  @public
    BOOL mustStopCurrentTask;

  @private
    NSConnection *connection;
    NSTimer *timer;
}

- (oneway void) fire;
- (void) run: (id) thePorts;
- (void) stop;
- (void) stopCurrentTask;

//
// Class methods
//
+ (TaskManager *) singleInstance;

@end


//
// TaskManager private interface
//
@interface TaskManager (Private)

- (void) _executeActionUsingFilter: (Filter *) theFilter
                           message: (NSData *) theMessage
                              task: (Task *) theTask;

- (void) _matchFilterRuleFromRawSource: (NSData *) theRawSource
                                  task: (Task *) theTask;

- (id) _mustStopTransfer;

- (void) _nextTask;

- (void) _receiveUsingIMAPForTask: (Task *) theTask;
- (void) _receiveUsingPOP3ForTask: (Task *) theTask;
- (void) _receiveUsingUNIXForTask: (Task *) theTask;

- (void) _sendUsingSendmailForTask: (Task *) theTask;
- (void) _sendUsingSMTPForTask: (Task *) theTask;

- (int) _transferMessagesFromPOP3Folder: (POP3Folder *) theFolder
                                   task: (Task *) theTask;

@end

#endif // _GNUMail_H_TaskManager
